<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerRelationship StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerRelationship extends AbstractStructBase
{
    /**
     * The RelationshipBusinessPartnerUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $RelationshipBusinessPartnerUUID;
    /**
     * The RelationshipBusinessPartnerInternalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelationshipBusinessPartnerInternalID;
    /**
     * The RoleCode
     * @var \StructType\BusinessPartnerRelationshipRoleCode
     */
    public $RoleCode;
    /**
     * Constructor method for CustomerReponseCustomerRelationship
     * @uses CustomerReponseCustomerRelationship::setRelationshipBusinessPartnerUUID()
     * @uses CustomerReponseCustomerRelationship::setRelationshipBusinessPartnerInternalID()
     * @uses CustomerReponseCustomerRelationship::setRoleCode()
     * @param \StructType\UUID $relationshipBusinessPartnerUUID
     * @param string $relationshipBusinessPartnerInternalID
     * @param \StructType\BusinessPartnerRelationshipRoleCode $roleCode
     */
    public function __construct(\StructType\UUID $relationshipBusinessPartnerUUID = null, $relationshipBusinessPartnerInternalID = null, \StructType\BusinessPartnerRelationshipRoleCode $roleCode = null)
    {
        $this
            ->setRelationshipBusinessPartnerUUID($relationshipBusinessPartnerUUID)
            ->setRelationshipBusinessPartnerInternalID($relationshipBusinessPartnerInternalID)
            ->setRoleCode($roleCode);
    }
    /**
     * Get RelationshipBusinessPartnerUUID value
     * @return \StructType\UUID|null
     */
    public function getRelationshipBusinessPartnerUUID()
    {
        return $this->RelationshipBusinessPartnerUUID;
    }
    /**
     * Set RelationshipBusinessPartnerUUID value
     * @param \StructType\UUID $relationshipBusinessPartnerUUID
     * @return \StructType\CustomerReponseCustomerRelationship
     */
    public function setRelationshipBusinessPartnerUUID(\StructType\UUID $relationshipBusinessPartnerUUID = null)
    {
        $this->RelationshipBusinessPartnerUUID = $relationshipBusinessPartnerUUID;
        return $this;
    }
    /**
     * Get RelationshipBusinessPartnerInternalID value
     * @return string|null
     */
    public function getRelationshipBusinessPartnerInternalID()
    {
        return $this->RelationshipBusinessPartnerInternalID;
    }
    /**
     * Set RelationshipBusinessPartnerInternalID value
     * @param string $relationshipBusinessPartnerInternalID
     * @return \StructType\CustomerReponseCustomerRelationship
     */
    public function setRelationshipBusinessPartnerInternalID($relationshipBusinessPartnerInternalID = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipBusinessPartnerInternalID) && !is_string($relationshipBusinessPartnerInternalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipBusinessPartnerInternalID, true), gettype($relationshipBusinessPartnerInternalID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($relationshipBusinessPartnerInternalID) && mb_strlen($relationshipBusinessPartnerInternalID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($relationshipBusinessPartnerInternalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($relationshipBusinessPartnerInternalID) && mb_strlen($relationshipBusinessPartnerInternalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($relationshipBusinessPartnerInternalID)), __LINE__);
        }
        $this->RelationshipBusinessPartnerInternalID = $relationshipBusinessPartnerInternalID;
        return $this;
    }
    /**
     * Get RoleCode value
     * @return \StructType\BusinessPartnerRelationshipRoleCode|null
     */
    public function getRoleCode()
    {
        return $this->RoleCode;
    }
    /**
     * Set RoleCode value
     * @param \StructType\BusinessPartnerRelationshipRoleCode $roleCode
     * @return \StructType\CustomerReponseCustomerRelationship
     */
    public function setRoleCode(\StructType\BusinessPartnerRelationshipRoleCode $roleCode = null)
    {
        $this->RoleCode = $roleCode;
        return $this;
    }
}
