<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerGeneralProductTaxExemption
 * StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerGeneralProductTaxExemption extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The RegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $RegionCode;
    /**
     * The TaxTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxTypeCode
     */
    public $TaxTypeCode;
    /**
     * The ReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxExemptionReasonCode
     */
    public $ReasonCode;
    /**
     * Constructor method for CustomerReponseCustomerGeneralProductTaxExemption
     * @uses CustomerReponseCustomerGeneralProductTaxExemption::setCountryCode()
     * @uses CustomerReponseCustomerGeneralProductTaxExemption::setRegionCode()
     * @uses CustomerReponseCustomerGeneralProductTaxExemption::setTaxTypeCode()
     * @uses CustomerReponseCustomerGeneralProductTaxExemption::setReasonCode()
     * @param string $countryCode
     * @param \StructType\RegionCode $regionCode
     * @param \StructType\TaxTypeCode $taxTypeCode
     * @param \StructType\TaxExemptionReasonCode $reasonCode
     */
    public function __construct($countryCode = null, \StructType\RegionCode $regionCode = null, \StructType\TaxTypeCode $taxTypeCode = null, \StructType\TaxExemptionReasonCode $reasonCode = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setRegionCode($regionCode)
            ->setTaxTypeCode($taxTypeCode)
            ->setReasonCode($reasonCode);
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CustomerReponseCustomerGeneralProductTaxExemption
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get RegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param \StructType\RegionCode $regionCode
     * @return \StructType\CustomerReponseCustomerGeneralProductTaxExemption
     */
    public function setRegionCode(\StructType\RegionCode $regionCode = null)
    {
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return \StructType\TaxTypeCode|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param \StructType\TaxTypeCode $taxTypeCode
     * @return \StructType\CustomerReponseCustomerGeneralProductTaxExemption
     */
    public function setTaxTypeCode(\StructType\TaxTypeCode $taxTypeCode = null)
    {
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get ReasonCode value
     * @return \StructType\TaxExemptionReasonCode|null
     */
    public function getReasonCode()
    {
        return $this->ReasonCode;
    }
    /**
     * Set ReasonCode value
     * @param \StructType\TaxExemptionReasonCode $reasonCode
     * @return \StructType\CustomerReponseCustomerGeneralProductTaxExemption
     */
    public function setReasonCode(\StructType\TaxExemptionReasonCode $reasonCode = null)
    {
        $this->ReasonCode = $reasonCode;
        return $this;
    }
}
