<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerDirectResponsibility StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerDirectResponsibility extends AbstractStructBase
{
    /**
     * The PartyRoleCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartyRoleCode;
    /**
     * The EmployeeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeID
     */
    public $EmployeeID;
    /**
     * Constructor method for CustomerReponseCustomerDirectResponsibility
     * @uses CustomerReponseCustomerDirectResponsibility::setPartyRoleCode()
     * @uses CustomerReponseCustomerDirectResponsibility::setEmployeeID()
     * @param string $partyRoleCode
     * @param \StructType\EmployeeID $employeeID
     */
    public function __construct($partyRoleCode = null, \StructType\EmployeeID $employeeID = null)
    {
        $this
            ->setPartyRoleCode($partyRoleCode)
            ->setEmployeeID($employeeID);
    }
    /**
     * Get PartyRoleCode value
     * @return string|null
     */
    public function getPartyRoleCode()
    {
        return $this->PartyRoleCode;
    }
    /**
     * Set PartyRoleCode value
     * @param string $partyRoleCode
     * @return \StructType\CustomerReponseCustomerDirectResponsibility
     */
    public function setPartyRoleCode($partyRoleCode = null)
    {
        // validation for constraint: string
        if (!is_null($partyRoleCode) && !is_string($partyRoleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyRoleCode, true), gettype($partyRoleCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($partyRoleCode) && mb_strlen($partyRoleCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($partyRoleCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partyRoleCode) && mb_strlen($partyRoleCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partyRoleCode)), __LINE__);
        }
        $this->PartyRoleCode = $partyRoleCode;
        return $this;
    }
    /**
     * Get EmployeeID value
     * @return \StructType\EmployeeID|null
     */
    public function getEmployeeID()
    {
        return $this->EmployeeID;
    }
    /**
     * Set EmployeeID value
     * @param \StructType\EmployeeID $employeeID
     * @return \StructType\CustomerReponseCustomerDirectResponsibility
     */
    public function setEmployeeID(\StructType\EmployeeID $employeeID = null)
    {
        $this->EmployeeID = $employeeID;
        return $this;
    }
}
