<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerContactPersonTelephone StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerContactPersonTelephone extends AbstractStructBase
{
    /**
     * The FormattedNumberDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * @var string
     */
    public $FormattedNumberDescription;
    /**
     * The MobilePhoneNumberIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $MobilePhoneNumberIndicator;
    /**
     * Constructor method for CustomerReponseCustomerContactPersonTelephone
     * @uses CustomerReponseCustomerContactPersonTelephone::setFormattedNumberDescription()
     * @uses CustomerReponseCustomerContactPersonTelephone::setMobilePhoneNumberIndicator()
     * @param string $formattedNumberDescription
     * @param bool $mobilePhoneNumberIndicator
     */
    public function __construct($formattedNumberDescription = null, $mobilePhoneNumberIndicator = null)
    {
        $this
            ->setFormattedNumberDescription($formattedNumberDescription)
            ->setMobilePhoneNumberIndicator($mobilePhoneNumberIndicator);
    }
    /**
     * Get FormattedNumberDescription value
     * @return string|null
     */
    public function getFormattedNumberDescription()
    {
        return $this->FormattedNumberDescription;
    }
    /**
     * Set FormattedNumberDescription value
     * @param string $formattedNumberDescription
     * @return \StructType\CustomerReponseCustomerContactPersonTelephone
     */
    public function setFormattedNumberDescription($formattedNumberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($formattedNumberDescription) && !is_string($formattedNumberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedNumberDescription, true), gettype($formattedNumberDescription)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($formattedNumberDescription) && mb_strlen($formattedNumberDescription) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($formattedNumberDescription)), __LINE__);
        }
        $this->FormattedNumberDescription = $formattedNumberDescription;
        return $this;
    }
    /**
     * Get MobilePhoneNumberIndicator value
     * @return bool|null
     */
    public function getMobilePhoneNumberIndicator()
    {
        return $this->MobilePhoneNumberIndicator;
    }
    /**
     * Set MobilePhoneNumberIndicator value
     * @param bool $mobilePhoneNumberIndicator
     * @return \StructType\CustomerReponseCustomerContactPersonTelephone
     */
    public function setMobilePhoneNumberIndicator($mobilePhoneNumberIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($mobilePhoneNumberIndicator) && !is_bool($mobilePhoneNumberIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mobilePhoneNumberIndicator, true), gettype($mobilePhoneNumberIndicator)), __LINE__);
        }
        $this->MobilePhoneNumberIndicator = $mobilePhoneNumberIndicator;
        return $this;
    }
}
