<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseContactPersonResponsibleEmployee StructType
 * @subpackage Structs
 */
class CustomerReponseContactPersonResponsibleEmployee extends AbstractStructBase
{
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The ResponsibleEmployeeUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $ResponsibleEmployeeUUID;
    /**
     * The ResponsibleEmployeeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmployeeID
     */
    public $ResponsibleEmployeeID;
    /**
     * The PartyRoleCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PartyRoleCode;
    /**
     * The GroupwareSubscriptionIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $GroupwareSubscriptionIndicator;
    /**
     * Constructor method for CustomerReponseContactPersonResponsibleEmployee
     * @uses CustomerReponseContactPersonResponsibleEmployee::setUUID()
     * @uses CustomerReponseContactPersonResponsibleEmployee::setResponsibleEmployeeUUID()
     * @uses CustomerReponseContactPersonResponsibleEmployee::setResponsibleEmployeeID()
     * @uses CustomerReponseContactPersonResponsibleEmployee::setPartyRoleCode()
     * @uses CustomerReponseContactPersonResponsibleEmployee::setGroupwareSubscriptionIndicator()
     * @param \StructType\UUID $uUID
     * @param \StructType\UUID $responsibleEmployeeUUID
     * @param \StructType\EmployeeID $responsibleEmployeeID
     * @param string $partyRoleCode
     * @param bool $groupwareSubscriptionIndicator
     */
    public function __construct(\StructType\UUID $uUID = null, \StructType\UUID $responsibleEmployeeUUID = null, \StructType\EmployeeID $responsibleEmployeeID = null, $partyRoleCode = null, $groupwareSubscriptionIndicator = null)
    {
        $this
            ->setUUID($uUID)
            ->setResponsibleEmployeeUUID($responsibleEmployeeUUID)
            ->setResponsibleEmployeeID($responsibleEmployeeID)
            ->setPartyRoleCode($partyRoleCode)
            ->setGroupwareSubscriptionIndicator($groupwareSubscriptionIndicator);
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\CustomerReponseContactPersonResponsibleEmployee
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get ResponsibleEmployeeUUID value
     * @return \StructType\UUID|null
     */
    public function getResponsibleEmployeeUUID()
    {
        return $this->ResponsibleEmployeeUUID;
    }
    /**
     * Set ResponsibleEmployeeUUID value
     * @param \StructType\UUID $responsibleEmployeeUUID
     * @return \StructType\CustomerReponseContactPersonResponsibleEmployee
     */
    public function setResponsibleEmployeeUUID(\StructType\UUID $responsibleEmployeeUUID = null)
    {
        $this->ResponsibleEmployeeUUID = $responsibleEmployeeUUID;
        return $this;
    }
    /**
     * Get ResponsibleEmployeeID value
     * @return \StructType\EmployeeID|null
     */
    public function getResponsibleEmployeeID()
    {
        return $this->ResponsibleEmployeeID;
    }
    /**
     * Set ResponsibleEmployeeID value
     * @param \StructType\EmployeeID $responsibleEmployeeID
     * @return \StructType\CustomerReponseContactPersonResponsibleEmployee
     */
    public function setResponsibleEmployeeID(\StructType\EmployeeID $responsibleEmployeeID = null)
    {
        $this->ResponsibleEmployeeID = $responsibleEmployeeID;
        return $this;
    }
    /**
     * Get PartyRoleCode value
     * @return string|null
     */
    public function getPartyRoleCode()
    {
        return $this->PartyRoleCode;
    }
    /**
     * Set PartyRoleCode value
     * @param string $partyRoleCode
     * @return \StructType\CustomerReponseContactPersonResponsibleEmployee
     */
    public function setPartyRoleCode($partyRoleCode = null)
    {
        // validation for constraint: string
        if (!is_null($partyRoleCode) && !is_string($partyRoleCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyRoleCode, true), gettype($partyRoleCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($partyRoleCode) && mb_strlen($partyRoleCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($partyRoleCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($partyRoleCode) && mb_strlen($partyRoleCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($partyRoleCode)), __LINE__);
        }
        $this->PartyRoleCode = $partyRoleCode;
        return $this;
    }
    /**
     * Get GroupwareSubscriptionIndicator value
     * @return bool|null
     */
    public function getGroupwareSubscriptionIndicator()
    {
        return $this->GroupwareSubscriptionIndicator;
    }
    /**
     * Set GroupwareSubscriptionIndicator value
     * @param bool $groupwareSubscriptionIndicator
     * @return \StructType\CustomerReponseContactPersonResponsibleEmployee
     */
    public function setGroupwareSubscriptionIndicator($groupwareSubscriptionIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupwareSubscriptionIndicator) && !is_bool($groupwareSubscriptionIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupwareSubscriptionIndicator, true), gettype($groupwareSubscriptionIndicator)), __LINE__);
        }
        $this->GroupwareSubscriptionIndicator = $groupwareSubscriptionIndicator;
        return $this;
    }
}
