<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessAttachmentFolder StructType
 * @subpackage Structs
 */
class AccessAttachmentFolder extends AbstractStructBase
{
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The Document
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccessAttachmentFolderDocument[]
     */
    public $Document;
    /**
     * Constructor method for AccessAttachmentFolder
     * @uses AccessAttachmentFolder::setUUID()
     * @uses AccessAttachmentFolder::setDocument()
     * @param \StructType\UUID $uUID
     * @param \StructType\AccessAttachmentFolderDocument[] $document
     */
    public function __construct(\StructType\UUID $uUID = null, array $document = array())
    {
        $this
            ->setUUID($uUID)
            ->setDocument($document);
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\AccessAttachmentFolder
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\AccessAttachmentFolderDocument[]|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * This method is responsible for validating the values passed to the setDocument method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocument method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentForArrayConstraintsFromSetDocument(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accessAttachmentFolderDocumentItem) {
            // validation for constraint: itemType
            if (!$accessAttachmentFolderDocumentItem instanceof \StructType\AccessAttachmentFolderDocument) {
                $invalidValues[] = is_object($accessAttachmentFolderDocumentItem) ? get_class($accessAttachmentFolderDocumentItem) : sprintf('%s(%s)', gettype($accessAttachmentFolderDocumentItem), var_export($accessAttachmentFolderDocumentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Document property can only contain items of type \StructType\AccessAttachmentFolderDocument, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Document value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessAttachmentFolderDocument[] $document
     * @return \StructType\AccessAttachmentFolder
     */
    public function setDocument(array $document = array())
    {
        // validation for constraint: array
        if ('' !== ($documentArrayErrorMessage = self::validateDocumentForArrayConstraintsFromSetDocument($document))) {
            throw new \InvalidArgumentException($documentArrayErrorMessage, __LINE__);
        }
        $this->Document = $document;
        return $this;
    }
    /**
     * Add item to Document value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessAttachmentFolderDocument $item
     * @return \StructType\AccessAttachmentFolder
     */
    public function addToDocument(\StructType\AccessAttachmentFolderDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessAttachmentFolderDocument) {
            throw new \InvalidArgumentException(sprintf('The Document property can only contain items of type \StructType\AccessAttachmentFolderDocument, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Document[] = $item;
        return $this;
    }
}
