<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named FindByIdentification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerByIdentificationQueryMessage_sync $customerByIdentificationQuery_sync
     * @return \StructType\CustomerResponseMessage_sync|bool
     */
    public function FindByIdentification(\StructType\CustomerByIdentificationQueryMessage_sync $customerByIdentificationQuery_sync)
    {
        try {
            $this->setResult($this->getSoapClient()->FindByIdentification($customerByIdentificationQuery_sync));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindByCommunicationData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerByCommunicationDataQueryMessage_sync $customerByCommunicationDataQuery_sync
     * @return \StructType\CustomerResponseMessage_sync|bool
     */
    public function FindByCommunicationData(\StructType\CustomerByCommunicationDataQueryMessage_sync $customerByCommunicationDataQuery_sync)
    {
        try {
            $this->setResult($this->getSoapClient()->FindByCommunicationData($customerByCommunicationDataQuery_sync));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named FindByElements
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CustomerByElementsQueryMessage_sync $customerByElementsQuery_sync
     * @return \StructType\CustomerResponseMessage_sync|bool
     */
    public function FindByElements(\StructType\CustomerByElementsQueryMessage_sync $customerByElementsQuery_sync)
    {
        try {
            $this->setResult($this->getSoapClient()->FindByElements($customerByElementsQuery_sync));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CustomerResponseMessage_sync
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
