<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UUID StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifier
 * - base: xsd:token
 * - maxLength: 36
 * - minLength: 36
 * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
 * @subpackage Structs
 */
class UUID extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 36
     * - minLength: 36
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $_;
    /**
     * The schemeID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeID;
    /**
     * The schemeAgencyID
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * @var string
     */
    public $schemeAgencyID;
    /**
     * Constructor method for UUID
     * @uses UUID::set_()
     * @uses UUID::setSchemeID()
     * @uses UUID::setSchemeAgencyID()
     * @param string $_
     * @param string $schemeID
     * @param string $schemeAgencyID
     */
    public function __construct($_ = null, $schemeID = null, $schemeAgencyID = null)
    {
        $this
            ->set_($_)
            ->setSchemeID($schemeID)
            ->setSchemeAgencyID($schemeAgencyID);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\UUID
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxLength(36)
        if (!is_null($_) && mb_strlen($_) > 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 36', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: minLength(36)
        if (!is_null($_) && mb_strlen($_) < 36) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 36', mb_strlen($_)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($_) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($_, true)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get schemeID value
     * @return string|null
     */
    public function getSchemeID()
    {
        return $this->schemeID;
    }
    /**
     * Set schemeID value
     * @param string $schemeID
     * @return \StructType\UUID
     */
    public function setSchemeID($schemeID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeID) && !is_string($schemeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeID, true), gettype($schemeID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeID) && mb_strlen($schemeID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeID) && mb_strlen($schemeID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeID)), __LINE__);
        }
        $this->schemeID = $schemeID;
        return $this;
    }
    /**
     * Get schemeAgencyID value
     * @return string|null
     */
    public function getSchemeAgencyID()
    {
        return $this->schemeAgencyID;
    }
    /**
     * Set schemeAgencyID value
     * @param string $schemeAgencyID
     * @return \StructType\UUID
     */
    public function setSchemeAgencyID($schemeAgencyID = null)
    {
        // validation for constraint: string
        if (!is_null($schemeAgencyID) && !is_string($schemeAgencyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeAgencyID, true), gettype($schemeAgencyID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($schemeAgencyID) && mb_strlen($schemeAgencyID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($schemeAgencyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($schemeAgencyID) && mb_strlen($schemeAgencyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($schemeAgencyID)), __LINE__);
        }
        $this->schemeAgencyID = $schemeAgencyID;
        return $this;
    }
}
