<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UPPEROPEN_TimePeriod StructType
 * @subpackage Structs
 */
class UPPEROPEN_TimePeriod extends AbstractStructBase
{
    /**
     * The StartTime
     * Meta information extracted from the WSDL
     * - documentation: Time
     * - base: xsd:time
     * - minOccurs: 0
     * - pattern: [0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $StartTime;
    /**
     * The EndTime
     * Meta information extracted from the WSDL
     * - documentation: Time
     * - base: xsd:time
     * - minOccurs: 0
     * - pattern: [0-9]{2}:[0-9]{2}:[0-9]{2}
     * @var string
     */
    public $EndTime;
    /**
     * Constructor method for UPPEROPEN_TimePeriod
     * @uses UPPEROPEN_TimePeriod::setStartTime()
     * @uses UPPEROPEN_TimePeriod::setEndTime()
     * @param string $startTime
     * @param string $endTime
     */
    public function __construct($startTime = null, $endTime = null)
    {
        $this
            ->setStartTime($startTime)
            ->setEndTime($endTime);
    }
    /**
     * Get StartTime value
     * @return string|null
     */
    public function getStartTime()
    {
        return $this->StartTime;
    }
    /**
     * Set StartTime value
     * @param string $startTime
     * @return \StructType\UPPEROPEN_TimePeriod
     */
    public function setStartTime($startTime = null)
    {
        // validation for constraint: string
        if (!is_null($startTime) && !is_string($startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTime, true), gettype($startTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}:[0-9]{2}:[0-9]{2})
        if (!is_null($startTime) && !preg_match('/[0-9]{2}:[0-9]{2}:[0-9]{2}/', $startTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}:[0-9]{2}:[0-9]{2}', var_export($startTime, true)), __LINE__);
        }
        $this->StartTime = $startTime;
        return $this;
    }
    /**
     * Get EndTime value
     * @return string|null
     */
    public function getEndTime()
    {
        return $this->EndTime;
    }
    /**
     * Set EndTime value
     * @param string $endTime
     * @return \StructType\UPPEROPEN_TimePeriod
     */
    public function setEndTime($endTime = null)
    {
        // validation for constraint: string
        if (!is_null($endTime) && !is_string($endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTime, true), gettype($endTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{2}:[0-9]{2}:[0-9]{2})
        if (!is_null($endTime) && !preg_match('/[0-9]{2}:[0-9]{2}:[0-9]{2}/', $endTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{2}:[0-9]{2}:[0-9]{2}', var_export($endTime, true)), __LINE__);
        }
        $this->EndTime = $endTime;
        return $this;
    }
}
