<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SelectionByIndicator StructType
 * @subpackage Structs
 */
class SelectionByIndicator extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $LowerBoundaryIndicator;
    /**
     * The UpperBoundaryIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $UpperBoundaryIndicator;
    /**
     * Constructor method for SelectionByIndicator
     * @uses SelectionByIndicator::setInclusionExclusionCode()
     * @uses SelectionByIndicator::setIntervalBoundaryTypeCode()
     * @uses SelectionByIndicator::setLowerBoundaryIndicator()
     * @uses SelectionByIndicator::setUpperBoundaryIndicator()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param bool $lowerBoundaryIndicator
     * @param bool $upperBoundaryIndicator
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryIndicator = null, $upperBoundaryIndicator = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryIndicator($lowerBoundaryIndicator)
            ->setUpperBoundaryIndicator($upperBoundaryIndicator);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\SelectionByIndicator
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\SelectionByIndicator
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryIndicator value
     * @return bool|null
     */
    public function getLowerBoundaryIndicator()
    {
        return $this->LowerBoundaryIndicator;
    }
    /**
     * Set LowerBoundaryIndicator value
     * @param bool $lowerBoundaryIndicator
     * @return \StructType\SelectionByIndicator
     */
    public function setLowerBoundaryIndicator($lowerBoundaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($lowerBoundaryIndicator) && !is_bool($lowerBoundaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lowerBoundaryIndicator, true), gettype($lowerBoundaryIndicator)), __LINE__);
        }
        $this->LowerBoundaryIndicator = $lowerBoundaryIndicator;
        return $this;
    }
    /**
     * Get UpperBoundaryIndicator value
     * @return bool|null
     */
    public function getUpperBoundaryIndicator()
    {
        return $this->UpperBoundaryIndicator;
    }
    /**
     * Set UpperBoundaryIndicator value
     * @param bool $upperBoundaryIndicator
     * @return \StructType\SelectionByIndicator
     */
    public function setUpperBoundaryIndicator($upperBoundaryIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($upperBoundaryIndicator) && !is_bool($upperBoundaryIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upperBoundaryIndicator, true), gettype($upperBoundaryIndicator)), __LINE__);
        }
        $this->UpperBoundaryIndicator = $upperBoundaryIndicator;
        return $this;
    }
}
