<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Measure StructType
 * Meta information extracted from the WSDL
 * - documentation: Measure
 * - base: xsd:decimal
 * - fractionDigits: 14
 * - maxInclusive: 99999999999999999.99999999999999
 * - minInclusive: -99999999999999999.99999999999999
 * - totalDigits: 31
 * @subpackage Structs
 */
class Measure extends AbstractStructBase
{
    /**
     * The unitCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * - use: required
     * @var string
     */
    public $unitCode;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 14
     * - maxInclusive: 99999999999999999.99999999999999
     * - minInclusive: -99999999999999999.99999999999999
     * - totalDigits: 31
     * @var float
     */
    public $_;
    /**
     * Constructor method for Measure
     * @uses Measure::setUnitCode()
     * @uses Measure::set_()
     * @param string $unitCode
     * @param float $_
     */
    public function __construct($unitCode = null, $_ = null)
    {
        $this
            ->setUnitCode($unitCode)
            ->set_($_);
    }
    /**
     * Get unitCode value
     * @return string
     */
    public function getUnitCode()
    {
        return $this->unitCode;
    }
    /**
     * Set unitCode value
     * @param string $unitCode
     * @return \StructType\Measure
     */
    public function setUnitCode($unitCode = null)
    {
        // validation for constraint: string
        if (!is_null($unitCode) && !is_string($unitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($unitCode, true), gettype($unitCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($unitCode) && mb_strlen($unitCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($unitCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($unitCode) && mb_strlen($unitCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($unitCode)), __LINE__);
        }
        $this->unitCode = $unitCode;
        return $this;
    }
    /**
     * Get _ value
     * @return float|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param float $_
     * @return \StructType\Measure
     */
    public function set_($_ = null)
    {
        // validation for constraint: float
        if (!is_null($_) && !(is_float($_) || is_numeric($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: fractionDigits(14)
        if (!is_null($_) && mb_strlen(mb_substr($_, false !== mb_strpos($_, '.') ? mb_strpos($_, '.') + 1 : mb_strlen($_))) > 14) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 14 fraction digits, %d given', var_export($_, true), mb_strlen(mb_substr($_, mb_strpos($_, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(99999999999999999.99999999999999)
        if (!is_null($_) && $_ > 99999999999999999.99999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 99999999999999999.99999999999999', var_export($_, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-99999999999999999.99999999999999)
        if (!is_null($_) && $_ < -99999999999999999.99999999999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -99999999999999999.99999999999999', var_export($_, true)), __LINE__);
        }
        // validation for constraint: totalDigits(31)
        if (!is_null($_) && mb_strlen(preg_replace('/(\D)/', '', $_)) > 31) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 31 digits, "%d" given', var_export($_, true), mb_strlen(preg_replace('/(\D)/', '', $_))), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
