<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormattedPostalAddress StructType
 * @subpackage Structs
 */
class FormattedPostalAddress extends AbstractStructBase
{
    /**
     * The FirstLineDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 80
     * @var string
     */
    public $FirstLineDescription;
    /**
     * The SecondLineDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $SecondLineDescription;
    /**
     * The ThirdLineDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $ThirdLineDescription;
    /**
     * Constructor method for FormattedPostalAddress
     * @uses FormattedPostalAddress::setFirstLineDescription()
     * @uses FormattedPostalAddress::setSecondLineDescription()
     * @uses FormattedPostalAddress::setThirdLineDescription()
     * @param string $firstLineDescription
     * @param string $secondLineDescription
     * @param string $thirdLineDescription
     */
    public function __construct($firstLineDescription = null, $secondLineDescription = null, $thirdLineDescription = null)
    {
        $this
            ->setFirstLineDescription($firstLineDescription)
            ->setSecondLineDescription($secondLineDescription)
            ->setThirdLineDescription($thirdLineDescription);
    }
    /**
     * Get FirstLineDescription value
     * @return string|null
     */
    public function getFirstLineDescription()
    {
        return $this->FirstLineDescription;
    }
    /**
     * Set FirstLineDescription value
     * @param string $firstLineDescription
     * @return \StructType\FormattedPostalAddress
     */
    public function setFirstLineDescription($firstLineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($firstLineDescription) && !is_string($firstLineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstLineDescription, true), gettype($firstLineDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($firstLineDescription) && mb_strlen($firstLineDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($firstLineDescription)), __LINE__);
        }
        $this->FirstLineDescription = $firstLineDescription;
        return $this;
    }
    /**
     * Get SecondLineDescription value
     * @return string|null
     */
    public function getSecondLineDescription()
    {
        return $this->SecondLineDescription;
    }
    /**
     * Set SecondLineDescription value
     * @param string $secondLineDescription
     * @return \StructType\FormattedPostalAddress
     */
    public function setSecondLineDescription($secondLineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($secondLineDescription) && !is_string($secondLineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondLineDescription, true), gettype($secondLineDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($secondLineDescription) && mb_strlen($secondLineDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($secondLineDescription)), __LINE__);
        }
        $this->SecondLineDescription = $secondLineDescription;
        return $this;
    }
    /**
     * Get ThirdLineDescription value
     * @return string|null
     */
    public function getThirdLineDescription()
    {
        return $this->ThirdLineDescription;
    }
    /**
     * Set ThirdLineDescription value
     * @param string $thirdLineDescription
     * @return \StructType\FormattedPostalAddress
     */
    public function setThirdLineDescription($thirdLineDescription = null)
    {
        // validation for constraint: string
        if (!is_null($thirdLineDescription) && !is_string($thirdLineDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thirdLineDescription, true), gettype($thirdLineDescription)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($thirdLineDescription) && mb_strlen($thirdLineDescription) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($thirdLineDescription)), __LINE__);
        }
        $this->ThirdLineDescription = $thirdLineDescription;
        return $this;
    }
}
