<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeFaultData StructType
 * @subpackage Structs
 */
class ExchangeFaultData extends AbstractStructBase
{
    /**
     * The faultText
     * @var string
     */
    public $faultText;
    /**
     * The faultUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $faultUrl;
    /**
     * The faultDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExchangeLogData[]
     */
    public $faultDetail;
    /**
     * Constructor method for ExchangeFaultData
     * @uses ExchangeFaultData::setFaultText()
     * @uses ExchangeFaultData::setFaultUrl()
     * @uses ExchangeFaultData::setFaultDetail()
     * @param string $faultText
     * @param string $faultUrl
     * @param \StructType\ExchangeLogData[] $faultDetail
     */
    public function __construct($faultText = null, $faultUrl = null, array $faultDetail = array())
    {
        $this
            ->setFaultText($faultText)
            ->setFaultUrl($faultUrl)
            ->setFaultDetail($faultDetail);
    }
    /**
     * Get faultText value
     * @return string|null
     */
    public function getFaultText()
    {
        return $this->faultText;
    }
    /**
     * Set faultText value
     * @param string $faultText
     * @return \StructType\ExchangeFaultData
     */
    public function setFaultText($faultText = null)
    {
        // validation for constraint: string
        if (!is_null($faultText) && !is_string($faultText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultText, true), gettype($faultText)), __LINE__);
        }
        $this->faultText = $faultText;
        return $this;
    }
    /**
     * Get faultUrl value
     * @return string|null
     */
    public function getFaultUrl()
    {
        return $this->faultUrl;
    }
    /**
     * Set faultUrl value
     * @param string $faultUrl
     * @return \StructType\ExchangeFaultData
     */
    public function setFaultUrl($faultUrl = null)
    {
        // validation for constraint: string
        if (!is_null($faultUrl) && !is_string($faultUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faultUrl, true), gettype($faultUrl)), __LINE__);
        }
        $this->faultUrl = $faultUrl;
        return $this;
    }
    /**
     * Get faultDetail value
     * @return \StructType\ExchangeLogData[]|null
     */
    public function getFaultDetail()
    {
        return $this->faultDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFaultDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFaultDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFaultDetailForArrayConstraintsFromSetFaultDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $exchangeFaultDataFaultDetailItem) {
            // validation for constraint: itemType
            if (!$exchangeFaultDataFaultDetailItem instanceof \StructType\ExchangeLogData) {
                $invalidValues[] = is_object($exchangeFaultDataFaultDetailItem) ? get_class($exchangeFaultDataFaultDetailItem) : sprintf('%s(%s)', gettype($exchangeFaultDataFaultDetailItem), var_export($exchangeFaultDataFaultDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The faultDetail property can only contain items of type \StructType\ExchangeLogData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set faultDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ExchangeLogData[] $faultDetail
     * @return \StructType\ExchangeFaultData
     */
    public function setFaultDetail(array $faultDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($faultDetailArrayErrorMessage = self::validateFaultDetailForArrayConstraintsFromSetFaultDetail($faultDetail))) {
            throw new \InvalidArgumentException($faultDetailArrayErrorMessage, __LINE__);
        }
        $this->faultDetail = $faultDetail;
        return $this;
    }
    /**
     * Add item to faultDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\ExchangeLogData $item
     * @return \StructType\ExchangeFaultData
     */
    public function addToFaultDetail(\StructType\ExchangeLogData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExchangeLogData) {
            throw new \InvalidArgumentException(sprintf('The faultDetail property can only contain items of type \StructType\ExchangeLogData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->faultDetail[] = $item;
        return $this;
    }
}
