<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Description StructType
 * Meta information extracted from the WSDL
 * - documentation: Description
 * @subpackage Structs
 */
class Description extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The languageCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:language
     * - maxLength: 2
     * - minLength: 2
     * @var string
     */
    public $languageCode;
    /**
     * Constructor method for Description
     * @uses Description::set_()
     * @uses Description::setLanguageCode()
     * @param string $_
     * @param string $languageCode
     */
    public function __construct($_ = null, $languageCode = null)
    {
        $this
            ->set_($_)
            ->setLanguageCode($languageCode);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \StructType\Description
     */
    public function set_($_ = null)
    {
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get languageCode value
     * @return string|null
     */
    public function getLanguageCode()
    {
        return $this->languageCode;
    }
    /**
     * Set languageCode value
     * @param string $languageCode
     * @return \StructType\Description
     */
    public function setLanguageCode($languageCode = null)
    {
        // validation for constraint: string
        if (!is_null($languageCode) && !is_string($languageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($languageCode, true), gettype($languageCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($languageCode) && mb_strlen($languageCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($languageCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($languageCode) && mb_strlen($languageCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($languageCode)), __LINE__);
        }
        $this->languageCode = $languageCode;
        return $this;
    }
}
