<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionBySortingFormattedName StructType
 * @subpackage Structs
 */
class CustomerSelectionBySortingFormattedName extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundarySortingFormattedName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundarySortingFormattedName;
    /**
     * The UpperBoundarySortingFormattedName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundarySortingFormattedName;
    /**
     * Constructor method for CustomerSelectionBySortingFormattedName
     * @uses CustomerSelectionBySortingFormattedName::setInclusionExclusionCode()
     * @uses CustomerSelectionBySortingFormattedName::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionBySortingFormattedName::setLowerBoundarySortingFormattedName()
     * @uses CustomerSelectionBySortingFormattedName::setUpperBoundarySortingFormattedName()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundarySortingFormattedName
     * @param string $upperBoundarySortingFormattedName
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundarySortingFormattedName = null, $upperBoundarySortingFormattedName = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundarySortingFormattedName($lowerBoundarySortingFormattedName)
            ->setUpperBoundarySortingFormattedName($upperBoundarySortingFormattedName);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionBySortingFormattedName
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionBySortingFormattedName
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundarySortingFormattedName value
     * @return string|null
     */
    public function getLowerBoundarySortingFormattedName()
    {
        return $this->LowerBoundarySortingFormattedName;
    }
    /**
     * Set LowerBoundarySortingFormattedName value
     * @param string $lowerBoundarySortingFormattedName
     * @return \StructType\CustomerSelectionBySortingFormattedName
     */
    public function setLowerBoundarySortingFormattedName($lowerBoundarySortingFormattedName = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundarySortingFormattedName) && !is_string($lowerBoundarySortingFormattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundarySortingFormattedName, true), gettype($lowerBoundarySortingFormattedName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($lowerBoundarySortingFormattedName) && mb_strlen($lowerBoundarySortingFormattedName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($lowerBoundarySortingFormattedName)), __LINE__);
        }
        $this->LowerBoundarySortingFormattedName = $lowerBoundarySortingFormattedName;
        return $this;
    }
    /**
     * Get UpperBoundarySortingFormattedName value
     * @return string|null
     */
    public function getUpperBoundarySortingFormattedName()
    {
        return $this->UpperBoundarySortingFormattedName;
    }
    /**
     * Set UpperBoundarySortingFormattedName value
     * @param string $upperBoundarySortingFormattedName
     * @return \StructType\CustomerSelectionBySortingFormattedName
     */
    public function setUpperBoundarySortingFormattedName($upperBoundarySortingFormattedName = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundarySortingFormattedName) && !is_string($upperBoundarySortingFormattedName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundarySortingFormattedName, true), gettype($upperBoundarySortingFormattedName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($upperBoundarySortingFormattedName) && mb_strlen($upperBoundarySortingFormattedName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($upperBoundarySortingFormattedName)), __LINE__);
        }
        $this->UpperBoundarySortingFormattedName = $upperBoundarySortingFormattedName;
        return $this;
    }
}
