<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionBySalesOrganisationID StructType
 * @subpackage Structs
 */
class CustomerSelectionBySalesOrganisationID extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundarySalesOrganisationID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundarySalesOrganisationID;
    /**
     * The UpperBoundarySalesOrganisationID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundarySalesOrganisationID;
    /**
     * Constructor method for CustomerSelectionBySalesOrganisationID
     * @uses CustomerSelectionBySalesOrganisationID::setInclusionExclusionCode()
     * @uses CustomerSelectionBySalesOrganisationID::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionBySalesOrganisationID::setLowerBoundarySalesOrganisationID()
     * @uses CustomerSelectionBySalesOrganisationID::setUpperBoundarySalesOrganisationID()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundarySalesOrganisationID
     * @param string $upperBoundarySalesOrganisationID
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundarySalesOrganisationID = null, $upperBoundarySalesOrganisationID = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundarySalesOrganisationID($lowerBoundarySalesOrganisationID)
            ->setUpperBoundarySalesOrganisationID($upperBoundarySalesOrganisationID);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionBySalesOrganisationID
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionBySalesOrganisationID
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundarySalesOrganisationID value
     * @return string|null
     */
    public function getLowerBoundarySalesOrganisationID()
    {
        return $this->LowerBoundarySalesOrganisationID;
    }
    /**
     * Set LowerBoundarySalesOrganisationID value
     * @param string $lowerBoundarySalesOrganisationID
     * @return \StructType\CustomerSelectionBySalesOrganisationID
     */
    public function setLowerBoundarySalesOrganisationID($lowerBoundarySalesOrganisationID = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundarySalesOrganisationID) && !is_string($lowerBoundarySalesOrganisationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundarySalesOrganisationID, true), gettype($lowerBoundarySalesOrganisationID)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($lowerBoundarySalesOrganisationID) && mb_strlen($lowerBoundarySalesOrganisationID) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($lowerBoundarySalesOrganisationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($lowerBoundarySalesOrganisationID) && mb_strlen($lowerBoundarySalesOrganisationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($lowerBoundarySalesOrganisationID)), __LINE__);
        }
        $this->LowerBoundarySalesOrganisationID = $lowerBoundarySalesOrganisationID;
        return $this;
    }
    /**
     * Get UpperBoundarySalesOrganisationID value
     * @return string|null
     */
    public function getUpperBoundarySalesOrganisationID()
    {
        return $this->UpperBoundarySalesOrganisationID;
    }
    /**
     * Set UpperBoundarySalesOrganisationID value
     * @param string $upperBoundarySalesOrganisationID
     * @return \StructType\CustomerSelectionBySalesOrganisationID
     */
    public function setUpperBoundarySalesOrganisationID($upperBoundarySalesOrganisationID = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundarySalesOrganisationID) && !is_string($upperBoundarySalesOrganisationID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundarySalesOrganisationID, true), gettype($upperBoundarySalesOrganisationID)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($upperBoundarySalesOrganisationID) && mb_strlen($upperBoundarySalesOrganisationID) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($upperBoundarySalesOrganisationID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($upperBoundarySalesOrganisationID) && mb_strlen($upperBoundarySalesOrganisationID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($upperBoundarySalesOrganisationID)), __LINE__);
        }
        $this->UpperBoundarySalesOrganisationID = $upperBoundarySalesOrganisationID;
        return $this;
    }
}
