<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByRoleCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByRoleCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryRoleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessPartnerRoleCode
     */
    public $LowerBoundaryRoleCode;
    /**
     * The UpperBoundaryRoleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessPartnerRoleCode
     */
    public $UpperBoundaryRoleCode;
    /**
     * Constructor method for CustomerSelectionByRoleCode
     * @uses CustomerSelectionByRoleCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByRoleCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByRoleCode::setLowerBoundaryRoleCode()
     * @uses CustomerSelectionByRoleCode::setUpperBoundaryRoleCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\BusinessPartnerRoleCode $lowerBoundaryRoleCode
     * @param \StructType\BusinessPartnerRoleCode $upperBoundaryRoleCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\BusinessPartnerRoleCode $lowerBoundaryRoleCode = null, \StructType\BusinessPartnerRoleCode $upperBoundaryRoleCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryRoleCode($lowerBoundaryRoleCode)
            ->setUpperBoundaryRoleCode($upperBoundaryRoleCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByRoleCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByRoleCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryRoleCode value
     * @return \StructType\BusinessPartnerRoleCode|null
     */
    public function getLowerBoundaryRoleCode()
    {
        return $this->LowerBoundaryRoleCode;
    }
    /**
     * Set LowerBoundaryRoleCode value
     * @param \StructType\BusinessPartnerRoleCode $lowerBoundaryRoleCode
     * @return \StructType\CustomerSelectionByRoleCode
     */
    public function setLowerBoundaryRoleCode(\StructType\BusinessPartnerRoleCode $lowerBoundaryRoleCode = null)
    {
        $this->LowerBoundaryRoleCode = $lowerBoundaryRoleCode;
        return $this;
    }
    /**
     * Get UpperBoundaryRoleCode value
     * @return \StructType\BusinessPartnerRoleCode|null
     */
    public function getUpperBoundaryRoleCode()
    {
        return $this->UpperBoundaryRoleCode;
    }
    /**
     * Set UpperBoundaryRoleCode value
     * @param \StructType\BusinessPartnerRoleCode $upperBoundaryRoleCode
     * @return \StructType\CustomerSelectionByRoleCode
     */
    public function setUpperBoundaryRoleCode(\StructType\BusinessPartnerRoleCode $upperBoundaryRoleCode = null)
    {
        $this->UpperBoundaryRoleCode = $upperBoundaryRoleCode;
        return $this;
    }
}
