<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByPartyIdentifierTypeCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByPartyIdentifierTypeCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryPartyIdentifierTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartyIdentifierTypeCode
     */
    public $LowerBoundaryPartyIdentifierTypeCode;
    /**
     * The UpperBoundaryPartyIdentifierTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartyIdentifierTypeCode
     */
    public $UpperBoundaryPartyIdentifierTypeCode;
    /**
     * Constructor method for CustomerSelectionByPartyIdentifierTypeCode
     * @uses CustomerSelectionByPartyIdentifierTypeCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByPartyIdentifierTypeCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByPartyIdentifierTypeCode::setLowerBoundaryPartyIdentifierTypeCode()
     * @uses CustomerSelectionByPartyIdentifierTypeCode::setUpperBoundaryPartyIdentifierTypeCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\PartyIdentifierTypeCode $lowerBoundaryPartyIdentifierTypeCode
     * @param \StructType\PartyIdentifierTypeCode $upperBoundaryPartyIdentifierTypeCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\PartyIdentifierTypeCode $lowerBoundaryPartyIdentifierTypeCode = null, \StructType\PartyIdentifierTypeCode $upperBoundaryPartyIdentifierTypeCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryPartyIdentifierTypeCode($lowerBoundaryPartyIdentifierTypeCode)
            ->setUpperBoundaryPartyIdentifierTypeCode($upperBoundaryPartyIdentifierTypeCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByPartyIdentifierTypeCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByPartyIdentifierTypeCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryPartyIdentifierTypeCode value
     * @return \StructType\PartyIdentifierTypeCode|null
     */
    public function getLowerBoundaryPartyIdentifierTypeCode()
    {
        return $this->LowerBoundaryPartyIdentifierTypeCode;
    }
    /**
     * Set LowerBoundaryPartyIdentifierTypeCode value
     * @param \StructType\PartyIdentifierTypeCode $lowerBoundaryPartyIdentifierTypeCode
     * @return \StructType\CustomerSelectionByPartyIdentifierTypeCode
     */
    public function setLowerBoundaryPartyIdentifierTypeCode(\StructType\PartyIdentifierTypeCode $lowerBoundaryPartyIdentifierTypeCode = null)
    {
        $this->LowerBoundaryPartyIdentifierTypeCode = $lowerBoundaryPartyIdentifierTypeCode;
        return $this;
    }
    /**
     * Get UpperBoundaryPartyIdentifierTypeCode value
     * @return \StructType\PartyIdentifierTypeCode|null
     */
    public function getUpperBoundaryPartyIdentifierTypeCode()
    {
        return $this->UpperBoundaryPartyIdentifierTypeCode;
    }
    /**
     * Set UpperBoundaryPartyIdentifierTypeCode value
     * @param \StructType\PartyIdentifierTypeCode $upperBoundaryPartyIdentifierTypeCode
     * @return \StructType\CustomerSelectionByPartyIdentifierTypeCode
     */
    public function setUpperBoundaryPartyIdentifierTypeCode(\StructType\PartyIdentifierTypeCode $upperBoundaryPartyIdentifierTypeCode = null)
    {
        $this->UpperBoundaryPartyIdentifierTypeCode = $upperBoundaryPartyIdentifierTypeCode;
        return $this;
    }
}
