<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByNormalisedFacsimileNumber StructType
 * @subpackage Structs
 */
class CustomerSelectionByNormalisedFacsimileNumber extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryNormalisedFacsimileNumber
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryNormalisedFacsimileNumber;
    /**
     * The UpperBoundaryNormalisedFacsimileNumber
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryNormalisedFacsimileNumber;
    /**
     * Constructor method for CustomerSelectionByNormalisedFacsimileNumber
     * @uses CustomerSelectionByNormalisedFacsimileNumber::setInclusionExclusionCode()
     * @uses CustomerSelectionByNormalisedFacsimileNumber::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByNormalisedFacsimileNumber::setLowerBoundaryNormalisedFacsimileNumber()
     * @uses CustomerSelectionByNormalisedFacsimileNumber::setUpperBoundaryNormalisedFacsimileNumber()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryNormalisedFacsimileNumber
     * @param string $upperBoundaryNormalisedFacsimileNumber
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryNormalisedFacsimileNumber = null, $upperBoundaryNormalisedFacsimileNumber = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryNormalisedFacsimileNumber($lowerBoundaryNormalisedFacsimileNumber)
            ->setUpperBoundaryNormalisedFacsimileNumber($upperBoundaryNormalisedFacsimileNumber);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByNormalisedFacsimileNumber
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByNormalisedFacsimileNumber
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryNormalisedFacsimileNumber value
     * @return string|null
     */
    public function getLowerBoundaryNormalisedFacsimileNumber()
    {
        return $this->LowerBoundaryNormalisedFacsimileNumber;
    }
    /**
     * Set LowerBoundaryNormalisedFacsimileNumber value
     * @param string $lowerBoundaryNormalisedFacsimileNumber
     * @return \StructType\CustomerSelectionByNormalisedFacsimileNumber
     */
    public function setLowerBoundaryNormalisedFacsimileNumber($lowerBoundaryNormalisedFacsimileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryNormalisedFacsimileNumber) && !is_string($lowerBoundaryNormalisedFacsimileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryNormalisedFacsimileNumber, true), gettype($lowerBoundaryNormalisedFacsimileNumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($lowerBoundaryNormalisedFacsimileNumber) && mb_strlen($lowerBoundaryNormalisedFacsimileNumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($lowerBoundaryNormalisedFacsimileNumber)), __LINE__);
        }
        $this->LowerBoundaryNormalisedFacsimileNumber = $lowerBoundaryNormalisedFacsimileNumber;
        return $this;
    }
    /**
     * Get UpperBoundaryNormalisedFacsimileNumber value
     * @return string|null
     */
    public function getUpperBoundaryNormalisedFacsimileNumber()
    {
        return $this->UpperBoundaryNormalisedFacsimileNumber;
    }
    /**
     * Set UpperBoundaryNormalisedFacsimileNumber value
     * @param string $upperBoundaryNormalisedFacsimileNumber
     * @return \StructType\CustomerSelectionByNormalisedFacsimileNumber
     */
    public function setUpperBoundaryNormalisedFacsimileNumber($upperBoundaryNormalisedFacsimileNumber = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryNormalisedFacsimileNumber) && !is_string($upperBoundaryNormalisedFacsimileNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryNormalisedFacsimileNumber, true), gettype($upperBoundaryNormalisedFacsimileNumber)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($upperBoundaryNormalisedFacsimileNumber) && mb_strlen($upperBoundaryNormalisedFacsimileNumber) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($upperBoundaryNormalisedFacsimileNumber)), __LINE__);
        }
        $this->UpperBoundaryNormalisedFacsimileNumber = $upperBoundaryNormalisedFacsimileNumber;
        return $this;
    }
}
