<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByIndustrialSectorCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByIndustrialSectorCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryIndustrialSectorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IndustrialSectorCode
     */
    public $LowerBoundaryIndustrialSectorCode;
    /**
     * The UpperBoundaryIndustrialSectorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IndustrialSectorCode
     */
    public $UpperBoundaryIndustrialSectorCode;
    /**
     * Constructor method for CustomerSelectionByIndustrialSectorCode
     * @uses CustomerSelectionByIndustrialSectorCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByIndustrialSectorCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByIndustrialSectorCode::setLowerBoundaryIndustrialSectorCode()
     * @uses CustomerSelectionByIndustrialSectorCode::setUpperBoundaryIndustrialSectorCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\IndustrialSectorCode $lowerBoundaryIndustrialSectorCode
     * @param \StructType\IndustrialSectorCode $upperBoundaryIndustrialSectorCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\IndustrialSectorCode $lowerBoundaryIndustrialSectorCode = null, \StructType\IndustrialSectorCode $upperBoundaryIndustrialSectorCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryIndustrialSectorCode($lowerBoundaryIndustrialSectorCode)
            ->setUpperBoundaryIndustrialSectorCode($upperBoundaryIndustrialSectorCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByIndustrialSectorCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByIndustrialSectorCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryIndustrialSectorCode value
     * @return \StructType\IndustrialSectorCode|null
     */
    public function getLowerBoundaryIndustrialSectorCode()
    {
        return $this->LowerBoundaryIndustrialSectorCode;
    }
    /**
     * Set LowerBoundaryIndustrialSectorCode value
     * @param \StructType\IndustrialSectorCode $lowerBoundaryIndustrialSectorCode
     * @return \StructType\CustomerSelectionByIndustrialSectorCode
     */
    public function setLowerBoundaryIndustrialSectorCode(\StructType\IndustrialSectorCode $lowerBoundaryIndustrialSectorCode = null)
    {
        $this->LowerBoundaryIndustrialSectorCode = $lowerBoundaryIndustrialSectorCode;
        return $this;
    }
    /**
     * Get UpperBoundaryIndustrialSectorCode value
     * @return \StructType\IndustrialSectorCode|null
     */
    public function getUpperBoundaryIndustrialSectorCode()
    {
        return $this->UpperBoundaryIndustrialSectorCode;
    }
    /**
     * Set UpperBoundaryIndustrialSectorCode value
     * @param \StructType\IndustrialSectorCode $upperBoundaryIndustrialSectorCode
     * @return \StructType\CustomerSelectionByIndustrialSectorCode
     */
    public function setUpperBoundaryIndustrialSectorCode(\StructType\IndustrialSectorCode $upperBoundaryIndustrialSectorCode = null)
    {
        $this->UpperBoundaryIndustrialSectorCode = $upperBoundaryIndustrialSectorCode;
        return $this;
    }
}
