<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByEmailURI StructType
 * @subpackage Structs
 */
class CustomerSelectionByEmailURI extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryEmailURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailURI
     */
    public $LowerBoundaryEmailURI;
    /**
     * The UpperBoundaryEmailURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailURI
     */
    public $UpperBoundaryEmailURI;
    /**
     * Constructor method for CustomerSelectionByEmailURI
     * @uses CustomerSelectionByEmailURI::setInclusionExclusionCode()
     * @uses CustomerSelectionByEmailURI::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByEmailURI::setLowerBoundaryEmailURI()
     * @uses CustomerSelectionByEmailURI::setUpperBoundaryEmailURI()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\EmailURI $lowerBoundaryEmailURI
     * @param \StructType\EmailURI $upperBoundaryEmailURI
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\EmailURI $lowerBoundaryEmailURI = null, \StructType\EmailURI $upperBoundaryEmailURI = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryEmailURI($lowerBoundaryEmailURI)
            ->setUpperBoundaryEmailURI($upperBoundaryEmailURI);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByEmailURI
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByEmailURI
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryEmailURI value
     * @return \StructType\EmailURI|null
     */
    public function getLowerBoundaryEmailURI()
    {
        return $this->LowerBoundaryEmailURI;
    }
    /**
     * Set LowerBoundaryEmailURI value
     * @param \StructType\EmailURI $lowerBoundaryEmailURI
     * @return \StructType\CustomerSelectionByEmailURI
     */
    public function setLowerBoundaryEmailURI(\StructType\EmailURI $lowerBoundaryEmailURI = null)
    {
        $this->LowerBoundaryEmailURI = $lowerBoundaryEmailURI;
        return $this;
    }
    /**
     * Get UpperBoundaryEmailURI value
     * @return \StructType\EmailURI|null
     */
    public function getUpperBoundaryEmailURI()
    {
        return $this->UpperBoundaryEmailURI;
    }
    /**
     * Set UpperBoundaryEmailURI value
     * @param \StructType\EmailURI $upperBoundaryEmailURI
     * @return \StructType\CustomerSelectionByEmailURI
     */
    public function setUpperBoundaryEmailURI(\StructType\EmailURI $upperBoundaryEmailURI = null)
    {
        $this->UpperBoundaryEmailURI = $upperBoundaryEmailURI;
        return $this;
    }
}
