<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByElements StructType
 * @subpackage Structs
 */
class CustomerSelectionByElements extends AbstractStructBase
{
    /**
     * The SelectionByBusinessPartnerRoleCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByRoleCode[]
     */
    public $SelectionByBusinessPartnerRoleCode;
    /**
     * The SelectionByInternalID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByInternalID[]
     */
    public $SelectionByInternalID;
    /**
     * The SelectionByUUID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByUUID[]
     */
    public $SelectionByUUID;
    /**
     * The SelectionByCategoryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByCategoryCode[]
     */
    public $SelectionByCategoryCode;
    /**
     * The SelectionByBusinessPartnerName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByBusinessPartnerName[]
     */
    public $SelectionByBusinessPartnerName;
    /**
     * The SelectionByBusinessPartnerAdditionalName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByBusinessPartnerAdditionalName[]
     */
    public $SelectionByBusinessPartnerAdditionalName;
    /**
     * The SelectionBySortingFormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionBySortingFormattedName[]
     */
    public $SelectionBySortingFormattedName;
    /**
     * The SelectionByLegalCompetenceIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $SelectionByLegalCompetenceIndicator;
    /**
     * The SelectionByAddressDefaultIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $SelectionByAddressDefaultIndicator;
    /**
     * The SelectionByPostalAddressCityName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByCityName[]
     */
    public $SelectionByPostalAddressCityName;
    /**
     * The SelectionByPostalAddressStreetPostalCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByStreetPostalCode[]
     */
    public $SelectionByPostalAddressStreetPostalCode;
    /**
     * The SelectionByPostalAddressCountryCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByCountryCode[]
     */
    public $SelectionByPostalAddressCountryCode;
    /**
     * The SelectionByPostalAddressRegionCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByRegionCode[]
     */
    public $SelectionByPostalAddressRegionCode;
    /**
     * The SelectionByABCClassificationCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByCustomerABCClassificationCode[]
     */
    public $SelectionByABCClassificationCode;
    /**
     * The SelectionByIndustrialSectorCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByIndustrialSectorCode[]
     */
    public $SelectionByIndustrialSectorCode;
    /**
     * The SelectionByContactPersonInternalID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByInternalID[]
     */
    public $SelectionByContactPersonInternalID;
    /**
     * The SelectionByContactPersonUUID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByUUID[]
     */
    public $SelectionByContactPersonUUID;
    /**
     * The SelectionByContactPersonFamilyName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByBusinessPartnerName[]
     */
    public $SelectionByContactPersonFamilyName;
    /**
     * The SelectionByContactPersonGivenName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByBusinessPartnerAdditionalName[]
     */
    public $SelectionByContactPersonGivenName;
    /**
     * The SelectionByContactPersonSortingFormattedName
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionBySortingFormattedName[]
     */
    public $SelectionByContactPersonSortingFormattedName;
    /**
     * The SelectionByContactPersonWorkplaceEmailURI
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByEmailURI[]
     */
    public $SelectionByContactPersonWorkplaceEmailURI;
    /**
     * The SelectionBySalesArrangementSalesOrganisationID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionBySalesOrganisationID[]
     */
    public $SelectionBySalesArrangementSalesOrganisationID;
    /**
     * The SelectionByCreatedSinceDate
     * Meta information extracted from the WSDL
     * - documentation: Date
     * - base: xsd:date
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $SelectionByCreatedSinceDate;
    /**
     * The SelectionByChangedSinceDate
     * Meta information extracted from the WSDL
     * - documentation: Date
     * - base: xsd:date
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $SelectionByChangedSinceDate;
    /**
     * The SelectionByLifeCycleStatusCode
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByLifeCycleStatusCode[]
     */
    public $SelectionByLifeCycleStatusCode;
    /**
     * The SelectionBySearchText
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $SelectionBySearchText;
    /**
     * The SelectionByCreatedSinceDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $SelectionByCreatedSinceDateTime;
    /**
     * The SelectionByLastChangeSinceDateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $SelectionByLastChangeSinceDateTime;
    /**
     * The SelectionByCreationIdentityID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByIdentityID[]
     */
    public $SelectionByCreationIdentityID;
    /**
     * The SelectionByLastChangeIdentityID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByIdentityID[]
     */
    public $SelectionByLastChangeIdentityID;
    /**
     * The SelectionByGroupwareSubscriptionEmployeeUUID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectionByUUID[]
     */
    public $SelectionByGroupwareSubscriptionEmployeeUUID;
    /**
     * The SelectionByResponsibleEmployeeUUID
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectionByUUID[]
     */
    public $SelectionByResponsibleEmployeeUUID;
    /**
     * The SelectionByCreationDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByCreationDateTime[]
     */
    public $SelectionByCreationDateTime;
    /**
     * The SelectionByLastChangeDateTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerSelectionByChangeDateTime[]
     */
    public $SelectionByLastChangeDateTime;
    /**
     * Constructor method for CustomerSelectionByElements
     * @uses CustomerSelectionByElements::setSelectionByBusinessPartnerRoleCode()
     * @uses CustomerSelectionByElements::setSelectionByInternalID()
     * @uses CustomerSelectionByElements::setSelectionByUUID()
     * @uses CustomerSelectionByElements::setSelectionByCategoryCode()
     * @uses CustomerSelectionByElements::setSelectionByBusinessPartnerName()
     * @uses CustomerSelectionByElements::setSelectionByBusinessPartnerAdditionalName()
     * @uses CustomerSelectionByElements::setSelectionBySortingFormattedName()
     * @uses CustomerSelectionByElements::setSelectionByLegalCompetenceIndicator()
     * @uses CustomerSelectionByElements::setSelectionByAddressDefaultIndicator()
     * @uses CustomerSelectionByElements::setSelectionByPostalAddressCityName()
     * @uses CustomerSelectionByElements::setSelectionByPostalAddressStreetPostalCode()
     * @uses CustomerSelectionByElements::setSelectionByPostalAddressCountryCode()
     * @uses CustomerSelectionByElements::setSelectionByPostalAddressRegionCode()
     * @uses CustomerSelectionByElements::setSelectionByABCClassificationCode()
     * @uses CustomerSelectionByElements::setSelectionByIndustrialSectorCode()
     * @uses CustomerSelectionByElements::setSelectionByContactPersonInternalID()
     * @uses CustomerSelectionByElements::setSelectionByContactPersonUUID()
     * @uses CustomerSelectionByElements::setSelectionByContactPersonFamilyName()
     * @uses CustomerSelectionByElements::setSelectionByContactPersonGivenName()
     * @uses CustomerSelectionByElements::setSelectionByContactPersonSortingFormattedName()
     * @uses CustomerSelectionByElements::setSelectionByContactPersonWorkplaceEmailURI()
     * @uses CustomerSelectionByElements::setSelectionBySalesArrangementSalesOrganisationID()
     * @uses CustomerSelectionByElements::setSelectionByCreatedSinceDate()
     * @uses CustomerSelectionByElements::setSelectionByChangedSinceDate()
     * @uses CustomerSelectionByElements::setSelectionByLifeCycleStatusCode()
     * @uses CustomerSelectionByElements::setSelectionBySearchText()
     * @uses CustomerSelectionByElements::setSelectionByCreatedSinceDateTime()
     * @uses CustomerSelectionByElements::setSelectionByLastChangeSinceDateTime()
     * @uses CustomerSelectionByElements::setSelectionByCreationIdentityID()
     * @uses CustomerSelectionByElements::setSelectionByLastChangeIdentityID()
     * @uses CustomerSelectionByElements::setSelectionByGroupwareSubscriptionEmployeeUUID()
     * @uses CustomerSelectionByElements::setSelectionByResponsibleEmployeeUUID()
     * @uses CustomerSelectionByElements::setSelectionByCreationDateTime()
     * @uses CustomerSelectionByElements::setSelectionByLastChangeDateTime()
     * @param \StructType\CustomerSelectionByRoleCode[] $selectionByBusinessPartnerRoleCode
     * @param \StructType\CustomerSelectionByInternalID[] $selectionByInternalID
     * @param \StructType\CustomerSelectionByUUID[] $selectionByUUID
     * @param \StructType\CustomerSelectionByCategoryCode[] $selectionByCategoryCode
     * @param \StructType\CustomerSelectionByBusinessPartnerName[] $selectionByBusinessPartnerName
     * @param \StructType\CustomerSelectionByBusinessPartnerAdditionalName[] $selectionByBusinessPartnerAdditionalName
     * @param \StructType\CustomerSelectionBySortingFormattedName[] $selectionBySortingFormattedName
     * @param bool $selectionByLegalCompetenceIndicator
     * @param bool $selectionByAddressDefaultIndicator
     * @param \StructType\CustomerSelectionByCityName[] $selectionByPostalAddressCityName
     * @param \StructType\CustomerSelectionByStreetPostalCode[] $selectionByPostalAddressStreetPostalCode
     * @param \StructType\CustomerSelectionByCountryCode[] $selectionByPostalAddressCountryCode
     * @param \StructType\CustomerSelectionByRegionCode[] $selectionByPostalAddressRegionCode
     * @param \StructType\CustomerSelectionByCustomerABCClassificationCode[] $selectionByABCClassificationCode
     * @param \StructType\CustomerSelectionByIndustrialSectorCode[] $selectionByIndustrialSectorCode
     * @param \StructType\CustomerSelectionByInternalID[] $selectionByContactPersonInternalID
     * @param \StructType\CustomerSelectionByUUID[] $selectionByContactPersonUUID
     * @param \StructType\CustomerSelectionByBusinessPartnerName[] $selectionByContactPersonFamilyName
     * @param \StructType\CustomerSelectionByBusinessPartnerAdditionalName[] $selectionByContactPersonGivenName
     * @param \StructType\CustomerSelectionBySortingFormattedName[] $selectionByContactPersonSortingFormattedName
     * @param \StructType\CustomerSelectionByEmailURI[] $selectionByContactPersonWorkplaceEmailURI
     * @param \StructType\CustomerSelectionBySalesOrganisationID[] $selectionBySalesArrangementSalesOrganisationID
     * @param string $selectionByCreatedSinceDate
     * @param string $selectionByChangedSinceDate
     * @param \StructType\CustomerSelectionByLifeCycleStatusCode[] $selectionByLifeCycleStatusCode
     * @param string $selectionBySearchText
     * @param string $selectionByCreatedSinceDateTime
     * @param string $selectionByLastChangeSinceDateTime
     * @param \StructType\CustomerSelectionByIdentityID[] $selectionByCreationIdentityID
     * @param \StructType\CustomerSelectionByIdentityID[] $selectionByLastChangeIdentityID
     * @param \StructType\SelectionByUUID[] $selectionByGroupwareSubscriptionEmployeeUUID
     * @param \StructType\SelectionByUUID[] $selectionByResponsibleEmployeeUUID
     * @param \StructType\CustomerSelectionByCreationDateTime[] $selectionByCreationDateTime
     * @param \StructType\CustomerSelectionByChangeDateTime[] $selectionByLastChangeDateTime
     */
    public function __construct(array $selectionByBusinessPartnerRoleCode = array(), array $selectionByInternalID = array(), array $selectionByUUID = array(), array $selectionByCategoryCode = array(), array $selectionByBusinessPartnerName = array(), array $selectionByBusinessPartnerAdditionalName = array(), array $selectionBySortingFormattedName = array(), $selectionByLegalCompetenceIndicator = null, $selectionByAddressDefaultIndicator = null, array $selectionByPostalAddressCityName = array(), array $selectionByPostalAddressStreetPostalCode = array(), array $selectionByPostalAddressCountryCode = array(), array $selectionByPostalAddressRegionCode = array(), array $selectionByABCClassificationCode = array(), array $selectionByIndustrialSectorCode = array(), array $selectionByContactPersonInternalID = array(), array $selectionByContactPersonUUID = array(), array $selectionByContactPersonFamilyName = array(), array $selectionByContactPersonGivenName = array(), array $selectionByContactPersonSortingFormattedName = array(), array $selectionByContactPersonWorkplaceEmailURI = array(), array $selectionBySalesArrangementSalesOrganisationID = array(), $selectionByCreatedSinceDate = null, $selectionByChangedSinceDate = null, array $selectionByLifeCycleStatusCode = array(), $selectionBySearchText = null, $selectionByCreatedSinceDateTime = null, $selectionByLastChangeSinceDateTime = null, array $selectionByCreationIdentityID = array(), array $selectionByLastChangeIdentityID = array(), array $selectionByGroupwareSubscriptionEmployeeUUID = array(), array $selectionByResponsibleEmployeeUUID = array(), array $selectionByCreationDateTime = array(), array $selectionByLastChangeDateTime = array())
    {
        $this
            ->setSelectionByBusinessPartnerRoleCode($selectionByBusinessPartnerRoleCode)
            ->setSelectionByInternalID($selectionByInternalID)
            ->setSelectionByUUID($selectionByUUID)
            ->setSelectionByCategoryCode($selectionByCategoryCode)
            ->setSelectionByBusinessPartnerName($selectionByBusinessPartnerName)
            ->setSelectionByBusinessPartnerAdditionalName($selectionByBusinessPartnerAdditionalName)
            ->setSelectionBySortingFormattedName($selectionBySortingFormattedName)
            ->setSelectionByLegalCompetenceIndicator($selectionByLegalCompetenceIndicator)
            ->setSelectionByAddressDefaultIndicator($selectionByAddressDefaultIndicator)
            ->setSelectionByPostalAddressCityName($selectionByPostalAddressCityName)
            ->setSelectionByPostalAddressStreetPostalCode($selectionByPostalAddressStreetPostalCode)
            ->setSelectionByPostalAddressCountryCode($selectionByPostalAddressCountryCode)
            ->setSelectionByPostalAddressRegionCode($selectionByPostalAddressRegionCode)
            ->setSelectionByABCClassificationCode($selectionByABCClassificationCode)
            ->setSelectionByIndustrialSectorCode($selectionByIndustrialSectorCode)
            ->setSelectionByContactPersonInternalID($selectionByContactPersonInternalID)
            ->setSelectionByContactPersonUUID($selectionByContactPersonUUID)
            ->setSelectionByContactPersonFamilyName($selectionByContactPersonFamilyName)
            ->setSelectionByContactPersonGivenName($selectionByContactPersonGivenName)
            ->setSelectionByContactPersonSortingFormattedName($selectionByContactPersonSortingFormattedName)
            ->setSelectionByContactPersonWorkplaceEmailURI($selectionByContactPersonWorkplaceEmailURI)
            ->setSelectionBySalesArrangementSalesOrganisationID($selectionBySalesArrangementSalesOrganisationID)
            ->setSelectionByCreatedSinceDate($selectionByCreatedSinceDate)
            ->setSelectionByChangedSinceDate($selectionByChangedSinceDate)
            ->setSelectionByLifeCycleStatusCode($selectionByLifeCycleStatusCode)
            ->setSelectionBySearchText($selectionBySearchText)
            ->setSelectionByCreatedSinceDateTime($selectionByCreatedSinceDateTime)
            ->setSelectionByLastChangeSinceDateTime($selectionByLastChangeSinceDateTime)
            ->setSelectionByCreationIdentityID($selectionByCreationIdentityID)
            ->setSelectionByLastChangeIdentityID($selectionByLastChangeIdentityID)
            ->setSelectionByGroupwareSubscriptionEmployeeUUID($selectionByGroupwareSubscriptionEmployeeUUID)
            ->setSelectionByResponsibleEmployeeUUID($selectionByResponsibleEmployeeUUID)
            ->setSelectionByCreationDateTime($selectionByCreationDateTime)
            ->setSelectionByLastChangeDateTime($selectionByLastChangeDateTime);
    }
    /**
     * Get SelectionByBusinessPartnerRoleCode value
     * @return \StructType\CustomerSelectionByRoleCode[]|null
     */
    public function getSelectionByBusinessPartnerRoleCode()
    {
        return $this->SelectionByBusinessPartnerRoleCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByBusinessPartnerRoleCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByBusinessPartnerRoleCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByBusinessPartnerRoleCodeForArrayConstraintsFromSetSelectionByBusinessPartnerRoleCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByBusinessPartnerRoleCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByBusinessPartnerRoleCodeItem instanceof \StructType\CustomerSelectionByRoleCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByBusinessPartnerRoleCodeItem) ? get_class($customerSelectionByElementsSelectionByBusinessPartnerRoleCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByBusinessPartnerRoleCodeItem), var_export($customerSelectionByElementsSelectionByBusinessPartnerRoleCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByBusinessPartnerRoleCode property can only contain items of type \StructType\CustomerSelectionByRoleCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByBusinessPartnerRoleCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByRoleCode[] $selectionByBusinessPartnerRoleCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByBusinessPartnerRoleCode(array $selectionByBusinessPartnerRoleCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByBusinessPartnerRoleCodeArrayErrorMessage = self::validateSelectionByBusinessPartnerRoleCodeForArrayConstraintsFromSetSelectionByBusinessPartnerRoleCode($selectionByBusinessPartnerRoleCode))) {
            throw new \InvalidArgumentException($selectionByBusinessPartnerRoleCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByBusinessPartnerRoleCode = $selectionByBusinessPartnerRoleCode;
        return $this;
    }
    /**
     * Add item to SelectionByBusinessPartnerRoleCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByRoleCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByBusinessPartnerRoleCode(\StructType\CustomerSelectionByRoleCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByRoleCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByBusinessPartnerRoleCode property can only contain items of type \StructType\CustomerSelectionByRoleCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByBusinessPartnerRoleCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByInternalID value
     * @return \StructType\CustomerSelectionByInternalID[]|null
     */
    public function getSelectionByInternalID()
    {
        return $this->SelectionByInternalID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByInternalID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByInternalID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByInternalIDForArrayConstraintsFromSetSelectionByInternalID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByInternalIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByInternalIDItem instanceof \StructType\CustomerSelectionByInternalID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByInternalIDItem) ? get_class($customerSelectionByElementsSelectionByInternalIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByInternalIDItem), var_export($customerSelectionByElementsSelectionByInternalIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByInternalID property can only contain items of type \StructType\CustomerSelectionByInternalID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByInternalID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByInternalID[] $selectionByInternalID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByInternalID(array $selectionByInternalID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByInternalIDArrayErrorMessage = self::validateSelectionByInternalIDForArrayConstraintsFromSetSelectionByInternalID($selectionByInternalID))) {
            throw new \InvalidArgumentException($selectionByInternalIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByInternalID = $selectionByInternalID;
        return $this;
    }
    /**
     * Add item to SelectionByInternalID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByInternalID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByInternalID(\StructType\CustomerSelectionByInternalID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByInternalID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByInternalID property can only contain items of type \StructType\CustomerSelectionByInternalID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByInternalID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByUUID value
     * @return \StructType\CustomerSelectionByUUID[]|null
     */
    public function getSelectionByUUID()
    {
        return $this->SelectionByUUID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByUUID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByUUID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByUUIDForArrayConstraintsFromSetSelectionByUUID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByUUIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByUUIDItem instanceof \StructType\CustomerSelectionByUUID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByUUIDItem) ? get_class($customerSelectionByElementsSelectionByUUIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByUUIDItem), var_export($customerSelectionByElementsSelectionByUUIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByUUID property can only contain items of type \StructType\CustomerSelectionByUUID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByUUID[] $selectionByUUID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByUUID(array $selectionByUUID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByUUIDArrayErrorMessage = self::validateSelectionByUUIDForArrayConstraintsFromSetSelectionByUUID($selectionByUUID))) {
            throw new \InvalidArgumentException($selectionByUUIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByUUID = $selectionByUUID;
        return $this;
    }
    /**
     * Add item to SelectionByUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByUUID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByUUID(\StructType\CustomerSelectionByUUID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByUUID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByUUID property can only contain items of type \StructType\CustomerSelectionByUUID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByUUID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByCategoryCode value
     * @return \StructType\CustomerSelectionByCategoryCode[]|null
     */
    public function getSelectionByCategoryCode()
    {
        return $this->SelectionByCategoryCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByCategoryCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByCategoryCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByCategoryCodeForArrayConstraintsFromSetSelectionByCategoryCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByCategoryCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByCategoryCodeItem instanceof \StructType\CustomerSelectionByCategoryCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByCategoryCodeItem) ? get_class($customerSelectionByElementsSelectionByCategoryCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByCategoryCodeItem), var_export($customerSelectionByElementsSelectionByCategoryCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByCategoryCode property can only contain items of type \StructType\CustomerSelectionByCategoryCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByCategoryCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCategoryCode[] $selectionByCategoryCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByCategoryCode(array $selectionByCategoryCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByCategoryCodeArrayErrorMessage = self::validateSelectionByCategoryCodeForArrayConstraintsFromSetSelectionByCategoryCode($selectionByCategoryCode))) {
            throw new \InvalidArgumentException($selectionByCategoryCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByCategoryCode = $selectionByCategoryCode;
        return $this;
    }
    /**
     * Add item to SelectionByCategoryCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCategoryCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByCategoryCode(\StructType\CustomerSelectionByCategoryCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByCategoryCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByCategoryCode property can only contain items of type \StructType\CustomerSelectionByCategoryCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByCategoryCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByBusinessPartnerName value
     * @return \StructType\CustomerSelectionByBusinessPartnerName[]|null
     */
    public function getSelectionByBusinessPartnerName()
    {
        return $this->SelectionByBusinessPartnerName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByBusinessPartnerName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByBusinessPartnerName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByBusinessPartnerNameForArrayConstraintsFromSetSelectionByBusinessPartnerName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByBusinessPartnerNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByBusinessPartnerNameItem instanceof \StructType\CustomerSelectionByBusinessPartnerName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByBusinessPartnerNameItem) ? get_class($customerSelectionByElementsSelectionByBusinessPartnerNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByBusinessPartnerNameItem), var_export($customerSelectionByElementsSelectionByBusinessPartnerNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByBusinessPartnerName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByBusinessPartnerName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerName[] $selectionByBusinessPartnerName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByBusinessPartnerName(array $selectionByBusinessPartnerName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByBusinessPartnerNameArrayErrorMessage = self::validateSelectionByBusinessPartnerNameForArrayConstraintsFromSetSelectionByBusinessPartnerName($selectionByBusinessPartnerName))) {
            throw new \InvalidArgumentException($selectionByBusinessPartnerNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionByBusinessPartnerName = $selectionByBusinessPartnerName;
        return $this;
    }
    /**
     * Add item to SelectionByBusinessPartnerName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByBusinessPartnerName(\StructType\CustomerSelectionByBusinessPartnerName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByBusinessPartnerName) {
            throw new \InvalidArgumentException(sprintf('The SelectionByBusinessPartnerName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByBusinessPartnerName[] = $item;
        return $this;
    }
    /**
     * Get SelectionByBusinessPartnerAdditionalName value
     * @return \StructType\CustomerSelectionByBusinessPartnerAdditionalName[]|null
     */
    public function getSelectionByBusinessPartnerAdditionalName()
    {
        return $this->SelectionByBusinessPartnerAdditionalName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByBusinessPartnerAdditionalName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByBusinessPartnerAdditionalName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByBusinessPartnerAdditionalNameForArrayConstraintsFromSetSelectionByBusinessPartnerAdditionalName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByBusinessPartnerAdditionalNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByBusinessPartnerAdditionalNameItem instanceof \StructType\CustomerSelectionByBusinessPartnerAdditionalName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByBusinessPartnerAdditionalNameItem) ? get_class($customerSelectionByElementsSelectionByBusinessPartnerAdditionalNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByBusinessPartnerAdditionalNameItem), var_export($customerSelectionByElementsSelectionByBusinessPartnerAdditionalNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByBusinessPartnerAdditionalName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerAdditionalName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByBusinessPartnerAdditionalName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerAdditionalName[] $selectionByBusinessPartnerAdditionalName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByBusinessPartnerAdditionalName(array $selectionByBusinessPartnerAdditionalName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByBusinessPartnerAdditionalNameArrayErrorMessage = self::validateSelectionByBusinessPartnerAdditionalNameForArrayConstraintsFromSetSelectionByBusinessPartnerAdditionalName($selectionByBusinessPartnerAdditionalName))) {
            throw new \InvalidArgumentException($selectionByBusinessPartnerAdditionalNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionByBusinessPartnerAdditionalName = $selectionByBusinessPartnerAdditionalName;
        return $this;
    }
    /**
     * Add item to SelectionByBusinessPartnerAdditionalName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerAdditionalName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByBusinessPartnerAdditionalName(\StructType\CustomerSelectionByBusinessPartnerAdditionalName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByBusinessPartnerAdditionalName) {
            throw new \InvalidArgumentException(sprintf('The SelectionByBusinessPartnerAdditionalName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerAdditionalName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByBusinessPartnerAdditionalName[] = $item;
        return $this;
    }
    /**
     * Get SelectionBySortingFormattedName value
     * @return \StructType\CustomerSelectionBySortingFormattedName[]|null
     */
    public function getSelectionBySortingFormattedName()
    {
        return $this->SelectionBySortingFormattedName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionBySortingFormattedName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionBySortingFormattedName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionBySortingFormattedNameForArrayConstraintsFromSetSelectionBySortingFormattedName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionBySortingFormattedNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionBySortingFormattedNameItem instanceof \StructType\CustomerSelectionBySortingFormattedName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionBySortingFormattedNameItem) ? get_class($customerSelectionByElementsSelectionBySortingFormattedNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionBySortingFormattedNameItem), var_export($customerSelectionByElementsSelectionBySortingFormattedNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionBySortingFormattedName property can only contain items of type \StructType\CustomerSelectionBySortingFormattedName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionBySortingFormattedName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionBySortingFormattedName[] $selectionBySortingFormattedName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionBySortingFormattedName(array $selectionBySortingFormattedName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionBySortingFormattedNameArrayErrorMessage = self::validateSelectionBySortingFormattedNameForArrayConstraintsFromSetSelectionBySortingFormattedName($selectionBySortingFormattedName))) {
            throw new \InvalidArgumentException($selectionBySortingFormattedNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionBySortingFormattedName = $selectionBySortingFormattedName;
        return $this;
    }
    /**
     * Add item to SelectionBySortingFormattedName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionBySortingFormattedName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionBySortingFormattedName(\StructType\CustomerSelectionBySortingFormattedName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionBySortingFormattedName) {
            throw new \InvalidArgumentException(sprintf('The SelectionBySortingFormattedName property can only contain items of type \StructType\CustomerSelectionBySortingFormattedName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionBySortingFormattedName[] = $item;
        return $this;
    }
    /**
     * Get SelectionByLegalCompetenceIndicator value
     * @return bool|null
     */
    public function getSelectionByLegalCompetenceIndicator()
    {
        return $this->SelectionByLegalCompetenceIndicator;
    }
    /**
     * Set SelectionByLegalCompetenceIndicator value
     * @param bool $selectionByLegalCompetenceIndicator
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByLegalCompetenceIndicator($selectionByLegalCompetenceIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($selectionByLegalCompetenceIndicator) && !is_bool($selectionByLegalCompetenceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selectionByLegalCompetenceIndicator, true), gettype($selectionByLegalCompetenceIndicator)), __LINE__);
        }
        $this->SelectionByLegalCompetenceIndicator = $selectionByLegalCompetenceIndicator;
        return $this;
    }
    /**
     * Get SelectionByAddressDefaultIndicator value
     * @return bool|null
     */
    public function getSelectionByAddressDefaultIndicator()
    {
        return $this->SelectionByAddressDefaultIndicator;
    }
    /**
     * Set SelectionByAddressDefaultIndicator value
     * @param bool $selectionByAddressDefaultIndicator
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByAddressDefaultIndicator($selectionByAddressDefaultIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($selectionByAddressDefaultIndicator) && !is_bool($selectionByAddressDefaultIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($selectionByAddressDefaultIndicator, true), gettype($selectionByAddressDefaultIndicator)), __LINE__);
        }
        $this->SelectionByAddressDefaultIndicator = $selectionByAddressDefaultIndicator;
        return $this;
    }
    /**
     * Get SelectionByPostalAddressCityName value
     * @return \StructType\CustomerSelectionByCityName[]|null
     */
    public function getSelectionByPostalAddressCityName()
    {
        return $this->SelectionByPostalAddressCityName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByPostalAddressCityName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByPostalAddressCityName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByPostalAddressCityNameForArrayConstraintsFromSetSelectionByPostalAddressCityName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByPostalAddressCityNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByPostalAddressCityNameItem instanceof \StructType\CustomerSelectionByCityName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByPostalAddressCityNameItem) ? get_class($customerSelectionByElementsSelectionByPostalAddressCityNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByPostalAddressCityNameItem), var_export($customerSelectionByElementsSelectionByPostalAddressCityNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByPostalAddressCityName property can only contain items of type \StructType\CustomerSelectionByCityName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByPostalAddressCityName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCityName[] $selectionByPostalAddressCityName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByPostalAddressCityName(array $selectionByPostalAddressCityName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByPostalAddressCityNameArrayErrorMessage = self::validateSelectionByPostalAddressCityNameForArrayConstraintsFromSetSelectionByPostalAddressCityName($selectionByPostalAddressCityName))) {
            throw new \InvalidArgumentException($selectionByPostalAddressCityNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionByPostalAddressCityName = $selectionByPostalAddressCityName;
        return $this;
    }
    /**
     * Add item to SelectionByPostalAddressCityName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCityName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByPostalAddressCityName(\StructType\CustomerSelectionByCityName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByCityName) {
            throw new \InvalidArgumentException(sprintf('The SelectionByPostalAddressCityName property can only contain items of type \StructType\CustomerSelectionByCityName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByPostalAddressCityName[] = $item;
        return $this;
    }
    /**
     * Get SelectionByPostalAddressStreetPostalCode value
     * @return \StructType\CustomerSelectionByStreetPostalCode[]|null
     */
    public function getSelectionByPostalAddressStreetPostalCode()
    {
        return $this->SelectionByPostalAddressStreetPostalCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByPostalAddressStreetPostalCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByPostalAddressStreetPostalCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByPostalAddressStreetPostalCodeForArrayConstraintsFromSetSelectionByPostalAddressStreetPostalCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByPostalAddressStreetPostalCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByPostalAddressStreetPostalCodeItem instanceof \StructType\CustomerSelectionByStreetPostalCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByPostalAddressStreetPostalCodeItem) ? get_class($customerSelectionByElementsSelectionByPostalAddressStreetPostalCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByPostalAddressStreetPostalCodeItem), var_export($customerSelectionByElementsSelectionByPostalAddressStreetPostalCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByPostalAddressStreetPostalCode property can only contain items of type \StructType\CustomerSelectionByStreetPostalCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByPostalAddressStreetPostalCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByStreetPostalCode[] $selectionByPostalAddressStreetPostalCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByPostalAddressStreetPostalCode(array $selectionByPostalAddressStreetPostalCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByPostalAddressStreetPostalCodeArrayErrorMessage = self::validateSelectionByPostalAddressStreetPostalCodeForArrayConstraintsFromSetSelectionByPostalAddressStreetPostalCode($selectionByPostalAddressStreetPostalCode))) {
            throw new \InvalidArgumentException($selectionByPostalAddressStreetPostalCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByPostalAddressStreetPostalCode = $selectionByPostalAddressStreetPostalCode;
        return $this;
    }
    /**
     * Add item to SelectionByPostalAddressStreetPostalCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByStreetPostalCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByPostalAddressStreetPostalCode(\StructType\CustomerSelectionByStreetPostalCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByStreetPostalCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByPostalAddressStreetPostalCode property can only contain items of type \StructType\CustomerSelectionByStreetPostalCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByPostalAddressStreetPostalCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByPostalAddressCountryCode value
     * @return \StructType\CustomerSelectionByCountryCode[]|null
     */
    public function getSelectionByPostalAddressCountryCode()
    {
        return $this->SelectionByPostalAddressCountryCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByPostalAddressCountryCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByPostalAddressCountryCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByPostalAddressCountryCodeForArrayConstraintsFromSetSelectionByPostalAddressCountryCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByPostalAddressCountryCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByPostalAddressCountryCodeItem instanceof \StructType\CustomerSelectionByCountryCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByPostalAddressCountryCodeItem) ? get_class($customerSelectionByElementsSelectionByPostalAddressCountryCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByPostalAddressCountryCodeItem), var_export($customerSelectionByElementsSelectionByPostalAddressCountryCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByPostalAddressCountryCode property can only contain items of type \StructType\CustomerSelectionByCountryCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByPostalAddressCountryCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCountryCode[] $selectionByPostalAddressCountryCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByPostalAddressCountryCode(array $selectionByPostalAddressCountryCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByPostalAddressCountryCodeArrayErrorMessage = self::validateSelectionByPostalAddressCountryCodeForArrayConstraintsFromSetSelectionByPostalAddressCountryCode($selectionByPostalAddressCountryCode))) {
            throw new \InvalidArgumentException($selectionByPostalAddressCountryCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByPostalAddressCountryCode = $selectionByPostalAddressCountryCode;
        return $this;
    }
    /**
     * Add item to SelectionByPostalAddressCountryCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCountryCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByPostalAddressCountryCode(\StructType\CustomerSelectionByCountryCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByCountryCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByPostalAddressCountryCode property can only contain items of type \StructType\CustomerSelectionByCountryCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByPostalAddressCountryCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByPostalAddressRegionCode value
     * @return \StructType\CustomerSelectionByRegionCode[]|null
     */
    public function getSelectionByPostalAddressRegionCode()
    {
        return $this->SelectionByPostalAddressRegionCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByPostalAddressRegionCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByPostalAddressRegionCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByPostalAddressRegionCodeForArrayConstraintsFromSetSelectionByPostalAddressRegionCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByPostalAddressRegionCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByPostalAddressRegionCodeItem instanceof \StructType\CustomerSelectionByRegionCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByPostalAddressRegionCodeItem) ? get_class($customerSelectionByElementsSelectionByPostalAddressRegionCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByPostalAddressRegionCodeItem), var_export($customerSelectionByElementsSelectionByPostalAddressRegionCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByPostalAddressRegionCode property can only contain items of type \StructType\CustomerSelectionByRegionCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByPostalAddressRegionCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByRegionCode[] $selectionByPostalAddressRegionCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByPostalAddressRegionCode(array $selectionByPostalAddressRegionCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByPostalAddressRegionCodeArrayErrorMessage = self::validateSelectionByPostalAddressRegionCodeForArrayConstraintsFromSetSelectionByPostalAddressRegionCode($selectionByPostalAddressRegionCode))) {
            throw new \InvalidArgumentException($selectionByPostalAddressRegionCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByPostalAddressRegionCode = $selectionByPostalAddressRegionCode;
        return $this;
    }
    /**
     * Add item to SelectionByPostalAddressRegionCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByRegionCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByPostalAddressRegionCode(\StructType\CustomerSelectionByRegionCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByRegionCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByPostalAddressRegionCode property can only contain items of type \StructType\CustomerSelectionByRegionCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByPostalAddressRegionCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByABCClassificationCode value
     * @return \StructType\CustomerSelectionByCustomerABCClassificationCode[]|null
     */
    public function getSelectionByABCClassificationCode()
    {
        return $this->SelectionByABCClassificationCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByABCClassificationCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByABCClassificationCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByABCClassificationCodeForArrayConstraintsFromSetSelectionByABCClassificationCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByABCClassificationCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByABCClassificationCodeItem instanceof \StructType\CustomerSelectionByCustomerABCClassificationCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByABCClassificationCodeItem) ? get_class($customerSelectionByElementsSelectionByABCClassificationCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByABCClassificationCodeItem), var_export($customerSelectionByElementsSelectionByABCClassificationCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByABCClassificationCode property can only contain items of type \StructType\CustomerSelectionByCustomerABCClassificationCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByABCClassificationCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCustomerABCClassificationCode[] $selectionByABCClassificationCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByABCClassificationCode(array $selectionByABCClassificationCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByABCClassificationCodeArrayErrorMessage = self::validateSelectionByABCClassificationCodeForArrayConstraintsFromSetSelectionByABCClassificationCode($selectionByABCClassificationCode))) {
            throw new \InvalidArgumentException($selectionByABCClassificationCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByABCClassificationCode = $selectionByABCClassificationCode;
        return $this;
    }
    /**
     * Add item to SelectionByABCClassificationCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCustomerABCClassificationCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByABCClassificationCode(\StructType\CustomerSelectionByCustomerABCClassificationCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByCustomerABCClassificationCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByABCClassificationCode property can only contain items of type \StructType\CustomerSelectionByCustomerABCClassificationCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByABCClassificationCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByIndustrialSectorCode value
     * @return \StructType\CustomerSelectionByIndustrialSectorCode[]|null
     */
    public function getSelectionByIndustrialSectorCode()
    {
        return $this->SelectionByIndustrialSectorCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByIndustrialSectorCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByIndustrialSectorCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByIndustrialSectorCodeForArrayConstraintsFromSetSelectionByIndustrialSectorCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByIndustrialSectorCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByIndustrialSectorCodeItem instanceof \StructType\CustomerSelectionByIndustrialSectorCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByIndustrialSectorCodeItem) ? get_class($customerSelectionByElementsSelectionByIndustrialSectorCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByIndustrialSectorCodeItem), var_export($customerSelectionByElementsSelectionByIndustrialSectorCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByIndustrialSectorCode property can only contain items of type \StructType\CustomerSelectionByIndustrialSectorCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByIndustrialSectorCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByIndustrialSectorCode[] $selectionByIndustrialSectorCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByIndustrialSectorCode(array $selectionByIndustrialSectorCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByIndustrialSectorCodeArrayErrorMessage = self::validateSelectionByIndustrialSectorCodeForArrayConstraintsFromSetSelectionByIndustrialSectorCode($selectionByIndustrialSectorCode))) {
            throw new \InvalidArgumentException($selectionByIndustrialSectorCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByIndustrialSectorCode = $selectionByIndustrialSectorCode;
        return $this;
    }
    /**
     * Add item to SelectionByIndustrialSectorCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByIndustrialSectorCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByIndustrialSectorCode(\StructType\CustomerSelectionByIndustrialSectorCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByIndustrialSectorCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByIndustrialSectorCode property can only contain items of type \StructType\CustomerSelectionByIndustrialSectorCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByIndustrialSectorCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionByContactPersonInternalID value
     * @return \StructType\CustomerSelectionByInternalID[]|null
     */
    public function getSelectionByContactPersonInternalID()
    {
        return $this->SelectionByContactPersonInternalID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByContactPersonInternalID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByContactPersonInternalID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByContactPersonInternalIDForArrayConstraintsFromSetSelectionByContactPersonInternalID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByContactPersonInternalIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByContactPersonInternalIDItem instanceof \StructType\CustomerSelectionByInternalID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByContactPersonInternalIDItem) ? get_class($customerSelectionByElementsSelectionByContactPersonInternalIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByContactPersonInternalIDItem), var_export($customerSelectionByElementsSelectionByContactPersonInternalIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByContactPersonInternalID property can only contain items of type \StructType\CustomerSelectionByInternalID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByContactPersonInternalID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByInternalID[] $selectionByContactPersonInternalID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByContactPersonInternalID(array $selectionByContactPersonInternalID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByContactPersonInternalIDArrayErrorMessage = self::validateSelectionByContactPersonInternalIDForArrayConstraintsFromSetSelectionByContactPersonInternalID($selectionByContactPersonInternalID))) {
            throw new \InvalidArgumentException($selectionByContactPersonInternalIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByContactPersonInternalID = $selectionByContactPersonInternalID;
        return $this;
    }
    /**
     * Add item to SelectionByContactPersonInternalID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByInternalID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByContactPersonInternalID(\StructType\CustomerSelectionByInternalID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByInternalID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByContactPersonInternalID property can only contain items of type \StructType\CustomerSelectionByInternalID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByContactPersonInternalID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByContactPersonUUID value
     * @return \StructType\CustomerSelectionByUUID[]|null
     */
    public function getSelectionByContactPersonUUID()
    {
        return $this->SelectionByContactPersonUUID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByContactPersonUUID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByContactPersonUUID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByContactPersonUUIDForArrayConstraintsFromSetSelectionByContactPersonUUID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByContactPersonUUIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByContactPersonUUIDItem instanceof \StructType\CustomerSelectionByUUID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByContactPersonUUIDItem) ? get_class($customerSelectionByElementsSelectionByContactPersonUUIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByContactPersonUUIDItem), var_export($customerSelectionByElementsSelectionByContactPersonUUIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByContactPersonUUID property can only contain items of type \StructType\CustomerSelectionByUUID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByContactPersonUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByUUID[] $selectionByContactPersonUUID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByContactPersonUUID(array $selectionByContactPersonUUID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByContactPersonUUIDArrayErrorMessage = self::validateSelectionByContactPersonUUIDForArrayConstraintsFromSetSelectionByContactPersonUUID($selectionByContactPersonUUID))) {
            throw new \InvalidArgumentException($selectionByContactPersonUUIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByContactPersonUUID = $selectionByContactPersonUUID;
        return $this;
    }
    /**
     * Add item to SelectionByContactPersonUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByUUID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByContactPersonUUID(\StructType\CustomerSelectionByUUID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByUUID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByContactPersonUUID property can only contain items of type \StructType\CustomerSelectionByUUID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByContactPersonUUID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByContactPersonFamilyName value
     * @return \StructType\CustomerSelectionByBusinessPartnerName[]|null
     */
    public function getSelectionByContactPersonFamilyName()
    {
        return $this->SelectionByContactPersonFamilyName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByContactPersonFamilyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByContactPersonFamilyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByContactPersonFamilyNameForArrayConstraintsFromSetSelectionByContactPersonFamilyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByContactPersonFamilyNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByContactPersonFamilyNameItem instanceof \StructType\CustomerSelectionByBusinessPartnerName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByContactPersonFamilyNameItem) ? get_class($customerSelectionByElementsSelectionByContactPersonFamilyNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByContactPersonFamilyNameItem), var_export($customerSelectionByElementsSelectionByContactPersonFamilyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByContactPersonFamilyName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByContactPersonFamilyName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerName[] $selectionByContactPersonFamilyName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByContactPersonFamilyName(array $selectionByContactPersonFamilyName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByContactPersonFamilyNameArrayErrorMessage = self::validateSelectionByContactPersonFamilyNameForArrayConstraintsFromSetSelectionByContactPersonFamilyName($selectionByContactPersonFamilyName))) {
            throw new \InvalidArgumentException($selectionByContactPersonFamilyNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionByContactPersonFamilyName = $selectionByContactPersonFamilyName;
        return $this;
    }
    /**
     * Add item to SelectionByContactPersonFamilyName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByContactPersonFamilyName(\StructType\CustomerSelectionByBusinessPartnerName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByBusinessPartnerName) {
            throw new \InvalidArgumentException(sprintf('The SelectionByContactPersonFamilyName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByContactPersonFamilyName[] = $item;
        return $this;
    }
    /**
     * Get SelectionByContactPersonGivenName value
     * @return \StructType\CustomerSelectionByBusinessPartnerAdditionalName[]|null
     */
    public function getSelectionByContactPersonGivenName()
    {
        return $this->SelectionByContactPersonGivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByContactPersonGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByContactPersonGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByContactPersonGivenNameForArrayConstraintsFromSetSelectionByContactPersonGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByContactPersonGivenNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByContactPersonGivenNameItem instanceof \StructType\CustomerSelectionByBusinessPartnerAdditionalName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByContactPersonGivenNameItem) ? get_class($customerSelectionByElementsSelectionByContactPersonGivenNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByContactPersonGivenNameItem), var_export($customerSelectionByElementsSelectionByContactPersonGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByContactPersonGivenName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerAdditionalName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByContactPersonGivenName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerAdditionalName[] $selectionByContactPersonGivenName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByContactPersonGivenName(array $selectionByContactPersonGivenName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByContactPersonGivenNameArrayErrorMessage = self::validateSelectionByContactPersonGivenNameForArrayConstraintsFromSetSelectionByContactPersonGivenName($selectionByContactPersonGivenName))) {
            throw new \InvalidArgumentException($selectionByContactPersonGivenNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionByContactPersonGivenName = $selectionByContactPersonGivenName;
        return $this;
    }
    /**
     * Add item to SelectionByContactPersonGivenName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByBusinessPartnerAdditionalName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByContactPersonGivenName(\StructType\CustomerSelectionByBusinessPartnerAdditionalName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByBusinessPartnerAdditionalName) {
            throw new \InvalidArgumentException(sprintf('The SelectionByContactPersonGivenName property can only contain items of type \StructType\CustomerSelectionByBusinessPartnerAdditionalName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByContactPersonGivenName[] = $item;
        return $this;
    }
    /**
     * Get SelectionByContactPersonSortingFormattedName value
     * @return \StructType\CustomerSelectionBySortingFormattedName[]|null
     */
    public function getSelectionByContactPersonSortingFormattedName()
    {
        return $this->SelectionByContactPersonSortingFormattedName;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByContactPersonSortingFormattedName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByContactPersonSortingFormattedName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByContactPersonSortingFormattedNameForArrayConstraintsFromSetSelectionByContactPersonSortingFormattedName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByContactPersonSortingFormattedNameItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByContactPersonSortingFormattedNameItem instanceof \StructType\CustomerSelectionBySortingFormattedName) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByContactPersonSortingFormattedNameItem) ? get_class($customerSelectionByElementsSelectionByContactPersonSortingFormattedNameItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByContactPersonSortingFormattedNameItem), var_export($customerSelectionByElementsSelectionByContactPersonSortingFormattedNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByContactPersonSortingFormattedName property can only contain items of type \StructType\CustomerSelectionBySortingFormattedName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByContactPersonSortingFormattedName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionBySortingFormattedName[] $selectionByContactPersonSortingFormattedName
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByContactPersonSortingFormattedName(array $selectionByContactPersonSortingFormattedName = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByContactPersonSortingFormattedNameArrayErrorMessage = self::validateSelectionByContactPersonSortingFormattedNameForArrayConstraintsFromSetSelectionByContactPersonSortingFormattedName($selectionByContactPersonSortingFormattedName))) {
            throw new \InvalidArgumentException($selectionByContactPersonSortingFormattedNameArrayErrorMessage, __LINE__);
        }
        $this->SelectionByContactPersonSortingFormattedName = $selectionByContactPersonSortingFormattedName;
        return $this;
    }
    /**
     * Add item to SelectionByContactPersonSortingFormattedName value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionBySortingFormattedName $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByContactPersonSortingFormattedName(\StructType\CustomerSelectionBySortingFormattedName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionBySortingFormattedName) {
            throw new \InvalidArgumentException(sprintf('The SelectionByContactPersonSortingFormattedName property can only contain items of type \StructType\CustomerSelectionBySortingFormattedName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByContactPersonSortingFormattedName[] = $item;
        return $this;
    }
    /**
     * Get SelectionByContactPersonWorkplaceEmailURI value
     * @return \StructType\CustomerSelectionByEmailURI[]|null
     */
    public function getSelectionByContactPersonWorkplaceEmailURI()
    {
        return $this->SelectionByContactPersonWorkplaceEmailURI;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByContactPersonWorkplaceEmailURI method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByContactPersonWorkplaceEmailURI method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByContactPersonWorkplaceEmailURIForArrayConstraintsFromSetSelectionByContactPersonWorkplaceEmailURI(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByContactPersonWorkplaceEmailURIItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByContactPersonWorkplaceEmailURIItem instanceof \StructType\CustomerSelectionByEmailURI) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByContactPersonWorkplaceEmailURIItem) ? get_class($customerSelectionByElementsSelectionByContactPersonWorkplaceEmailURIItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByContactPersonWorkplaceEmailURIItem), var_export($customerSelectionByElementsSelectionByContactPersonWorkplaceEmailURIItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByContactPersonWorkplaceEmailURI property can only contain items of type \StructType\CustomerSelectionByEmailURI, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByContactPersonWorkplaceEmailURI value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByEmailURI[] $selectionByContactPersonWorkplaceEmailURI
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByContactPersonWorkplaceEmailURI(array $selectionByContactPersonWorkplaceEmailURI = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByContactPersonWorkplaceEmailURIArrayErrorMessage = self::validateSelectionByContactPersonWorkplaceEmailURIForArrayConstraintsFromSetSelectionByContactPersonWorkplaceEmailURI($selectionByContactPersonWorkplaceEmailURI))) {
            throw new \InvalidArgumentException($selectionByContactPersonWorkplaceEmailURIArrayErrorMessage, __LINE__);
        }
        $this->SelectionByContactPersonWorkplaceEmailURI = $selectionByContactPersonWorkplaceEmailURI;
        return $this;
    }
    /**
     * Add item to SelectionByContactPersonWorkplaceEmailURI value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByEmailURI $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByContactPersonWorkplaceEmailURI(\StructType\CustomerSelectionByEmailURI $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByEmailURI) {
            throw new \InvalidArgumentException(sprintf('The SelectionByContactPersonWorkplaceEmailURI property can only contain items of type \StructType\CustomerSelectionByEmailURI, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByContactPersonWorkplaceEmailURI[] = $item;
        return $this;
    }
    /**
     * Get SelectionBySalesArrangementSalesOrganisationID value
     * @return \StructType\CustomerSelectionBySalesOrganisationID[]|null
     */
    public function getSelectionBySalesArrangementSalesOrganisationID()
    {
        return $this->SelectionBySalesArrangementSalesOrganisationID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionBySalesArrangementSalesOrganisationID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionBySalesArrangementSalesOrganisationID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionBySalesArrangementSalesOrganisationIDForArrayConstraintsFromSetSelectionBySalesArrangementSalesOrganisationID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionBySalesArrangementSalesOrganisationIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionBySalesArrangementSalesOrganisationIDItem instanceof \StructType\CustomerSelectionBySalesOrganisationID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionBySalesArrangementSalesOrganisationIDItem) ? get_class($customerSelectionByElementsSelectionBySalesArrangementSalesOrganisationIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionBySalesArrangementSalesOrganisationIDItem), var_export($customerSelectionByElementsSelectionBySalesArrangementSalesOrganisationIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionBySalesArrangementSalesOrganisationID property can only contain items of type \StructType\CustomerSelectionBySalesOrganisationID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionBySalesArrangementSalesOrganisationID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionBySalesOrganisationID[] $selectionBySalesArrangementSalesOrganisationID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionBySalesArrangementSalesOrganisationID(array $selectionBySalesArrangementSalesOrganisationID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionBySalesArrangementSalesOrganisationIDArrayErrorMessage = self::validateSelectionBySalesArrangementSalesOrganisationIDForArrayConstraintsFromSetSelectionBySalesArrangementSalesOrganisationID($selectionBySalesArrangementSalesOrganisationID))) {
            throw new \InvalidArgumentException($selectionBySalesArrangementSalesOrganisationIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionBySalesArrangementSalesOrganisationID = $selectionBySalesArrangementSalesOrganisationID;
        return $this;
    }
    /**
     * Add item to SelectionBySalesArrangementSalesOrganisationID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionBySalesOrganisationID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionBySalesArrangementSalesOrganisationID(\StructType\CustomerSelectionBySalesOrganisationID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionBySalesOrganisationID) {
            throw new \InvalidArgumentException(sprintf('The SelectionBySalesArrangementSalesOrganisationID property can only contain items of type \StructType\CustomerSelectionBySalesOrganisationID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionBySalesArrangementSalesOrganisationID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByCreatedSinceDate value
     * @return string|null
     */
    public function getSelectionByCreatedSinceDate()
    {
        return $this->SelectionByCreatedSinceDate;
    }
    /**
     * Set SelectionByCreatedSinceDate value
     * @param string $selectionByCreatedSinceDate
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByCreatedSinceDate($selectionByCreatedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($selectionByCreatedSinceDate) && !is_string($selectionByCreatedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionByCreatedSinceDate, true), gettype($selectionByCreatedSinceDate)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($selectionByCreatedSinceDate) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $selectionByCreatedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($selectionByCreatedSinceDate, true)), __LINE__);
        }
        $this->SelectionByCreatedSinceDate = $selectionByCreatedSinceDate;
        return $this;
    }
    /**
     * Get SelectionByChangedSinceDate value
     * @return string|null
     */
    public function getSelectionByChangedSinceDate()
    {
        return $this->SelectionByChangedSinceDate;
    }
    /**
     * Set SelectionByChangedSinceDate value
     * @param string $selectionByChangedSinceDate
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByChangedSinceDate($selectionByChangedSinceDate = null)
    {
        // validation for constraint: string
        if (!is_null($selectionByChangedSinceDate) && !is_string($selectionByChangedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionByChangedSinceDate, true), gettype($selectionByChangedSinceDate)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($selectionByChangedSinceDate) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $selectionByChangedSinceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($selectionByChangedSinceDate, true)), __LINE__);
        }
        $this->SelectionByChangedSinceDate = $selectionByChangedSinceDate;
        return $this;
    }
    /**
     * Get SelectionByLifeCycleStatusCode value
     * @return \StructType\CustomerSelectionByLifeCycleStatusCode[]|null
     */
    public function getSelectionByLifeCycleStatusCode()
    {
        return $this->SelectionByLifeCycleStatusCode;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByLifeCycleStatusCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByLifeCycleStatusCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByLifeCycleStatusCodeForArrayConstraintsFromSetSelectionByLifeCycleStatusCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByLifeCycleStatusCodeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByLifeCycleStatusCodeItem instanceof \StructType\CustomerSelectionByLifeCycleStatusCode) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByLifeCycleStatusCodeItem) ? get_class($customerSelectionByElementsSelectionByLifeCycleStatusCodeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByLifeCycleStatusCodeItem), var_export($customerSelectionByElementsSelectionByLifeCycleStatusCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByLifeCycleStatusCode property can only contain items of type \StructType\CustomerSelectionByLifeCycleStatusCode, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByLifeCycleStatusCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByLifeCycleStatusCode[] $selectionByLifeCycleStatusCode
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByLifeCycleStatusCode(array $selectionByLifeCycleStatusCode = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByLifeCycleStatusCodeArrayErrorMessage = self::validateSelectionByLifeCycleStatusCodeForArrayConstraintsFromSetSelectionByLifeCycleStatusCode($selectionByLifeCycleStatusCode))) {
            throw new \InvalidArgumentException($selectionByLifeCycleStatusCodeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByLifeCycleStatusCode = $selectionByLifeCycleStatusCode;
        return $this;
    }
    /**
     * Add item to SelectionByLifeCycleStatusCode value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByLifeCycleStatusCode $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByLifeCycleStatusCode(\StructType\CustomerSelectionByLifeCycleStatusCode $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByLifeCycleStatusCode) {
            throw new \InvalidArgumentException(sprintf('The SelectionByLifeCycleStatusCode property can only contain items of type \StructType\CustomerSelectionByLifeCycleStatusCode, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByLifeCycleStatusCode[] = $item;
        return $this;
    }
    /**
     * Get SelectionBySearchText value
     * @return string|null
     */
    public function getSelectionBySearchText()
    {
        return $this->SelectionBySearchText;
    }
    /**
     * Set SelectionBySearchText value
     * @param string $selectionBySearchText
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionBySearchText($selectionBySearchText = null)
    {
        // validation for constraint: string
        if (!is_null($selectionBySearchText) && !is_string($selectionBySearchText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionBySearchText, true), gettype($selectionBySearchText)), __LINE__);
        }
        $this->SelectionBySearchText = $selectionBySearchText;
        return $this;
    }
    /**
     * Get SelectionByCreatedSinceDateTime value
     * @return string|null
     */
    public function getSelectionByCreatedSinceDateTime()
    {
        return $this->SelectionByCreatedSinceDateTime;
    }
    /**
     * Set SelectionByCreatedSinceDateTime value
     * @param string $selectionByCreatedSinceDateTime
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByCreatedSinceDateTime($selectionByCreatedSinceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($selectionByCreatedSinceDateTime) && !is_string($selectionByCreatedSinceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionByCreatedSinceDateTime, true), gettype($selectionByCreatedSinceDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($selectionByCreatedSinceDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $selectionByCreatedSinceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($selectionByCreatedSinceDateTime, true)), __LINE__);
        }
        $this->SelectionByCreatedSinceDateTime = $selectionByCreatedSinceDateTime;
        return $this;
    }
    /**
     * Get SelectionByLastChangeSinceDateTime value
     * @return string|null
     */
    public function getSelectionByLastChangeSinceDateTime()
    {
        return $this->SelectionByLastChangeSinceDateTime;
    }
    /**
     * Set SelectionByLastChangeSinceDateTime value
     * @param string $selectionByLastChangeSinceDateTime
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByLastChangeSinceDateTime($selectionByLastChangeSinceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($selectionByLastChangeSinceDateTime) && !is_string($selectionByLastChangeSinceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectionByLastChangeSinceDateTime, true), gettype($selectionByLastChangeSinceDateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($selectionByLastChangeSinceDateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $selectionByLastChangeSinceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($selectionByLastChangeSinceDateTime, true)), __LINE__);
        }
        $this->SelectionByLastChangeSinceDateTime = $selectionByLastChangeSinceDateTime;
        return $this;
    }
    /**
     * Get SelectionByCreationIdentityID value
     * @return \StructType\CustomerSelectionByIdentityID[]|null
     */
    public function getSelectionByCreationIdentityID()
    {
        return $this->SelectionByCreationIdentityID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByCreationIdentityID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByCreationIdentityID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByCreationIdentityIDForArrayConstraintsFromSetSelectionByCreationIdentityID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByCreationIdentityIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByCreationIdentityIDItem instanceof \StructType\CustomerSelectionByIdentityID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByCreationIdentityIDItem) ? get_class($customerSelectionByElementsSelectionByCreationIdentityIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByCreationIdentityIDItem), var_export($customerSelectionByElementsSelectionByCreationIdentityIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByCreationIdentityID property can only contain items of type \StructType\CustomerSelectionByIdentityID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByCreationIdentityID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByIdentityID[] $selectionByCreationIdentityID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByCreationIdentityID(array $selectionByCreationIdentityID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByCreationIdentityIDArrayErrorMessage = self::validateSelectionByCreationIdentityIDForArrayConstraintsFromSetSelectionByCreationIdentityID($selectionByCreationIdentityID))) {
            throw new \InvalidArgumentException($selectionByCreationIdentityIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByCreationIdentityID = $selectionByCreationIdentityID;
        return $this;
    }
    /**
     * Add item to SelectionByCreationIdentityID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByIdentityID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByCreationIdentityID(\StructType\CustomerSelectionByIdentityID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByIdentityID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByCreationIdentityID property can only contain items of type \StructType\CustomerSelectionByIdentityID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByCreationIdentityID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByLastChangeIdentityID value
     * @return \StructType\CustomerSelectionByIdentityID[]|null
     */
    public function getSelectionByLastChangeIdentityID()
    {
        return $this->SelectionByLastChangeIdentityID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByLastChangeIdentityID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByLastChangeIdentityID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByLastChangeIdentityIDForArrayConstraintsFromSetSelectionByLastChangeIdentityID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByLastChangeIdentityIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByLastChangeIdentityIDItem instanceof \StructType\CustomerSelectionByIdentityID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByLastChangeIdentityIDItem) ? get_class($customerSelectionByElementsSelectionByLastChangeIdentityIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByLastChangeIdentityIDItem), var_export($customerSelectionByElementsSelectionByLastChangeIdentityIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByLastChangeIdentityID property can only contain items of type \StructType\CustomerSelectionByIdentityID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByLastChangeIdentityID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByIdentityID[] $selectionByLastChangeIdentityID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByLastChangeIdentityID(array $selectionByLastChangeIdentityID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByLastChangeIdentityIDArrayErrorMessage = self::validateSelectionByLastChangeIdentityIDForArrayConstraintsFromSetSelectionByLastChangeIdentityID($selectionByLastChangeIdentityID))) {
            throw new \InvalidArgumentException($selectionByLastChangeIdentityIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByLastChangeIdentityID = $selectionByLastChangeIdentityID;
        return $this;
    }
    /**
     * Add item to SelectionByLastChangeIdentityID value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByIdentityID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByLastChangeIdentityID(\StructType\CustomerSelectionByIdentityID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByIdentityID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByLastChangeIdentityID property can only contain items of type \StructType\CustomerSelectionByIdentityID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByLastChangeIdentityID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByGroupwareSubscriptionEmployeeUUID value
     * @return \StructType\SelectionByUUID[]|null
     */
    public function getSelectionByGroupwareSubscriptionEmployeeUUID()
    {
        return $this->SelectionByGroupwareSubscriptionEmployeeUUID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByGroupwareSubscriptionEmployeeUUID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByGroupwareSubscriptionEmployeeUUID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByGroupwareSubscriptionEmployeeUUIDForArrayConstraintsFromSetSelectionByGroupwareSubscriptionEmployeeUUID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByGroupwareSubscriptionEmployeeUUIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByGroupwareSubscriptionEmployeeUUIDItem instanceof \StructType\SelectionByUUID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByGroupwareSubscriptionEmployeeUUIDItem) ? get_class($customerSelectionByElementsSelectionByGroupwareSubscriptionEmployeeUUIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByGroupwareSubscriptionEmployeeUUIDItem), var_export($customerSelectionByElementsSelectionByGroupwareSubscriptionEmployeeUUIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByGroupwareSubscriptionEmployeeUUID property can only contain items of type \StructType\SelectionByUUID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByGroupwareSubscriptionEmployeeUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectionByUUID[] $selectionByGroupwareSubscriptionEmployeeUUID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByGroupwareSubscriptionEmployeeUUID(array $selectionByGroupwareSubscriptionEmployeeUUID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByGroupwareSubscriptionEmployeeUUIDArrayErrorMessage = self::validateSelectionByGroupwareSubscriptionEmployeeUUIDForArrayConstraintsFromSetSelectionByGroupwareSubscriptionEmployeeUUID($selectionByGroupwareSubscriptionEmployeeUUID))) {
            throw new \InvalidArgumentException($selectionByGroupwareSubscriptionEmployeeUUIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByGroupwareSubscriptionEmployeeUUID = $selectionByGroupwareSubscriptionEmployeeUUID;
        return $this;
    }
    /**
     * Add item to SelectionByGroupwareSubscriptionEmployeeUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectionByUUID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByGroupwareSubscriptionEmployeeUUID(\StructType\SelectionByUUID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectionByUUID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByGroupwareSubscriptionEmployeeUUID property can only contain items of type \StructType\SelectionByUUID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByGroupwareSubscriptionEmployeeUUID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByResponsibleEmployeeUUID value
     * @return \StructType\SelectionByUUID[]|null
     */
    public function getSelectionByResponsibleEmployeeUUID()
    {
        return $this->SelectionByResponsibleEmployeeUUID;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByResponsibleEmployeeUUID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByResponsibleEmployeeUUID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByResponsibleEmployeeUUIDForArrayConstraintsFromSetSelectionByResponsibleEmployeeUUID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByResponsibleEmployeeUUIDItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByResponsibleEmployeeUUIDItem instanceof \StructType\SelectionByUUID) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByResponsibleEmployeeUUIDItem) ? get_class($customerSelectionByElementsSelectionByResponsibleEmployeeUUIDItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByResponsibleEmployeeUUIDItem), var_export($customerSelectionByElementsSelectionByResponsibleEmployeeUUIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByResponsibleEmployeeUUID property can only contain items of type \StructType\SelectionByUUID, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByResponsibleEmployeeUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectionByUUID[] $selectionByResponsibleEmployeeUUID
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByResponsibleEmployeeUUID(array $selectionByResponsibleEmployeeUUID = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByResponsibleEmployeeUUIDArrayErrorMessage = self::validateSelectionByResponsibleEmployeeUUIDForArrayConstraintsFromSetSelectionByResponsibleEmployeeUUID($selectionByResponsibleEmployeeUUID))) {
            throw new \InvalidArgumentException($selectionByResponsibleEmployeeUUIDArrayErrorMessage, __LINE__);
        }
        $this->SelectionByResponsibleEmployeeUUID = $selectionByResponsibleEmployeeUUID;
        return $this;
    }
    /**
     * Add item to SelectionByResponsibleEmployeeUUID value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectionByUUID $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByResponsibleEmployeeUUID(\StructType\SelectionByUUID $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectionByUUID) {
            throw new \InvalidArgumentException(sprintf('The SelectionByResponsibleEmployeeUUID property can only contain items of type \StructType\SelectionByUUID, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByResponsibleEmployeeUUID[] = $item;
        return $this;
    }
    /**
     * Get SelectionByCreationDateTime value
     * @return \StructType\CustomerSelectionByCreationDateTime[]|null
     */
    public function getSelectionByCreationDateTime()
    {
        return $this->SelectionByCreationDateTime;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByCreationDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByCreationDateTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByCreationDateTimeForArrayConstraintsFromSetSelectionByCreationDateTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByCreationDateTimeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByCreationDateTimeItem instanceof \StructType\CustomerSelectionByCreationDateTime) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByCreationDateTimeItem) ? get_class($customerSelectionByElementsSelectionByCreationDateTimeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByCreationDateTimeItem), var_export($customerSelectionByElementsSelectionByCreationDateTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByCreationDateTime property can only contain items of type \StructType\CustomerSelectionByCreationDateTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByCreationDateTime value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCreationDateTime[] $selectionByCreationDateTime
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByCreationDateTime(array $selectionByCreationDateTime = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByCreationDateTimeArrayErrorMessage = self::validateSelectionByCreationDateTimeForArrayConstraintsFromSetSelectionByCreationDateTime($selectionByCreationDateTime))) {
            throw new \InvalidArgumentException($selectionByCreationDateTimeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByCreationDateTime = $selectionByCreationDateTime;
        return $this;
    }
    /**
     * Add item to SelectionByCreationDateTime value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByCreationDateTime $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByCreationDateTime(\StructType\CustomerSelectionByCreationDateTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByCreationDateTime) {
            throw new \InvalidArgumentException(sprintf('The SelectionByCreationDateTime property can only contain items of type \StructType\CustomerSelectionByCreationDateTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByCreationDateTime[] = $item;
        return $this;
    }
    /**
     * Get SelectionByLastChangeDateTime value
     * @return \StructType\CustomerSelectionByChangeDateTime[]|null
     */
    public function getSelectionByLastChangeDateTime()
    {
        return $this->SelectionByLastChangeDateTime;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectionByLastChangeDateTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectionByLastChangeDateTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectionByLastChangeDateTimeForArrayConstraintsFromSetSelectionByLastChangeDateTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerSelectionByElementsSelectionByLastChangeDateTimeItem) {
            // validation for constraint: itemType
            if (!$customerSelectionByElementsSelectionByLastChangeDateTimeItem instanceof \StructType\CustomerSelectionByChangeDateTime) {
                $invalidValues[] = is_object($customerSelectionByElementsSelectionByLastChangeDateTimeItem) ? get_class($customerSelectionByElementsSelectionByLastChangeDateTimeItem) : sprintf('%s(%s)', gettype($customerSelectionByElementsSelectionByLastChangeDateTimeItem), var_export($customerSelectionByElementsSelectionByLastChangeDateTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectionByLastChangeDateTime property can only contain items of type \StructType\CustomerSelectionByChangeDateTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectionByLastChangeDateTime value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByChangeDateTime[] $selectionByLastChangeDateTime
     * @return \StructType\CustomerSelectionByElements
     */
    public function setSelectionByLastChangeDateTime(array $selectionByLastChangeDateTime = array())
    {
        // validation for constraint: array
        if ('' !== ($selectionByLastChangeDateTimeArrayErrorMessage = self::validateSelectionByLastChangeDateTimeForArrayConstraintsFromSetSelectionByLastChangeDateTime($selectionByLastChangeDateTime))) {
            throw new \InvalidArgumentException($selectionByLastChangeDateTimeArrayErrorMessage, __LINE__);
        }
        $this->SelectionByLastChangeDateTime = $selectionByLastChangeDateTime;
        return $this;
    }
    /**
     * Add item to SelectionByLastChangeDateTime value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerSelectionByChangeDateTime $item
     * @return \StructType\CustomerSelectionByElements
     */
    public function addToSelectionByLastChangeDateTime(\StructType\CustomerSelectionByChangeDateTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerSelectionByChangeDateTime) {
            throw new \InvalidArgumentException(sprintf('The SelectionByLastChangeDateTime property can only contain items of type \StructType\CustomerSelectionByChangeDateTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectionByLastChangeDateTime[] = $item;
        return $this;
    }
}
