<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByCustomerABCClassificationCode
 * StructType
 * @subpackage Structs
 */
class CustomerSelectionByCustomerABCClassificationCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryCustomerABCClassificationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerABCClassificationCode
     */
    public $LowerBoundaryCustomerABCClassificationCode;
    /**
     * The UpperBoundaryCustomerABCClassificationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerABCClassificationCode
     */
    public $UpperBoundaryCustomerABCClassificationCode;
    /**
     * Constructor method for CustomerSelectionByCustomerABCClassificationCode
     * @uses CustomerSelectionByCustomerABCClassificationCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByCustomerABCClassificationCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByCustomerABCClassificationCode::setLowerBoundaryCustomerABCClassificationCode()
     * @uses CustomerSelectionByCustomerABCClassificationCode::setUpperBoundaryCustomerABCClassificationCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\CustomerABCClassificationCode $lowerBoundaryCustomerABCClassificationCode
     * @param \StructType\CustomerABCClassificationCode $upperBoundaryCustomerABCClassificationCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\CustomerABCClassificationCode $lowerBoundaryCustomerABCClassificationCode = null, \StructType\CustomerABCClassificationCode $upperBoundaryCustomerABCClassificationCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryCustomerABCClassificationCode($lowerBoundaryCustomerABCClassificationCode)
            ->setUpperBoundaryCustomerABCClassificationCode($upperBoundaryCustomerABCClassificationCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByCustomerABCClassificationCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByCustomerABCClassificationCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryCustomerABCClassificationCode value
     * @return \StructType\CustomerABCClassificationCode|null
     */
    public function getLowerBoundaryCustomerABCClassificationCode()
    {
        return $this->LowerBoundaryCustomerABCClassificationCode;
    }
    /**
     * Set LowerBoundaryCustomerABCClassificationCode value
     * @param \StructType\CustomerABCClassificationCode $lowerBoundaryCustomerABCClassificationCode
     * @return \StructType\CustomerSelectionByCustomerABCClassificationCode
     */
    public function setLowerBoundaryCustomerABCClassificationCode(\StructType\CustomerABCClassificationCode $lowerBoundaryCustomerABCClassificationCode = null)
    {
        $this->LowerBoundaryCustomerABCClassificationCode = $lowerBoundaryCustomerABCClassificationCode;
        return $this;
    }
    /**
     * Get UpperBoundaryCustomerABCClassificationCode value
     * @return \StructType\CustomerABCClassificationCode|null
     */
    public function getUpperBoundaryCustomerABCClassificationCode()
    {
        return $this->UpperBoundaryCustomerABCClassificationCode;
    }
    /**
     * Set UpperBoundaryCustomerABCClassificationCode value
     * @param \StructType\CustomerABCClassificationCode $upperBoundaryCustomerABCClassificationCode
     * @return \StructType\CustomerSelectionByCustomerABCClassificationCode
     */
    public function setUpperBoundaryCustomerABCClassificationCode(\StructType\CustomerABCClassificationCode $upperBoundaryCustomerABCClassificationCode = null)
    {
        $this->UpperBoundaryCustomerABCClassificationCode = $upperBoundaryCustomerABCClassificationCode;
        return $this;
    }
}
