<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByCategoryCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByCategoryCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - length: 1
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryCategoryCode;
    /**
     * The UpperBoundaryCategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - length: 1
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryCategoryCode;
    /**
     * Constructor method for CustomerSelectionByCategoryCode
     * @uses CustomerSelectionByCategoryCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByCategoryCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByCategoryCode::setLowerBoundaryCategoryCode()
     * @uses CustomerSelectionByCategoryCode::setUpperBoundaryCategoryCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryCategoryCode
     * @param string $upperBoundaryCategoryCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryCategoryCode = null, $upperBoundaryCategoryCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryCategoryCode($lowerBoundaryCategoryCode)
            ->setUpperBoundaryCategoryCode($upperBoundaryCategoryCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByCategoryCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByCategoryCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryCategoryCode value
     * @return string|null
     */
    public function getLowerBoundaryCategoryCode()
    {
        return $this->LowerBoundaryCategoryCode;
    }
    /**
     * Set LowerBoundaryCategoryCode value
     * @param string $lowerBoundaryCategoryCode
     * @return \StructType\CustomerSelectionByCategoryCode
     */
    public function setLowerBoundaryCategoryCode($lowerBoundaryCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryCategoryCode) && !is_string($lowerBoundaryCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryCategoryCode, true), gettype($lowerBoundaryCategoryCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($lowerBoundaryCategoryCode) && mb_strlen($lowerBoundaryCategoryCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($lowerBoundaryCategoryCode)), __LINE__);
        }
        $this->LowerBoundaryCategoryCode = $lowerBoundaryCategoryCode;
        return $this;
    }
    /**
     * Get UpperBoundaryCategoryCode value
     * @return string|null
     */
    public function getUpperBoundaryCategoryCode()
    {
        return $this->UpperBoundaryCategoryCode;
    }
    /**
     * Set UpperBoundaryCategoryCode value
     * @param string $upperBoundaryCategoryCode
     * @return \StructType\CustomerSelectionByCategoryCode
     */
    public function setUpperBoundaryCategoryCode($upperBoundaryCategoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryCategoryCode) && !is_string($upperBoundaryCategoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryCategoryCode, true), gettype($upperBoundaryCategoryCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($upperBoundaryCategoryCode) && mb_strlen($upperBoundaryCategoryCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($upperBoundaryCategoryCode)), __LINE__);
        }
        $this->UpperBoundaryCategoryCode = $upperBoundaryCategoryCode;
        return $this;
    }
}
