<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByBusinessPartnerAdditionalName
 * StructType
 * @subpackage Structs
 */
class CustomerSelectionByBusinessPartnerAdditionalName extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryBusinessPartnerAdditionalName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $LowerBoundaryBusinessPartnerAdditionalName;
    /**
     * The UpperBoundaryBusinessPartnerAdditionalName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $UpperBoundaryBusinessPartnerAdditionalName;
    /**
     * Constructor method for CustomerSelectionByBusinessPartnerAdditionalName
     * @uses CustomerSelectionByBusinessPartnerAdditionalName::setInclusionExclusionCode()
     * @uses CustomerSelectionByBusinessPartnerAdditionalName::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByBusinessPartnerAdditionalName::setLowerBoundaryBusinessPartnerAdditionalName()
     * @uses CustomerSelectionByBusinessPartnerAdditionalName::setUpperBoundaryBusinessPartnerAdditionalName()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param string $lowerBoundaryBusinessPartnerAdditionalName
     * @param string $upperBoundaryBusinessPartnerAdditionalName
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, $lowerBoundaryBusinessPartnerAdditionalName = null, $upperBoundaryBusinessPartnerAdditionalName = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryBusinessPartnerAdditionalName($lowerBoundaryBusinessPartnerAdditionalName)
            ->setUpperBoundaryBusinessPartnerAdditionalName($upperBoundaryBusinessPartnerAdditionalName);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByBusinessPartnerAdditionalName
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByBusinessPartnerAdditionalName
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryBusinessPartnerAdditionalName value
     * @return string|null
     */
    public function getLowerBoundaryBusinessPartnerAdditionalName()
    {
        return $this->LowerBoundaryBusinessPartnerAdditionalName;
    }
    /**
     * Set LowerBoundaryBusinessPartnerAdditionalName value
     * @param string $lowerBoundaryBusinessPartnerAdditionalName
     * @return \StructType\CustomerSelectionByBusinessPartnerAdditionalName
     */
    public function setLowerBoundaryBusinessPartnerAdditionalName($lowerBoundaryBusinessPartnerAdditionalName = null)
    {
        // validation for constraint: string
        if (!is_null($lowerBoundaryBusinessPartnerAdditionalName) && !is_string($lowerBoundaryBusinessPartnerAdditionalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lowerBoundaryBusinessPartnerAdditionalName, true), gettype($lowerBoundaryBusinessPartnerAdditionalName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($lowerBoundaryBusinessPartnerAdditionalName) && mb_strlen($lowerBoundaryBusinessPartnerAdditionalName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($lowerBoundaryBusinessPartnerAdditionalName)), __LINE__);
        }
        $this->LowerBoundaryBusinessPartnerAdditionalName = $lowerBoundaryBusinessPartnerAdditionalName;
        return $this;
    }
    /**
     * Get UpperBoundaryBusinessPartnerAdditionalName value
     * @return string|null
     */
    public function getUpperBoundaryBusinessPartnerAdditionalName()
    {
        return $this->UpperBoundaryBusinessPartnerAdditionalName;
    }
    /**
     * Set UpperBoundaryBusinessPartnerAdditionalName value
     * @param string $upperBoundaryBusinessPartnerAdditionalName
     * @return \StructType\CustomerSelectionByBusinessPartnerAdditionalName
     */
    public function setUpperBoundaryBusinessPartnerAdditionalName($upperBoundaryBusinessPartnerAdditionalName = null)
    {
        // validation for constraint: string
        if (!is_null($upperBoundaryBusinessPartnerAdditionalName) && !is_string($upperBoundaryBusinessPartnerAdditionalName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upperBoundaryBusinessPartnerAdditionalName, true), gettype($upperBoundaryBusinessPartnerAdditionalName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($upperBoundaryBusinessPartnerAdditionalName) && mb_strlen($upperBoundaryBusinessPartnerAdditionalName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($upperBoundaryBusinessPartnerAdditionalName)), __LINE__);
        }
        $this->UpperBoundaryBusinessPartnerAdditionalName = $upperBoundaryBusinessPartnerAdditionalName;
        return $this;
    }
}
