<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerSelectionByBusinessCharacterCode StructType
 * @subpackage Structs
 */
class CustomerSelectionByBusinessCharacterCode extends AbstractStructBase
{
    /**
     * The InclusionExclusionCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InclusionExclusionCode;
    /**
     * The IntervalBoundaryTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $IntervalBoundaryTypeCode;
    /**
     * The LowerBoundaryBusinessCharacterCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode
     */
    public $LowerBoundaryBusinessCharacterCode;
    /**
     * The UpperBoundaryBusinessCharacterCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode
     */
    public $UpperBoundaryBusinessCharacterCode;
    /**
     * Constructor method for CustomerSelectionByBusinessCharacterCode
     * @uses CustomerSelectionByBusinessCharacterCode::setInclusionExclusionCode()
     * @uses CustomerSelectionByBusinessCharacterCode::setIntervalBoundaryTypeCode()
     * @uses CustomerSelectionByBusinessCharacterCode::setLowerBoundaryBusinessCharacterCode()
     * @uses CustomerSelectionByBusinessCharacterCode::setUpperBoundaryBusinessCharacterCode()
     * @param string $inclusionExclusionCode
     * @param string $intervalBoundaryTypeCode
     * @param \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $lowerBoundaryBusinessCharacterCode
     * @param \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $upperBoundaryBusinessCharacterCode
     */
    public function __construct($inclusionExclusionCode = null, $intervalBoundaryTypeCode = null, \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $lowerBoundaryBusinessCharacterCode = null, \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $upperBoundaryBusinessCharacterCode = null)
    {
        $this
            ->setInclusionExclusionCode($inclusionExclusionCode)
            ->setIntervalBoundaryTypeCode($intervalBoundaryTypeCode)
            ->setLowerBoundaryBusinessCharacterCode($lowerBoundaryBusinessCharacterCode)
            ->setUpperBoundaryBusinessCharacterCode($upperBoundaryBusinessCharacterCode);
    }
    /**
     * Get InclusionExclusionCode value
     * @return string|null
     */
    public function getInclusionExclusionCode()
    {
        return $this->InclusionExclusionCode;
    }
    /**
     * Set InclusionExclusionCode value
     * @param string $inclusionExclusionCode
     * @return \StructType\CustomerSelectionByBusinessCharacterCode
     */
    public function setInclusionExclusionCode($inclusionExclusionCode = null)
    {
        // validation for constraint: string
        if (!is_null($inclusionExclusionCode) && !is_string($inclusionExclusionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inclusionExclusionCode, true), gettype($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($inclusionExclusionCode) && mb_strlen($inclusionExclusionCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($inclusionExclusionCode)), __LINE__);
        }
        $this->InclusionExclusionCode = $inclusionExclusionCode;
        return $this;
    }
    /**
     * Get IntervalBoundaryTypeCode value
     * @return string|null
     */
    public function getIntervalBoundaryTypeCode()
    {
        return $this->IntervalBoundaryTypeCode;
    }
    /**
     * Set IntervalBoundaryTypeCode value
     * @param string $intervalBoundaryTypeCode
     * @return \StructType\CustomerSelectionByBusinessCharacterCode
     */
    public function setIntervalBoundaryTypeCode($intervalBoundaryTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($intervalBoundaryTypeCode) && !is_string($intervalBoundaryTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intervalBoundaryTypeCode, true), gettype($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($intervalBoundaryTypeCode) && mb_strlen($intervalBoundaryTypeCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($intervalBoundaryTypeCode)), __LINE__);
        }
        $this->IntervalBoundaryTypeCode = $intervalBoundaryTypeCode;
        return $this;
    }
    /**
     * Get LowerBoundaryBusinessCharacterCode value
     * @return \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode|null
     */
    public function getLowerBoundaryBusinessCharacterCode()
    {
        return $this->LowerBoundaryBusinessCharacterCode;
    }
    /**
     * Set LowerBoundaryBusinessCharacterCode value
     * @param \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $lowerBoundaryBusinessCharacterCode
     * @return \StructType\CustomerSelectionByBusinessCharacterCode
     */
    public function setLowerBoundaryBusinessCharacterCode(\StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $lowerBoundaryBusinessCharacterCode = null)
    {
        $this->LowerBoundaryBusinessCharacterCode = $lowerBoundaryBusinessCharacterCode;
        return $this;
    }
    /**
     * Get UpperBoundaryBusinessCharacterCode value
     * @return \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode|null
     */
    public function getUpperBoundaryBusinessCharacterCode()
    {
        return $this->UpperBoundaryBusinessCharacterCode;
    }
    /**
     * Set UpperBoundaryBusinessCharacterCode value
     * @param \StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $upperBoundaryBusinessCharacterCode
     * @return \StructType\CustomerSelectionByBusinessCharacterCode
     */
    public function setUpperBoundaryBusinessCharacterCode(\StructType\BUSINESSPARTNER_PartyBusinessCharacterCode $upperBoundaryBusinessCharacterCode = null)
    {
        $this->UpperBoundaryBusinessCharacterCode = $upperBoundaryBusinessCharacterCode;
        return $this;
    }
}
