<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerResponseMessage_sync StructType
 * @subpackage Structs
 */
class CustomerResponseMessage_sync extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomer[]
     */
    public $Customer;
    /**
     * The ProcessingConditions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResponseProcessingConditions
     */
    public $ProcessingConditions;
    /**
     * The Log
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Log
     */
    public $Log;
    /**
     * Constructor method for CustomerResponseMessage_sync
     * @uses CustomerResponseMessage_sync::setCustomer()
     * @uses CustomerResponseMessage_sync::setProcessingConditions()
     * @uses CustomerResponseMessage_sync::setLog()
     * @param \StructType\CustomerReponseCustomer[] $customer
     * @param \StructType\ResponseProcessingConditions $processingConditions
     * @param \StructType\Log $log
     */
    public function __construct(array $customer = array(), \StructType\ResponseProcessingConditions $processingConditions = null, \StructType\Log $log = null)
    {
        $this
            ->setCustomer($customer)
            ->setProcessingConditions($processingConditions)
            ->setLog($log);
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerReponseCustomer[]|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * This method is responsible for validating the values passed to the setCustomer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCustomer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCustomerForArrayConstraintsFromSetCustomer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerResponseMessage_syncCustomerItem) {
            // validation for constraint: itemType
            if (!$customerResponseMessage_syncCustomerItem instanceof \StructType\CustomerReponseCustomer) {
                $invalidValues[] = is_object($customerResponseMessage_syncCustomerItem) ? get_class($customerResponseMessage_syncCustomerItem) : sprintf('%s(%s)', gettype($customerResponseMessage_syncCustomerItem), var_export($customerResponseMessage_syncCustomerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Customer property can only contain items of type \StructType\CustomerReponseCustomer, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Customer value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomer[] $customer
     * @return \StructType\CustomerResponseMessage_sync
     */
    public function setCustomer(array $customer = array())
    {
        // validation for constraint: array
        if ('' !== ($customerArrayErrorMessage = self::validateCustomerForArrayConstraintsFromSetCustomer($customer))) {
            throw new \InvalidArgumentException($customerArrayErrorMessage, __LINE__);
        }
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Add item to Customer value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomer $item
     * @return \StructType\CustomerResponseMessage_sync
     */
    public function addToCustomer(\StructType\CustomerReponseCustomer $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomer) {
            throw new \InvalidArgumentException(sprintf('The Customer property can only contain items of type \StructType\CustomerReponseCustomer, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Customer[] = $item;
        return $this;
    }
    /**
     * Get ProcessingConditions value
     * @return \StructType\ResponseProcessingConditions|null
     */
    public function getProcessingConditions()
    {
        return $this->ProcessingConditions;
    }
    /**
     * Set ProcessingConditions value
     * @param \StructType\ResponseProcessingConditions $processingConditions
     * @return \StructType\CustomerResponseMessage_sync
     */
    public function setProcessingConditions(\StructType\ResponseProcessingConditions $processingConditions = null)
    {
        $this->ProcessingConditions = $processingConditions;
        return $this;
    }
    /**
     * Get Log value
     * @return \StructType\Log|null
     */
    public function getLog()
    {
        return $this->Log;
    }
    /**
     * Set Log value
     * @param \StructType\Log $log
     * @return \StructType\CustomerResponseMessage_sync
     */
    public function setLog(\StructType\Log $log = null)
    {
        $this->Log = $log;
        return $this;
    }
}
