<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerResponseCustomerTaxExemptionCertificate StructType
 * @subpackage Structs
 */
class CustomerResponseCustomerTaxExemptionCertificate extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxExemptionCertificateID
     */
    public $ID;
    /**
     * The ExternalID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxExemptionCertificateID
     */
    public $ExternalID;
    /**
     * The CompanyID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyID;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxExemptionCertificateTypeCode
     */
    public $TypeCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * The RegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $RegionCode;
    /**
     * The TaxTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TaxTypeCode
     */
    public $TaxTypeCode;
    /**
     * The ValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CLOSED_DatePeriod
     */
    public $ValidityPeriod;
    /**
     * The MaximumAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amount
     */
    public $MaximumAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Amount
     */
    public $TotalAmount;
    /**
     * The LifeCycleStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LifeCycleStatusCode;
    /**
     * The TaxExemptionReason
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason[]
     */
    public $TaxExemptionReason;
    /**
     * Constructor method for CustomerResponseCustomerTaxExemptionCertificate
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setID()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setExternalID()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setCompanyID()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setTypeCode()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setCountryCode()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setRegionCode()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setTaxTypeCode()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setValidityPeriod()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setMaximumAmount()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setTotalAmount()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setLifeCycleStatusCode()
     * @uses CustomerResponseCustomerTaxExemptionCertificate::setTaxExemptionReason()
     * @param \StructType\TaxExemptionCertificateID $iD
     * @param \StructType\TaxExemptionCertificateID $externalID
     * @param string $companyID
     * @param \StructType\TaxExemptionCertificateTypeCode $typeCode
     * @param string $countryCode
     * @param \StructType\RegionCode $regionCode
     * @param \StructType\TaxTypeCode $taxTypeCode
     * @param \StructType\CLOSED_DatePeriod $validityPeriod
     * @param \StructType\Amount $maximumAmount
     * @param \StructType\Amount $totalAmount
     * @param string $lifeCycleStatusCode
     * @param \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason[] $taxExemptionReason
     */
    public function __construct(\StructType\TaxExemptionCertificateID $iD = null, \StructType\TaxExemptionCertificateID $externalID = null, $companyID = null, \StructType\TaxExemptionCertificateTypeCode $typeCode = null, $countryCode = null, \StructType\RegionCode $regionCode = null, \StructType\TaxTypeCode $taxTypeCode = null, \StructType\CLOSED_DatePeriod $validityPeriod = null, \StructType\Amount $maximumAmount = null, \StructType\Amount $totalAmount = null, $lifeCycleStatusCode = null, array $taxExemptionReason = array())
    {
        $this
            ->setID($iD)
            ->setExternalID($externalID)
            ->setCompanyID($companyID)
            ->setTypeCode($typeCode)
            ->setCountryCode($countryCode)
            ->setRegionCode($regionCode)
            ->setTaxTypeCode($taxTypeCode)
            ->setValidityPeriod($validityPeriod)
            ->setMaximumAmount($maximumAmount)
            ->setTotalAmount($totalAmount)
            ->setLifeCycleStatusCode($lifeCycleStatusCode)
            ->setTaxExemptionReason($taxExemptionReason);
    }
    /**
     * Get ID value
     * @return \StructType\TaxExemptionCertificateID|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param \StructType\TaxExemptionCertificateID $iD
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setID(\StructType\TaxExemptionCertificateID $iD = null)
    {
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get ExternalID value
     * @return \StructType\TaxExemptionCertificateID|null
     */
    public function getExternalID()
    {
        return $this->ExternalID;
    }
    /**
     * Set ExternalID value
     * @param \StructType\TaxExemptionCertificateID $externalID
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setExternalID(\StructType\TaxExemptionCertificateID $externalID = null)
    {
        $this->ExternalID = $externalID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return string|null
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param string $companyID
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: string
        if (!is_null($companyID) && !is_string($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyID, true), gettype($companyID)), __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($companyID) && mb_strlen($companyID) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($companyID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($companyID) && mb_strlen($companyID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return \StructType\TaxExemptionCertificateTypeCode|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param \StructType\TaxExemptionCertificateTypeCode $typeCode
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setTypeCode(\StructType\TaxExemptionCertificateTypeCode $typeCode = null)
    {
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get RegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param \StructType\RegionCode $regionCode
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setRegionCode(\StructType\RegionCode $regionCode = null)
    {
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get TaxTypeCode value
     * @return \StructType\TaxTypeCode|null
     */
    public function getTaxTypeCode()
    {
        return $this->TaxTypeCode;
    }
    /**
     * Set TaxTypeCode value
     * @param \StructType\TaxTypeCode $taxTypeCode
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setTaxTypeCode(\StructType\TaxTypeCode $taxTypeCode = null)
    {
        $this->TaxTypeCode = $taxTypeCode;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * @return \StructType\CLOSED_DatePeriod|null
     */
    public function getValidityPeriod()
    {
        return $this->ValidityPeriod;
    }
    /**
     * Set ValidityPeriod value
     * @param \StructType\CLOSED_DatePeriod $validityPeriod
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setValidityPeriod(\StructType\CLOSED_DatePeriod $validityPeriod = null)
    {
        $this->ValidityPeriod = $validityPeriod;
        return $this;
    }
    /**
     * Get MaximumAmount value
     * @return \StructType\Amount|null
     */
    public function getMaximumAmount()
    {
        return $this->MaximumAmount;
    }
    /**
     * Set MaximumAmount value
     * @param \StructType\Amount $maximumAmount
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setMaximumAmount(\StructType\Amount $maximumAmount = null)
    {
        $this->MaximumAmount = $maximumAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return \StructType\Amount|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param \StructType\Amount $totalAmount
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setTotalAmount(\StructType\Amount $totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get LifeCycleStatusCode value
     * @return string|null
     */
    public function getLifeCycleStatusCode()
    {
        return $this->LifeCycleStatusCode;
    }
    /**
     * Set LifeCycleStatusCode value
     * @uses \EnumType\CustomerTaxExemptionCertificateLifeCycleStatusCode::valueIsValid()
     * @uses \EnumType\CustomerTaxExemptionCertificateLifeCycleStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lifeCycleStatusCode
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setLifeCycleStatusCode($lifeCycleStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CustomerTaxExemptionCertificateLifeCycleStatusCode::valueIsValid($lifeCycleStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CustomerTaxExemptionCertificateLifeCycleStatusCode', is_array($lifeCycleStatusCode) ? implode(', ', $lifeCycleStatusCode) : var_export($lifeCycleStatusCode, true), implode(', ', \EnumType\CustomerTaxExemptionCertificateLifeCycleStatusCode::getValidValues())), __LINE__);
        }
        $this->LifeCycleStatusCode = $lifeCycleStatusCode;
        return $this;
    }
    /**
     * Get TaxExemptionReason value
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason[]|null
     */
    public function getTaxExemptionReason()
    {
        return $this->TaxExemptionReason;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxExemptionReason method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxExemptionReason method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxExemptionReasonForArrayConstraintsFromSetTaxExemptionReason(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerResponseCustomerTaxExemptionCertificateTaxExemptionReasonItem) {
            // validation for constraint: itemType
            if (!$customerResponseCustomerTaxExemptionCertificateTaxExemptionReasonItem instanceof \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason) {
                $invalidValues[] = is_object($customerResponseCustomerTaxExemptionCertificateTaxExemptionReasonItem) ? get_class($customerResponseCustomerTaxExemptionCertificateTaxExemptionReasonItem) : sprintf('%s(%s)', gettype($customerResponseCustomerTaxExemptionCertificateTaxExemptionReasonItem), var_export($customerResponseCustomerTaxExemptionCertificateTaxExemptionReasonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxExemptionReason property can only contain items of type \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxExemptionReason value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason[] $taxExemptionReason
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function setTaxExemptionReason(array $taxExemptionReason = array())
    {
        // validation for constraint: array
        if ('' !== ($taxExemptionReasonArrayErrorMessage = self::validateTaxExemptionReasonForArrayConstraintsFromSetTaxExemptionReason($taxExemptionReason))) {
            throw new \InvalidArgumentException($taxExemptionReasonArrayErrorMessage, __LINE__);
        }
        $this->TaxExemptionReason = $taxExemptionReason;
        return $this;
    }
    /**
     * Add item to TaxExemptionReason value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason $item
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate
     */
    public function addToTaxExemptionReason(\StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason) {
            throw new \InvalidArgumentException(sprintf('The TaxExemptionReason property can only contain items of type \StructType\CustomerResponseCustomerTaxExemptionCertificateTaxExemptionReason, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxExemptionReason[] = $item;
        return $this;
    }
}
