<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerRequestedElements StructType
 * @subpackage Structs
 */
class CustomerRequestedElements extends AbstractStructBase
{
    /**
     * The Customer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerRequestedElementsCustomer
     */
    public $Customer;
    /**
     * The customerTransmissionRequestCode
     * @var string
     */
    public $customerTransmissionRequestCode;
    /**
     * Constructor method for CustomerRequestedElements
     * @uses CustomerRequestedElements::setCustomer()
     * @uses CustomerRequestedElements::setCustomerTransmissionRequestCode()
     * @param \StructType\CustomerRequestedElementsCustomer $customer
     * @param string $customerTransmissionRequestCode
     */
    public function __construct(\StructType\CustomerRequestedElementsCustomer $customer = null, $customerTransmissionRequestCode = null)
    {
        $this
            ->setCustomer($customer)
            ->setCustomerTransmissionRequestCode($customerTransmissionRequestCode);
    }
    /**
     * Get Customer value
     * @return \StructType\CustomerRequestedElementsCustomer|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param \StructType\CustomerRequestedElementsCustomer $customer
     * @return \StructType\CustomerRequestedElements
     */
    public function setCustomer(\StructType\CustomerRequestedElementsCustomer $customer = null)
    {
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get customerTransmissionRequestCode value
     * @return string|null
     */
    public function getCustomerTransmissionRequestCode()
    {
        return $this->customerTransmissionRequestCode;
    }
    /**
     * Set customerTransmissionRequestCode value
     * @uses \EnumType\TransmissionRequestCode::valueIsValid()
     * @uses \EnumType\TransmissionRequestCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerTransmissionRequestCode
     * @return \StructType\CustomerRequestedElements
     */
    public function setCustomerTransmissionRequestCode($customerTransmissionRequestCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransmissionRequestCode::valueIsValid($customerTransmissionRequestCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TransmissionRequestCode', is_array($customerTransmissionRequestCode) ? implode(', ', $customerTransmissionRequestCode) : var_export($customerTransmissionRequestCode, true), implode(', ', \EnumType\TransmissionRequestCode::getValidValues())), __LINE__);
        }
        $this->customerTransmissionRequestCode = $customerTransmissionRequestCode;
        return $this;
    }
}
