<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerTaxNumber StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerTaxNumber extends AbstractStructBase
{
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * @var string
     */
    public $CountryCode;
    /**
     * The TaxIdentificationNumberTypeCode
     * @var \StructType\TaxIdentificationNumberTypeCode
     */
    public $TaxIdentificationNumberTypeCode;
    /**
     * The PartyTaxID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PartyTaxID
     */
    public $PartyTaxID;
    /**
     * Constructor method for CustomerReponseCustomerTaxNumber
     * @uses CustomerReponseCustomerTaxNumber::setCountryCode()
     * @uses CustomerReponseCustomerTaxNumber::setTaxIdentificationNumberTypeCode()
     * @uses CustomerReponseCustomerTaxNumber::setPartyTaxID()
     * @param string $countryCode
     * @param \StructType\TaxIdentificationNumberTypeCode $taxIdentificationNumberTypeCode
     * @param \StructType\PartyTaxID $partyTaxID
     */
    public function __construct($countryCode = null, \StructType\TaxIdentificationNumberTypeCode $taxIdentificationNumberTypeCode = null, \StructType\PartyTaxID $partyTaxID = null)
    {
        $this
            ->setCountryCode($countryCode)
            ->setTaxIdentificationNumberTypeCode($taxIdentificationNumberTypeCode)
            ->setPartyTaxID($partyTaxID);
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CustomerReponseCustomerTaxNumber
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
    /**
     * Get TaxIdentificationNumberTypeCode value
     * @return \StructType\TaxIdentificationNumberTypeCode|null
     */
    public function getTaxIdentificationNumberTypeCode()
    {
        return $this->TaxIdentificationNumberTypeCode;
    }
    /**
     * Set TaxIdentificationNumberTypeCode value
     * @param \StructType\TaxIdentificationNumberTypeCode $taxIdentificationNumberTypeCode
     * @return \StructType\CustomerReponseCustomerTaxNumber
     */
    public function setTaxIdentificationNumberTypeCode(\StructType\TaxIdentificationNumberTypeCode $taxIdentificationNumberTypeCode = null)
    {
        $this->TaxIdentificationNumberTypeCode = $taxIdentificationNumberTypeCode;
        return $this;
    }
    /**
     * Get PartyTaxID value
     * @return \StructType\PartyTaxID|null
     */
    public function getPartyTaxID()
    {
        return $this->PartyTaxID;
    }
    /**
     * Set PartyTaxID value
     * @param \StructType\PartyTaxID $partyTaxID
     * @return \StructType\CustomerReponseCustomerTaxNumber
     */
    public function setPartyTaxID(\StructType\PartyTaxID $partyTaxID = null)
    {
        $this->PartyTaxID = $partyTaxID;
        return $this;
    }
}
