<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerPerson StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerPerson extends AbstractStructBase
{
    /**
     * The FormOfAddressCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormOfAddressCode
     */
    public $FormOfAddressCode;
    /**
     * The AcademicTitleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AcademicTitleCode
     */
    public $AcademicTitleCode;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The FamilyName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FamilyName;
    /**
     * The BirthName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $BirthName;
    /**
     * The NickName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $NickName;
    /**
     * The NameFormatCountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $NameFormatCountryCode;
    /**
     * The GenderCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $GenderCode;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Date
     * - base: xsd:date
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $BirthDate;
    /**
     * The NonVerbalCommunicationLanguageCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:language
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $NonVerbalCommunicationLanguageCode;
    /**
     * The OccupationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OccupationCode
     */
    public $OccupationCode;
    /**
     * Constructor method for CustomerReponseCustomerPerson
     * @uses CustomerReponseCustomerPerson::setFormOfAddressCode()
     * @uses CustomerReponseCustomerPerson::setAcademicTitleCode()
     * @uses CustomerReponseCustomerPerson::setGivenName()
     * @uses CustomerReponseCustomerPerson::setMiddleName()
     * @uses CustomerReponseCustomerPerson::setFamilyName()
     * @uses CustomerReponseCustomerPerson::setBirthName()
     * @uses CustomerReponseCustomerPerson::setNickName()
     * @uses CustomerReponseCustomerPerson::setNameFormatCountryCode()
     * @uses CustomerReponseCustomerPerson::setGenderCode()
     * @uses CustomerReponseCustomerPerson::setBirthDate()
     * @uses CustomerReponseCustomerPerson::setNonVerbalCommunicationLanguageCode()
     * @uses CustomerReponseCustomerPerson::setOccupationCode()
     * @param \StructType\FormOfAddressCode $formOfAddressCode
     * @param \StructType\AcademicTitleCode $academicTitleCode
     * @param string $givenName
     * @param string $middleName
     * @param string $familyName
     * @param string $birthName
     * @param string $nickName
     * @param string $nameFormatCountryCode
     * @param string $genderCode
     * @param string $birthDate
     * @param string $nonVerbalCommunicationLanguageCode
     * @param \StructType\OccupationCode $occupationCode
     */
    public function __construct(\StructType\FormOfAddressCode $formOfAddressCode = null, \StructType\AcademicTitleCode $academicTitleCode = null, $givenName = null, $middleName = null, $familyName = null, $birthName = null, $nickName = null, $nameFormatCountryCode = null, $genderCode = null, $birthDate = null, $nonVerbalCommunicationLanguageCode = null, \StructType\OccupationCode $occupationCode = null)
    {
        $this
            ->setFormOfAddressCode($formOfAddressCode)
            ->setAcademicTitleCode($academicTitleCode)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setFamilyName($familyName)
            ->setBirthName($birthName)
            ->setNickName($nickName)
            ->setNameFormatCountryCode($nameFormatCountryCode)
            ->setGenderCode($genderCode)
            ->setBirthDate($birthDate)
            ->setNonVerbalCommunicationLanguageCode($nonVerbalCommunicationLanguageCode)
            ->setOccupationCode($occupationCode);
    }
    /**
     * Get FormOfAddressCode value
     * @return \StructType\FormOfAddressCode|null
     */
    public function getFormOfAddressCode()
    {
        return $this->FormOfAddressCode;
    }
    /**
     * Set FormOfAddressCode value
     * @param \StructType\FormOfAddressCode $formOfAddressCode
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setFormOfAddressCode(\StructType\FormOfAddressCode $formOfAddressCode = null)
    {
        $this->FormOfAddressCode = $formOfAddressCode;
        return $this;
    }
    /**
     * Get AcademicTitleCode value
     * @return \StructType\AcademicTitleCode|null
     */
    public function getAcademicTitleCode()
    {
        return $this->AcademicTitleCode;
    }
    /**
     * Set AcademicTitleCode value
     * @param \StructType\AcademicTitleCode $academicTitleCode
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setAcademicTitleCode(\StructType\AcademicTitleCode $academicTitleCode = null)
    {
        $this->AcademicTitleCode = $academicTitleCode;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string $givenName
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($givenName, true), gettype($givenName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($givenName) && mb_strlen($givenName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($givenName)), __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($middleName) && mb_strlen($middleName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get FamilyName value
     * @return string|null
     */
    public function getFamilyName()
    {
        return $this->FamilyName;
    }
    /**
     * Set FamilyName value
     * @param string $familyName
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setFamilyName($familyName = null)
    {
        // validation for constraint: string
        if (!is_null($familyName) && !is_string($familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familyName, true), gettype($familyName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($familyName) && mb_strlen($familyName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($familyName)), __LINE__);
        }
        $this->FamilyName = $familyName;
        return $this;
    }
    /**
     * Get BirthName value
     * @return string|null
     */
    public function getBirthName()
    {
        return $this->BirthName;
    }
    /**
     * Set BirthName value
     * @param string $birthName
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setBirthName($birthName = null)
    {
        // validation for constraint: string
        if (!is_null($birthName) && !is_string($birthName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthName, true), gettype($birthName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($birthName) && mb_strlen($birthName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($birthName)), __LINE__);
        }
        $this->BirthName = $birthName;
        return $this;
    }
    /**
     * Get NickName value
     * @return string|null
     */
    public function getNickName()
    {
        return $this->NickName;
    }
    /**
     * Set NickName value
     * @param string $nickName
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setNickName($nickName = null)
    {
        // validation for constraint: string
        if (!is_null($nickName) && !is_string($nickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickName, true), gettype($nickName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($nickName) && mb_strlen($nickName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($nickName)), __LINE__);
        }
        $this->NickName = $nickName;
        return $this;
    }
    /**
     * Get NameFormatCountryCode value
     * @return string|null
     */
    public function getNameFormatCountryCode()
    {
        return $this->NameFormatCountryCode;
    }
    /**
     * Set NameFormatCountryCode value
     * @param string $nameFormatCountryCode
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setNameFormatCountryCode($nameFormatCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($nameFormatCountryCode) && !is_string($nameFormatCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameFormatCountryCode, true), gettype($nameFormatCountryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($nameFormatCountryCode) && mb_strlen($nameFormatCountryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($nameFormatCountryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($nameFormatCountryCode) && mb_strlen($nameFormatCountryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($nameFormatCountryCode)), __LINE__);
        }
        $this->NameFormatCountryCode = $nameFormatCountryCode;
        return $this;
    }
    /**
     * Get GenderCode value
     * @return string|null
     */
    public function getGenderCode()
    {
        return $this->GenderCode;
    }
    /**
     * Set GenderCode value
     * @param string $genderCode
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setGenderCode($genderCode = null)
    {
        // validation for constraint: string
        if (!is_null($genderCode) && !is_string($genderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genderCode, true), gettype($genderCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($genderCode) && mb_strlen($genderCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($genderCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($genderCode) && mb_strlen($genderCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($genderCode)), __LINE__);
        }
        $this->GenderCode = $genderCode;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($birthDate) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($birthDate, true)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get NonVerbalCommunicationLanguageCode value
     * @return string|null
     */
    public function getNonVerbalCommunicationLanguageCode()
    {
        return $this->NonVerbalCommunicationLanguageCode;
    }
    /**
     * Set NonVerbalCommunicationLanguageCode value
     * @param string $nonVerbalCommunicationLanguageCode
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setNonVerbalCommunicationLanguageCode($nonVerbalCommunicationLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($nonVerbalCommunicationLanguageCode) && !is_string($nonVerbalCommunicationLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonVerbalCommunicationLanguageCode, true), gettype($nonVerbalCommunicationLanguageCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($nonVerbalCommunicationLanguageCode) && mb_strlen($nonVerbalCommunicationLanguageCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($nonVerbalCommunicationLanguageCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($nonVerbalCommunicationLanguageCode) && mb_strlen($nonVerbalCommunicationLanguageCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($nonVerbalCommunicationLanguageCode)), __LINE__);
        }
        $this->NonVerbalCommunicationLanguageCode = $nonVerbalCommunicationLanguageCode;
        return $this;
    }
    /**
     * Get OccupationCode value
     * @return \StructType\OccupationCode|null
     */
    public function getOccupationCode()
    {
        return $this->OccupationCode;
    }
    /**
     * Set OccupationCode value
     * @param \StructType\OccupationCode $occupationCode
     * @return \StructType\CustomerReponseCustomerPerson
     */
    public function setOccupationCode(\StructType\OccupationCode $occupationCode = null)
    {
        $this->OccupationCode = $occupationCode;
        return $this;
    }
}
