<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerPaymentCardDetails StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerPaymentCardDetails extends AbstractStructBase
{
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 6
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ID;
    /**
     * The PaymentCardTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentCardTypeCode
     */
    public $PaymentCardTypeCode;
    /**
     * The PaymentCardID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentCardID
     */
    public $PaymentCardID;
    /**
     * The PaymentCardHolderName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $PaymentCardHolderName;
    /**
     * The PaymentCardExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Date
     * - base: xsd:date
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $PaymentCardExpirationDate;
    /**
     * The DefaultIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $DefaultIndicator;
    /**
     * The BlockingReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PaymentCardBlockingReasonCode
     */
    public $BlockingReasonCode;
    /**
     * The StreetName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetName;
    /**
     * The HouseID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $HouseID;
    /**
     * The PostalCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The CityName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $CityName;
    /**
     * The RegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RegionCode
     */
    public $RegionCode;
    /**
     * The CountryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $CountryCode;
    /**
     * Constructor method for CustomerReponseCustomerPaymentCardDetails
     * @uses CustomerReponseCustomerPaymentCardDetails::setID()
     * @uses CustomerReponseCustomerPaymentCardDetails::setPaymentCardTypeCode()
     * @uses CustomerReponseCustomerPaymentCardDetails::setPaymentCardID()
     * @uses CustomerReponseCustomerPaymentCardDetails::setPaymentCardHolderName()
     * @uses CustomerReponseCustomerPaymentCardDetails::setPaymentCardExpirationDate()
     * @uses CustomerReponseCustomerPaymentCardDetails::setDefaultIndicator()
     * @uses CustomerReponseCustomerPaymentCardDetails::setBlockingReasonCode()
     * @uses CustomerReponseCustomerPaymentCardDetails::setStreetName()
     * @uses CustomerReponseCustomerPaymentCardDetails::setHouseID()
     * @uses CustomerReponseCustomerPaymentCardDetails::setPostalCode()
     * @uses CustomerReponseCustomerPaymentCardDetails::setCityName()
     * @uses CustomerReponseCustomerPaymentCardDetails::setRegionCode()
     * @uses CustomerReponseCustomerPaymentCardDetails::setCountryCode()
     * @param string $iD
     * @param \StructType\PaymentCardTypeCode $paymentCardTypeCode
     * @param \StructType\PaymentCardID $paymentCardID
     * @param string $paymentCardHolderName
     * @param string $paymentCardExpirationDate
     * @param bool $defaultIndicator
     * @param \StructType\PaymentCardBlockingReasonCode $blockingReasonCode
     * @param string $streetName
     * @param string $houseID
     * @param string $postalCode
     * @param string $cityName
     * @param \StructType\RegionCode $regionCode
     * @param string $countryCode
     */
    public function __construct($iD = null, \StructType\PaymentCardTypeCode $paymentCardTypeCode = null, \StructType\PaymentCardID $paymentCardID = null, $paymentCardHolderName = null, $paymentCardExpirationDate = null, $defaultIndicator = null, \StructType\PaymentCardBlockingReasonCode $blockingReasonCode = null, $streetName = null, $houseID = null, $postalCode = null, $cityName = null, \StructType\RegionCode $regionCode = null, $countryCode = null)
    {
        $this
            ->setID($iD)
            ->setPaymentCardTypeCode($paymentCardTypeCode)
            ->setPaymentCardID($paymentCardID)
            ->setPaymentCardHolderName($paymentCardHolderName)
            ->setPaymentCardExpirationDate($paymentCardExpirationDate)
            ->setDefaultIndicator($defaultIndicator)
            ->setBlockingReasonCode($blockingReasonCode)
            ->setStreetName($streetName)
            ->setHouseID($houseID)
            ->setPostalCode($postalCode)
            ->setCityName($cityName)
            ->setRegionCode($regionCode)
            ->setCountryCode($countryCode);
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        // validation for constraint: maxLength(6)
        if (!is_null($iD) && mb_strlen($iD) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 6', mb_strlen($iD)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($iD) && mb_strlen($iD) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get PaymentCardTypeCode value
     * @return \StructType\PaymentCardTypeCode|null
     */
    public function getPaymentCardTypeCode()
    {
        return $this->PaymentCardTypeCode;
    }
    /**
     * Set PaymentCardTypeCode value
     * @param \StructType\PaymentCardTypeCode $paymentCardTypeCode
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setPaymentCardTypeCode(\StructType\PaymentCardTypeCode $paymentCardTypeCode = null)
    {
        $this->PaymentCardTypeCode = $paymentCardTypeCode;
        return $this;
    }
    /**
     * Get PaymentCardID value
     * @return \StructType\PaymentCardID|null
     */
    public function getPaymentCardID()
    {
        return $this->PaymentCardID;
    }
    /**
     * Set PaymentCardID value
     * @param \StructType\PaymentCardID $paymentCardID
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setPaymentCardID(\StructType\PaymentCardID $paymentCardID = null)
    {
        $this->PaymentCardID = $paymentCardID;
        return $this;
    }
    /**
     * Get PaymentCardHolderName value
     * @return string|null
     */
    public function getPaymentCardHolderName()
    {
        return $this->PaymentCardHolderName;
    }
    /**
     * Set PaymentCardHolderName value
     * @param string $paymentCardHolderName
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setPaymentCardHolderName($paymentCardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCardHolderName) && !is_string($paymentCardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCardHolderName, true), gettype($paymentCardHolderName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($paymentCardHolderName) && mb_strlen($paymentCardHolderName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($paymentCardHolderName)), __LINE__);
        }
        $this->PaymentCardHolderName = $paymentCardHolderName;
        return $this;
    }
    /**
     * Get PaymentCardExpirationDate value
     * @return string|null
     */
    public function getPaymentCardExpirationDate()
    {
        return $this->PaymentCardExpirationDate;
    }
    /**
     * Set PaymentCardExpirationDate value
     * @param string $paymentCardExpirationDate
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setPaymentCardExpirationDate($paymentCardExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCardExpirationDate) && !is_string($paymentCardExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCardExpirationDate, true), gettype($paymentCardExpirationDate)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($paymentCardExpirationDate) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $paymentCardExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($paymentCardExpirationDate, true)), __LINE__);
        }
        $this->PaymentCardExpirationDate = $paymentCardExpirationDate;
        return $this;
    }
    /**
     * Get DefaultIndicator value
     * @return bool|null
     */
    public function getDefaultIndicator()
    {
        return $this->DefaultIndicator;
    }
    /**
     * Set DefaultIndicator value
     * @param bool $defaultIndicator
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setDefaultIndicator($defaultIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultIndicator) && !is_bool($defaultIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultIndicator, true), gettype($defaultIndicator)), __LINE__);
        }
        $this->DefaultIndicator = $defaultIndicator;
        return $this;
    }
    /**
     * Get BlockingReasonCode value
     * @return \StructType\PaymentCardBlockingReasonCode|null
     */
    public function getBlockingReasonCode()
    {
        return $this->BlockingReasonCode;
    }
    /**
     * Set BlockingReasonCode value
     * @param \StructType\PaymentCardBlockingReasonCode $blockingReasonCode
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setBlockingReasonCode(\StructType\PaymentCardBlockingReasonCode $blockingReasonCode = null)
    {
        $this->BlockingReasonCode = $blockingReasonCode;
        return $this;
    }
    /**
     * Get StreetName value
     * @return string|null
     */
    public function getStreetName()
    {
        return $this->StreetName;
    }
    /**
     * Set StreetName value
     * @param string $streetName
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($streetName) && mb_strlen($streetName) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($streetName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($streetName) && mb_strlen($streetName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($streetName)), __LINE__);
        }
        $this->StreetName = $streetName;
        return $this;
    }
    /**
     * Get HouseID value
     * @return string|null
     */
    public function getHouseID()
    {
        return $this->HouseID;
    }
    /**
     * Set HouseID value
     * @param string $houseID
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setHouseID($houseID = null)
    {
        // validation for constraint: string
        if (!is_null($houseID) && !is_string($houseID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($houseID, true), gettype($houseID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($houseID) && mb_strlen($houseID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($houseID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($houseID) && mb_strlen($houseID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($houseID)), __LINE__);
        }
        $this->HouseID = $houseID;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalCode, true), gettype($postalCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($postalCode) && mb_strlen($postalCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($postalCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($postalCode) && mb_strlen($postalCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get CityName value
     * @return string|null
     */
    public function getCityName()
    {
        return $this->CityName;
    }
    /**
     * Set CityName value
     * @param string $cityName
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($cityName) && mb_strlen($cityName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($cityName)), __LINE__);
        }
        $this->CityName = $cityName;
        return $this;
    }
    /**
     * Get RegionCode value
     * @return \StructType\RegionCode|null
     */
    public function getRegionCode()
    {
        return $this->RegionCode;
    }
    /**
     * Set RegionCode value
     * @param \StructType\RegionCode $regionCode
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setRegionCode(\StructType\RegionCode $regionCode = null)
    {
        $this->RegionCode = $regionCode;
        return $this;
    }
    /**
     * Get CountryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->CountryCode;
    }
    /**
     * Set CountryCode value
     * @param string $countryCode
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryCode, true), gettype($countryCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($countryCode) && mb_strlen($countryCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($countryCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($countryCode) && mb_strlen($countryCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($countryCode)), __LINE__);
        }
        $this->CountryCode = $countryCode;
        return $this;
    }
}
