<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerContactPersonAddress StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerContactPersonAddress extends AbstractStructBase
{
    /**
     * The EmailURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailURI
     */
    public $EmailURI;
    /**
     * The FacsimileFormattedNumberDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FacsimileFormattedNumberDescription;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public $PostalAddress;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerContactPersonTelephone[]
     */
    public $Telephone;
    /**
     * The FormattedAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerFormattedAddress
     */
    public $FormattedAddress;
    /**
     * Constructor method for CustomerReponseCustomerContactPersonAddress
     * @uses CustomerReponseCustomerContactPersonAddress::setEmailURI()
     * @uses CustomerReponseCustomerContactPersonAddress::setFacsimileFormattedNumberDescription()
     * @uses CustomerReponseCustomerContactPersonAddress::setPostalAddress()
     * @uses CustomerReponseCustomerContactPersonAddress::setTelephone()
     * @uses CustomerReponseCustomerContactPersonAddress::setFormattedAddress()
     * @param \StructType\EmailURI $emailURI
     * @param string $facsimileFormattedNumberDescription
     * @param \StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress
     * @param \StructType\CustomerReponseCustomerContactPersonTelephone[] $telephone
     * @param \StructType\CustomerReponseCustomerFormattedAddress $formattedAddress
     */
    public function __construct(\StructType\EmailURI $emailURI = null, $facsimileFormattedNumberDescription = null, \StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress = null, array $telephone = array(), \StructType\CustomerReponseCustomerFormattedAddress $formattedAddress = null)
    {
        $this
            ->setEmailURI($emailURI)
            ->setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription)
            ->setPostalAddress($postalAddress)
            ->setTelephone($telephone)
            ->setFormattedAddress($formattedAddress);
    }
    /**
     * Get EmailURI value
     * @return \StructType\EmailURI|null
     */
    public function getEmailURI()
    {
        return $this->EmailURI;
    }
    /**
     * Set EmailURI value
     * @param \StructType\EmailURI $emailURI
     * @return \StructType\CustomerReponseCustomerContactPersonAddress
     */
    public function setEmailURI(\StructType\EmailURI $emailURI = null)
    {
        $this->EmailURI = $emailURI;
        return $this;
    }
    /**
     * Get FacsimileFormattedNumberDescription value
     * @return string|null
     */
    public function getFacsimileFormattedNumberDescription()
    {
        return $this->FacsimileFormattedNumberDescription;
    }
    /**
     * Set FacsimileFormattedNumberDescription value
     * @param string $facsimileFormattedNumberDescription
     * @return \StructType\CustomerReponseCustomerContactPersonAddress
     */
    public function setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($facsimileFormattedNumberDescription) && !is_string($facsimileFormattedNumberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facsimileFormattedNumberDescription, true), gettype($facsimileFormattedNumberDescription)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($facsimileFormattedNumberDescription) && mb_strlen($facsimileFormattedNumberDescription) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($facsimileFormattedNumberDescription)), __LINE__);
        }
        $this->FacsimileFormattedNumberDescription = $facsimileFormattedNumberDescription;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress
     * @return \StructType\CustomerReponseCustomerContactPersonAddress
     */
    public function setPostalAddress(\StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\CustomerReponseCustomerContactPersonTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerContactPersonAddressTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerContactPersonAddressTelephoneItem instanceof \StructType\CustomerReponseCustomerContactPersonTelephone) {
                $invalidValues[] = is_object($customerReponseCustomerContactPersonAddressTelephoneItem) ? get_class($customerReponseCustomerContactPersonAddressTelephoneItem) : sprintf('%s(%s)', gettype($customerReponseCustomerContactPersonAddressTelephoneItem), var_export($customerReponseCustomerContactPersonAddressTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\CustomerReponseCustomerContactPersonTelephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerContactPersonTelephone[] $telephone
     * @return \StructType\CustomerReponseCustomerContactPersonAddress
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerContactPersonTelephone $item
     * @return \StructType\CustomerReponseCustomerContactPersonAddress
     */
    public function addToTelephone(\StructType\CustomerReponseCustomerContactPersonTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerContactPersonTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\CustomerReponseCustomerContactPersonTelephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get FormattedAddress value
     * @return \StructType\CustomerReponseCustomerFormattedAddress|null
     */
    public function getFormattedAddress()
    {
        return $this->FormattedAddress;
    }
    /**
     * Set FormattedAddress value
     * @param \StructType\CustomerReponseCustomerFormattedAddress $formattedAddress
     * @return \StructType\CustomerReponseCustomerContactPersonAddress
     */
    public function setFormattedAddress(\StructType\CustomerReponseCustomerFormattedAddress $formattedAddress = null)
    {
        $this->FormattedAddress = $formattedAddress;
        return $this;
    }
}
