<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerContactPerson StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerContactPerson extends AbstractStructBase
{
    /**
     * The BusinessPartnerContactUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $BusinessPartnerContactUUID;
    /**
     * The BusinessPartnerContactInternalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $BusinessPartnerContactInternalID;
    /**
     * The NationalProviderID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NationalProviderID;
    /**
     * The DefaultContactPersonIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $DefaultContactPersonIndicator;
    /**
     * The FormOfAddressCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FormOfAddressCode
     */
    public $FormOfAddressCode;
    /**
     * The AcademicTitleCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AcademicTitleCode
     */
    public $AcademicTitleCode;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $GivenName;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $MiddleName;
    /**
     * The FamilyName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FamilyName;
    /**
     * The BirthName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $BirthName;
    /**
     * The NickName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $NickName;
    /**
     * The GenderCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $GenderCode;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Date
     * - base: xsd:date
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}
     * @var string
     */
    public $BirthDate;
    /**
     * The NonVerbalCommunicationLanguageCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:language
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $NonVerbalCommunicationLanguageCode;
    /**
     * The OccupationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OccupationCode
     */
    public $OccupationCode;
    /**
     * The BusinessPartnerFunctionTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessPartnerFunctionTypeCode
     */
    public $BusinessPartnerFunctionTypeCode;
    /**
     * The BusinessPartnerFunctionalAreaCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BusinessPartnerFunctionalAreaCode
     */
    public $BusinessPartnerFunctionalAreaCode;
    /**
     * The VIPReasonCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\VIPReasonCode
     */
    public $VIPReasonCode;
    /**
     * The CurrentWorkplaceAddressSnapshotUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $CurrentWorkplaceAddressSnapshotUUID;
    /**
     * The WorkplaceBusinessAddressUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $WorkplaceBusinessAddressUUID;
    /**
     * The WorkplacePreferredCommunicationMediumTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommunicationMediumTypeCode
     */
    public $WorkplacePreferredCommunicationMediumTypeCode;
    /**
     * The WorkplaceEmailURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailURI
     */
    public $WorkplaceEmailURI;
    /**
     * The WorkplaceFacsimileFormattedNumberDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceFacsimileFormattedNumberDescription;
    /**
     * The WorkplaceTelephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerWorkplaceTelephone[]
     */
    public $WorkplaceTelephone;
    /**
     * The WorkplaceWebURI
     * Meta information extracted from the WSDL
     * - documentation: URI
     * - base: xsd:anyURI
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceWebURI;
    /**
     * The WorkplaceFunctionalTitleName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceFunctionalTitleName;
    /**
     * The WorkplaceDepartmentName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceDepartmentName;
    /**
     * The WorkplaceBuildingID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceBuildingID;
    /**
     * The WorkplaceFloorID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceFloorID;
    /**
     * The WorkplaceRoomID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $WorkplaceRoomID;
    /**
     * The WorkplaceFormattedAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerFormattedAddress
     */
    public $WorkplaceFormattedAddress;
    /**
     * The AddressInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerContactPersonAddressInformation[]
     */
    public $AddressInformation;
    /**
     * The LifeCycleStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LifeCycleStatusCode;
    /**
     * The MaritalStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\MaritalStatusCode
     */
    public $MaritalStatusCode;
    /**
     * The ResponsibleEmployee
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseContactPersonResponsibleEmployee[]
     */
    public $ResponsibleEmployee;
    /**
     * The BusinessPurposeCompletedIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $BusinessPurposeCompletedIndicator;
    /**
     * Constructor method for CustomerReponseCustomerContactPerson
     * @uses CustomerReponseCustomerContactPerson::setBusinessPartnerContactUUID()
     * @uses CustomerReponseCustomerContactPerson::setBusinessPartnerContactInternalID()
     * @uses CustomerReponseCustomerContactPerson::setNationalProviderID()
     * @uses CustomerReponseCustomerContactPerson::setDefaultContactPersonIndicator()
     * @uses CustomerReponseCustomerContactPerson::setFormOfAddressCode()
     * @uses CustomerReponseCustomerContactPerson::setAcademicTitleCode()
     * @uses CustomerReponseCustomerContactPerson::setGivenName()
     * @uses CustomerReponseCustomerContactPerson::setMiddleName()
     * @uses CustomerReponseCustomerContactPerson::setFamilyName()
     * @uses CustomerReponseCustomerContactPerson::setBirthName()
     * @uses CustomerReponseCustomerContactPerson::setNickName()
     * @uses CustomerReponseCustomerContactPerson::setGenderCode()
     * @uses CustomerReponseCustomerContactPerson::setBirthDate()
     * @uses CustomerReponseCustomerContactPerson::setNonVerbalCommunicationLanguageCode()
     * @uses CustomerReponseCustomerContactPerson::setOccupationCode()
     * @uses CustomerReponseCustomerContactPerson::setBusinessPartnerFunctionTypeCode()
     * @uses CustomerReponseCustomerContactPerson::setBusinessPartnerFunctionalAreaCode()
     * @uses CustomerReponseCustomerContactPerson::setVIPReasonCode()
     * @uses CustomerReponseCustomerContactPerson::setCurrentWorkplaceAddressSnapshotUUID()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceBusinessAddressUUID()
     * @uses CustomerReponseCustomerContactPerson::setWorkplacePreferredCommunicationMediumTypeCode()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceEmailURI()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceFacsimileFormattedNumberDescription()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceTelephone()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceWebURI()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceFunctionalTitleName()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceDepartmentName()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceBuildingID()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceFloorID()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceRoomID()
     * @uses CustomerReponseCustomerContactPerson::setWorkplaceFormattedAddress()
     * @uses CustomerReponseCustomerContactPerson::setAddressInformation()
     * @uses CustomerReponseCustomerContactPerson::setLifeCycleStatusCode()
     * @uses CustomerReponseCustomerContactPerson::setMaritalStatusCode()
     * @uses CustomerReponseCustomerContactPerson::setResponsibleEmployee()
     * @uses CustomerReponseCustomerContactPerson::setBusinessPurposeCompletedIndicator()
     * @param \StructType\UUID $businessPartnerContactUUID
     * @param string $businessPartnerContactInternalID
     * @param string $nationalProviderID
     * @param bool $defaultContactPersonIndicator
     * @param \StructType\FormOfAddressCode $formOfAddressCode
     * @param \StructType\AcademicTitleCode $academicTitleCode
     * @param string $givenName
     * @param string $middleName
     * @param string $familyName
     * @param string $birthName
     * @param string $nickName
     * @param string $genderCode
     * @param string $birthDate
     * @param string $nonVerbalCommunicationLanguageCode
     * @param \StructType\OccupationCode $occupationCode
     * @param \StructType\BusinessPartnerFunctionTypeCode $businessPartnerFunctionTypeCode
     * @param \StructType\BusinessPartnerFunctionalAreaCode $businessPartnerFunctionalAreaCode
     * @param \StructType\VIPReasonCode $vIPReasonCode
     * @param \StructType\UUID $currentWorkplaceAddressSnapshotUUID
     * @param \StructType\UUID $workplaceBusinessAddressUUID
     * @param \StructType\CommunicationMediumTypeCode $workplacePreferredCommunicationMediumTypeCode
     * @param \StructType\EmailURI $workplaceEmailURI
     * @param string $workplaceFacsimileFormattedNumberDescription
     * @param \StructType\CustomerReponseCustomerWorkplaceTelephone[] $workplaceTelephone
     * @param string $workplaceWebURI
     * @param string $workplaceFunctionalTitleName
     * @param string $workplaceDepartmentName
     * @param string $workplaceBuildingID
     * @param string $workplaceFloorID
     * @param string $workplaceRoomID
     * @param \StructType\CustomerReponseCustomerFormattedAddress $workplaceFormattedAddress
     * @param \StructType\CustomerReponseCustomerContactPersonAddressInformation[] $addressInformation
     * @param string $lifeCycleStatusCode
     * @param \StructType\MaritalStatusCode $maritalStatusCode
     * @param \StructType\CustomerReponseContactPersonResponsibleEmployee[] $responsibleEmployee
     * @param bool $businessPurposeCompletedIndicator
     */
    public function __construct(\StructType\UUID $businessPartnerContactUUID = null, $businessPartnerContactInternalID = null, $nationalProviderID = null, $defaultContactPersonIndicator = null, \StructType\FormOfAddressCode $formOfAddressCode = null, \StructType\AcademicTitleCode $academicTitleCode = null, $givenName = null, $middleName = null, $familyName = null, $birthName = null, $nickName = null, $genderCode = null, $birthDate = null, $nonVerbalCommunicationLanguageCode = null, \StructType\OccupationCode $occupationCode = null, \StructType\BusinessPartnerFunctionTypeCode $businessPartnerFunctionTypeCode = null, \StructType\BusinessPartnerFunctionalAreaCode $businessPartnerFunctionalAreaCode = null, \StructType\VIPReasonCode $vIPReasonCode = null, \StructType\UUID $currentWorkplaceAddressSnapshotUUID = null, \StructType\UUID $workplaceBusinessAddressUUID = null, \StructType\CommunicationMediumTypeCode $workplacePreferredCommunicationMediumTypeCode = null, \StructType\EmailURI $workplaceEmailURI = null, $workplaceFacsimileFormattedNumberDescription = null, array $workplaceTelephone = array(), $workplaceWebURI = null, $workplaceFunctionalTitleName = null, $workplaceDepartmentName = null, $workplaceBuildingID = null, $workplaceFloorID = null, $workplaceRoomID = null, \StructType\CustomerReponseCustomerFormattedAddress $workplaceFormattedAddress = null, array $addressInformation = array(), $lifeCycleStatusCode = null, \StructType\MaritalStatusCode $maritalStatusCode = null, array $responsibleEmployee = array(), $businessPurposeCompletedIndicator = null)
    {
        $this
            ->setBusinessPartnerContactUUID($businessPartnerContactUUID)
            ->setBusinessPartnerContactInternalID($businessPartnerContactInternalID)
            ->setNationalProviderID($nationalProviderID)
            ->setDefaultContactPersonIndicator($defaultContactPersonIndicator)
            ->setFormOfAddressCode($formOfAddressCode)
            ->setAcademicTitleCode($academicTitleCode)
            ->setGivenName($givenName)
            ->setMiddleName($middleName)
            ->setFamilyName($familyName)
            ->setBirthName($birthName)
            ->setNickName($nickName)
            ->setGenderCode($genderCode)
            ->setBirthDate($birthDate)
            ->setNonVerbalCommunicationLanguageCode($nonVerbalCommunicationLanguageCode)
            ->setOccupationCode($occupationCode)
            ->setBusinessPartnerFunctionTypeCode($businessPartnerFunctionTypeCode)
            ->setBusinessPartnerFunctionalAreaCode($businessPartnerFunctionalAreaCode)
            ->setVIPReasonCode($vIPReasonCode)
            ->setCurrentWorkplaceAddressSnapshotUUID($currentWorkplaceAddressSnapshotUUID)
            ->setWorkplaceBusinessAddressUUID($workplaceBusinessAddressUUID)
            ->setWorkplacePreferredCommunicationMediumTypeCode($workplacePreferredCommunicationMediumTypeCode)
            ->setWorkplaceEmailURI($workplaceEmailURI)
            ->setWorkplaceFacsimileFormattedNumberDescription($workplaceFacsimileFormattedNumberDescription)
            ->setWorkplaceTelephone($workplaceTelephone)
            ->setWorkplaceWebURI($workplaceWebURI)
            ->setWorkplaceFunctionalTitleName($workplaceFunctionalTitleName)
            ->setWorkplaceDepartmentName($workplaceDepartmentName)
            ->setWorkplaceBuildingID($workplaceBuildingID)
            ->setWorkplaceFloorID($workplaceFloorID)
            ->setWorkplaceRoomID($workplaceRoomID)
            ->setWorkplaceFormattedAddress($workplaceFormattedAddress)
            ->setAddressInformation($addressInformation)
            ->setLifeCycleStatusCode($lifeCycleStatusCode)
            ->setMaritalStatusCode($maritalStatusCode)
            ->setResponsibleEmployee($responsibleEmployee)
            ->setBusinessPurposeCompletedIndicator($businessPurposeCompletedIndicator);
    }
    /**
     * Get BusinessPartnerContactUUID value
     * @return \StructType\UUID|null
     */
    public function getBusinessPartnerContactUUID()
    {
        return $this->BusinessPartnerContactUUID;
    }
    /**
     * Set BusinessPartnerContactUUID value
     * @param \StructType\UUID $businessPartnerContactUUID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBusinessPartnerContactUUID(\StructType\UUID $businessPartnerContactUUID = null)
    {
        $this->BusinessPartnerContactUUID = $businessPartnerContactUUID;
        return $this;
    }
    /**
     * Get BusinessPartnerContactInternalID value
     * @return string|null
     */
    public function getBusinessPartnerContactInternalID()
    {
        return $this->BusinessPartnerContactInternalID;
    }
    /**
     * Set BusinessPartnerContactInternalID value
     * @param string $businessPartnerContactInternalID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBusinessPartnerContactInternalID($businessPartnerContactInternalID = null)
    {
        // validation for constraint: string
        if (!is_null($businessPartnerContactInternalID) && !is_string($businessPartnerContactInternalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPartnerContactInternalID, true), gettype($businessPartnerContactInternalID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($businessPartnerContactInternalID) && mb_strlen($businessPartnerContactInternalID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($businessPartnerContactInternalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($businessPartnerContactInternalID) && mb_strlen($businessPartnerContactInternalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($businessPartnerContactInternalID)), __LINE__);
        }
        $this->BusinessPartnerContactInternalID = $businessPartnerContactInternalID;
        return $this;
    }
    /**
     * Get NationalProviderID value
     * @return string|null
     */
    public function getNationalProviderID()
    {
        return $this->NationalProviderID;
    }
    /**
     * Set NationalProviderID value
     * @param string $nationalProviderID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setNationalProviderID($nationalProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($nationalProviderID) && !is_string($nationalProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalProviderID, true), gettype($nationalProviderID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($nationalProviderID) && mb_strlen($nationalProviderID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($nationalProviderID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nationalProviderID) && mb_strlen($nationalProviderID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nationalProviderID)), __LINE__);
        }
        $this->NationalProviderID = $nationalProviderID;
        return $this;
    }
    /**
     * Get DefaultContactPersonIndicator value
     * @return bool|null
     */
    public function getDefaultContactPersonIndicator()
    {
        return $this->DefaultContactPersonIndicator;
    }
    /**
     * Set DefaultContactPersonIndicator value
     * @param bool $defaultContactPersonIndicator
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setDefaultContactPersonIndicator($defaultContactPersonIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($defaultContactPersonIndicator) && !is_bool($defaultContactPersonIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($defaultContactPersonIndicator, true), gettype($defaultContactPersonIndicator)), __LINE__);
        }
        $this->DefaultContactPersonIndicator = $defaultContactPersonIndicator;
        return $this;
    }
    /**
     * Get FormOfAddressCode value
     * @return \StructType\FormOfAddressCode|null
     */
    public function getFormOfAddressCode()
    {
        return $this->FormOfAddressCode;
    }
    /**
     * Set FormOfAddressCode value
     * @param \StructType\FormOfAddressCode $formOfAddressCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setFormOfAddressCode(\StructType\FormOfAddressCode $formOfAddressCode = null)
    {
        $this->FormOfAddressCode = $formOfAddressCode;
        return $this;
    }
    /**
     * Get AcademicTitleCode value
     * @return \StructType\AcademicTitleCode|null
     */
    public function getAcademicTitleCode()
    {
        return $this->AcademicTitleCode;
    }
    /**
     * Set AcademicTitleCode value
     * @param \StructType\AcademicTitleCode $academicTitleCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setAcademicTitleCode(\StructType\AcademicTitleCode $academicTitleCode = null)
    {
        $this->AcademicTitleCode = $academicTitleCode;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * Set GivenName value
     * @param string $givenName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setGivenName($givenName = null)
    {
        // validation for constraint: string
        if (!is_null($givenName) && !is_string($givenName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($givenName, true), gettype($givenName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($givenName) && mb_strlen($givenName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($givenName)), __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * Set MiddleName value
     * @param string $middleName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($middleName) && mb_strlen($middleName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($middleName)), __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Get FamilyName value
     * @return string|null
     */
    public function getFamilyName()
    {
        return $this->FamilyName;
    }
    /**
     * Set FamilyName value
     * @param string $familyName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setFamilyName($familyName = null)
    {
        // validation for constraint: string
        if (!is_null($familyName) && !is_string($familyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familyName, true), gettype($familyName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($familyName) && mb_strlen($familyName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($familyName)), __LINE__);
        }
        $this->FamilyName = $familyName;
        return $this;
    }
    /**
     * Get BirthName value
     * @return string|null
     */
    public function getBirthName()
    {
        return $this->BirthName;
    }
    /**
     * Set BirthName value
     * @param string $birthName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBirthName($birthName = null)
    {
        // validation for constraint: string
        if (!is_null($birthName) && !is_string($birthName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthName, true), gettype($birthName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($birthName) && mb_strlen($birthName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($birthName)), __LINE__);
        }
        $this->BirthName = $birthName;
        return $this;
    }
    /**
     * Get NickName value
     * @return string|null
     */
    public function getNickName()
    {
        return $this->NickName;
    }
    /**
     * Set NickName value
     * @param string $nickName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setNickName($nickName = null)
    {
        // validation for constraint: string
        if (!is_null($nickName) && !is_string($nickName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nickName, true), gettype($nickName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($nickName) && mb_strlen($nickName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($nickName)), __LINE__);
        }
        $this->NickName = $nickName;
        return $this;
    }
    /**
     * Get GenderCode value
     * @return string|null
     */
    public function getGenderCode()
    {
        return $this->GenderCode;
    }
    /**
     * Set GenderCode value
     * @param string $genderCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setGenderCode($genderCode = null)
    {
        // validation for constraint: string
        if (!is_null($genderCode) && !is_string($genderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genderCode, true), gettype($genderCode)), __LINE__);
        }
        // validation for constraint: maxLength(1)
        if (!is_null($genderCode) && mb_strlen($genderCode) > 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 1', mb_strlen($genderCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($genderCode) && mb_strlen($genderCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($genderCode)), __LINE__);
        }
        $this->GenderCode = $genderCode;
        return $this;
    }
    /**
     * Get BirthDate value
     * @return string|null
     */
    public function getBirthDate()
    {
        return $this->BirthDate;
    }
    /**
     * Set BirthDate value
     * @param string $birthDate
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2})
        if (!is_null($birthDate) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}/', $birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}', var_export($birthDate, true)), __LINE__);
        }
        $this->BirthDate = $birthDate;
        return $this;
    }
    /**
     * Get NonVerbalCommunicationLanguageCode value
     * @return string|null
     */
    public function getNonVerbalCommunicationLanguageCode()
    {
        return $this->NonVerbalCommunicationLanguageCode;
    }
    /**
     * Set NonVerbalCommunicationLanguageCode value
     * @param string $nonVerbalCommunicationLanguageCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setNonVerbalCommunicationLanguageCode($nonVerbalCommunicationLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($nonVerbalCommunicationLanguageCode) && !is_string($nonVerbalCommunicationLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nonVerbalCommunicationLanguageCode, true), gettype($nonVerbalCommunicationLanguageCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($nonVerbalCommunicationLanguageCode) && mb_strlen($nonVerbalCommunicationLanguageCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($nonVerbalCommunicationLanguageCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($nonVerbalCommunicationLanguageCode) && mb_strlen($nonVerbalCommunicationLanguageCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($nonVerbalCommunicationLanguageCode)), __LINE__);
        }
        $this->NonVerbalCommunicationLanguageCode = $nonVerbalCommunicationLanguageCode;
        return $this;
    }
    /**
     * Get OccupationCode value
     * @return \StructType\OccupationCode|null
     */
    public function getOccupationCode()
    {
        return $this->OccupationCode;
    }
    /**
     * Set OccupationCode value
     * @param \StructType\OccupationCode $occupationCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setOccupationCode(\StructType\OccupationCode $occupationCode = null)
    {
        $this->OccupationCode = $occupationCode;
        return $this;
    }
    /**
     * Get BusinessPartnerFunctionTypeCode value
     * @return \StructType\BusinessPartnerFunctionTypeCode|null
     */
    public function getBusinessPartnerFunctionTypeCode()
    {
        return $this->BusinessPartnerFunctionTypeCode;
    }
    /**
     * Set BusinessPartnerFunctionTypeCode value
     * @param \StructType\BusinessPartnerFunctionTypeCode $businessPartnerFunctionTypeCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBusinessPartnerFunctionTypeCode(\StructType\BusinessPartnerFunctionTypeCode $businessPartnerFunctionTypeCode = null)
    {
        $this->BusinessPartnerFunctionTypeCode = $businessPartnerFunctionTypeCode;
        return $this;
    }
    /**
     * Get BusinessPartnerFunctionalAreaCode value
     * @return \StructType\BusinessPartnerFunctionalAreaCode|null
     */
    public function getBusinessPartnerFunctionalAreaCode()
    {
        return $this->BusinessPartnerFunctionalAreaCode;
    }
    /**
     * Set BusinessPartnerFunctionalAreaCode value
     * @param \StructType\BusinessPartnerFunctionalAreaCode $businessPartnerFunctionalAreaCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBusinessPartnerFunctionalAreaCode(\StructType\BusinessPartnerFunctionalAreaCode $businessPartnerFunctionalAreaCode = null)
    {
        $this->BusinessPartnerFunctionalAreaCode = $businessPartnerFunctionalAreaCode;
        return $this;
    }
    /**
     * Get VIPReasonCode value
     * @return \StructType\VIPReasonCode|null
     */
    public function getVIPReasonCode()
    {
        return $this->VIPReasonCode;
    }
    /**
     * Set VIPReasonCode value
     * @param \StructType\VIPReasonCode $vIPReasonCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setVIPReasonCode(\StructType\VIPReasonCode $vIPReasonCode = null)
    {
        $this->VIPReasonCode = $vIPReasonCode;
        return $this;
    }
    /**
     * Get CurrentWorkplaceAddressSnapshotUUID value
     * @return \StructType\UUID|null
     */
    public function getCurrentWorkplaceAddressSnapshotUUID()
    {
        return $this->CurrentWorkplaceAddressSnapshotUUID;
    }
    /**
     * Set CurrentWorkplaceAddressSnapshotUUID value
     * @param \StructType\UUID $currentWorkplaceAddressSnapshotUUID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setCurrentWorkplaceAddressSnapshotUUID(\StructType\UUID $currentWorkplaceAddressSnapshotUUID = null)
    {
        $this->CurrentWorkplaceAddressSnapshotUUID = $currentWorkplaceAddressSnapshotUUID;
        return $this;
    }
    /**
     * Get WorkplaceBusinessAddressUUID value
     * @return \StructType\UUID|null
     */
    public function getWorkplaceBusinessAddressUUID()
    {
        return $this->WorkplaceBusinessAddressUUID;
    }
    /**
     * Set WorkplaceBusinessAddressUUID value
     * @param \StructType\UUID $workplaceBusinessAddressUUID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceBusinessAddressUUID(\StructType\UUID $workplaceBusinessAddressUUID = null)
    {
        $this->WorkplaceBusinessAddressUUID = $workplaceBusinessAddressUUID;
        return $this;
    }
    /**
     * Get WorkplacePreferredCommunicationMediumTypeCode value
     * @return \StructType\CommunicationMediumTypeCode|null
     */
    public function getWorkplacePreferredCommunicationMediumTypeCode()
    {
        return $this->WorkplacePreferredCommunicationMediumTypeCode;
    }
    /**
     * Set WorkplacePreferredCommunicationMediumTypeCode value
     * @param \StructType\CommunicationMediumTypeCode $workplacePreferredCommunicationMediumTypeCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplacePreferredCommunicationMediumTypeCode(\StructType\CommunicationMediumTypeCode $workplacePreferredCommunicationMediumTypeCode = null)
    {
        $this->WorkplacePreferredCommunicationMediumTypeCode = $workplacePreferredCommunicationMediumTypeCode;
        return $this;
    }
    /**
     * Get WorkplaceEmailURI value
     * @return \StructType\EmailURI|null
     */
    public function getWorkplaceEmailURI()
    {
        return $this->WorkplaceEmailURI;
    }
    /**
     * Set WorkplaceEmailURI value
     * @param \StructType\EmailURI $workplaceEmailURI
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceEmailURI(\StructType\EmailURI $workplaceEmailURI = null)
    {
        $this->WorkplaceEmailURI = $workplaceEmailURI;
        return $this;
    }
    /**
     * Get WorkplaceFacsimileFormattedNumberDescription value
     * @return string|null
     */
    public function getWorkplaceFacsimileFormattedNumberDescription()
    {
        return $this->WorkplaceFacsimileFormattedNumberDescription;
    }
    /**
     * Set WorkplaceFacsimileFormattedNumberDescription value
     * @param string $workplaceFacsimileFormattedNumberDescription
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceFacsimileFormattedNumberDescription($workplaceFacsimileFormattedNumberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceFacsimileFormattedNumberDescription) && !is_string($workplaceFacsimileFormattedNumberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceFacsimileFormattedNumberDescription, true), gettype($workplaceFacsimileFormattedNumberDescription)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($workplaceFacsimileFormattedNumberDescription) && mb_strlen($workplaceFacsimileFormattedNumberDescription) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($workplaceFacsimileFormattedNumberDescription)), __LINE__);
        }
        $this->WorkplaceFacsimileFormattedNumberDescription = $workplaceFacsimileFormattedNumberDescription;
        return $this;
    }
    /**
     * Get WorkplaceTelephone value
     * @return \StructType\CustomerReponseCustomerWorkplaceTelephone[]|null
     */
    public function getWorkplaceTelephone()
    {
        return $this->WorkplaceTelephone;
    }
    /**
     * This method is responsible for validating the values passed to the setWorkplaceTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWorkplaceTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWorkplaceTelephoneForArrayConstraintsFromSetWorkplaceTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerContactPersonWorkplaceTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerContactPersonWorkplaceTelephoneItem instanceof \StructType\CustomerReponseCustomerWorkplaceTelephone) {
                $invalidValues[] = is_object($customerReponseCustomerContactPersonWorkplaceTelephoneItem) ? get_class($customerReponseCustomerContactPersonWorkplaceTelephoneItem) : sprintf('%s(%s)', gettype($customerReponseCustomerContactPersonWorkplaceTelephoneItem), var_export($customerReponseCustomerContactPersonWorkplaceTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WorkplaceTelephone property can only contain items of type \StructType\CustomerReponseCustomerWorkplaceTelephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WorkplaceTelephone value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerWorkplaceTelephone[] $workplaceTelephone
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceTelephone(array $workplaceTelephone = array())
    {
        // validation for constraint: array
        if ('' !== ($workplaceTelephoneArrayErrorMessage = self::validateWorkplaceTelephoneForArrayConstraintsFromSetWorkplaceTelephone($workplaceTelephone))) {
            throw new \InvalidArgumentException($workplaceTelephoneArrayErrorMessage, __LINE__);
        }
        $this->WorkplaceTelephone = $workplaceTelephone;
        return $this;
    }
    /**
     * Add item to WorkplaceTelephone value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerWorkplaceTelephone $item
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function addToWorkplaceTelephone(\StructType\CustomerReponseCustomerWorkplaceTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerWorkplaceTelephone) {
            throw new \InvalidArgumentException(sprintf('The WorkplaceTelephone property can only contain items of type \StructType\CustomerReponseCustomerWorkplaceTelephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WorkplaceTelephone[] = $item;
        return $this;
    }
    /**
     * Get WorkplaceWebURI value
     * @return string|null
     */
    public function getWorkplaceWebURI()
    {
        return $this->WorkplaceWebURI;
    }
    /**
     * Set WorkplaceWebURI value
     * @param string $workplaceWebURI
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceWebURI($workplaceWebURI = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceWebURI) && !is_string($workplaceWebURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceWebURI, true), gettype($workplaceWebURI)), __LINE__);
        }
        $this->WorkplaceWebURI = $workplaceWebURI;
        return $this;
    }
    /**
     * Get WorkplaceFunctionalTitleName value
     * @return string|null
     */
    public function getWorkplaceFunctionalTitleName()
    {
        return $this->WorkplaceFunctionalTitleName;
    }
    /**
     * Set WorkplaceFunctionalTitleName value
     * @param string $workplaceFunctionalTitleName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceFunctionalTitleName($workplaceFunctionalTitleName = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceFunctionalTitleName) && !is_string($workplaceFunctionalTitleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceFunctionalTitleName, true), gettype($workplaceFunctionalTitleName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($workplaceFunctionalTitleName) && mb_strlen($workplaceFunctionalTitleName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($workplaceFunctionalTitleName)), __LINE__);
        }
        $this->WorkplaceFunctionalTitleName = $workplaceFunctionalTitleName;
        return $this;
    }
    /**
     * Get WorkplaceDepartmentName value
     * @return string|null
     */
    public function getWorkplaceDepartmentName()
    {
        return $this->WorkplaceDepartmentName;
    }
    /**
     * Set WorkplaceDepartmentName value
     * @param string $workplaceDepartmentName
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceDepartmentName($workplaceDepartmentName = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceDepartmentName) && !is_string($workplaceDepartmentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceDepartmentName, true), gettype($workplaceDepartmentName)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($workplaceDepartmentName) && mb_strlen($workplaceDepartmentName) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($workplaceDepartmentName)), __LINE__);
        }
        $this->WorkplaceDepartmentName = $workplaceDepartmentName;
        return $this;
    }
    /**
     * Get WorkplaceBuildingID value
     * @return string|null
     */
    public function getWorkplaceBuildingID()
    {
        return $this->WorkplaceBuildingID;
    }
    /**
     * Set WorkplaceBuildingID value
     * @param string $workplaceBuildingID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceBuildingID($workplaceBuildingID = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceBuildingID) && !is_string($workplaceBuildingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceBuildingID, true), gettype($workplaceBuildingID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($workplaceBuildingID) && mb_strlen($workplaceBuildingID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($workplaceBuildingID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($workplaceBuildingID) && mb_strlen($workplaceBuildingID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($workplaceBuildingID)), __LINE__);
        }
        $this->WorkplaceBuildingID = $workplaceBuildingID;
        return $this;
    }
    /**
     * Get WorkplaceFloorID value
     * @return string|null
     */
    public function getWorkplaceFloorID()
    {
        return $this->WorkplaceFloorID;
    }
    /**
     * Set WorkplaceFloorID value
     * @param string $workplaceFloorID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceFloorID($workplaceFloorID = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceFloorID) && !is_string($workplaceFloorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceFloorID, true), gettype($workplaceFloorID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($workplaceFloorID) && mb_strlen($workplaceFloorID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($workplaceFloorID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($workplaceFloorID) && mb_strlen($workplaceFloorID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($workplaceFloorID)), __LINE__);
        }
        $this->WorkplaceFloorID = $workplaceFloorID;
        return $this;
    }
    /**
     * Get WorkplaceRoomID value
     * @return string|null
     */
    public function getWorkplaceRoomID()
    {
        return $this->WorkplaceRoomID;
    }
    /**
     * Set WorkplaceRoomID value
     * @param string $workplaceRoomID
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceRoomID($workplaceRoomID = null)
    {
        // validation for constraint: string
        if (!is_null($workplaceRoomID) && !is_string($workplaceRoomID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workplaceRoomID, true), gettype($workplaceRoomID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($workplaceRoomID) && mb_strlen($workplaceRoomID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($workplaceRoomID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($workplaceRoomID) && mb_strlen($workplaceRoomID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($workplaceRoomID)), __LINE__);
        }
        $this->WorkplaceRoomID = $workplaceRoomID;
        return $this;
    }
    /**
     * Get WorkplaceFormattedAddress value
     * @return \StructType\CustomerReponseCustomerFormattedAddress|null
     */
    public function getWorkplaceFormattedAddress()
    {
        return $this->WorkplaceFormattedAddress;
    }
    /**
     * Set WorkplaceFormattedAddress value
     * @param \StructType\CustomerReponseCustomerFormattedAddress $workplaceFormattedAddress
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setWorkplaceFormattedAddress(\StructType\CustomerReponseCustomerFormattedAddress $workplaceFormattedAddress = null)
    {
        $this->WorkplaceFormattedAddress = $workplaceFormattedAddress;
        return $this;
    }
    /**
     * Get AddressInformation value
     * @return \StructType\CustomerReponseCustomerContactPersonAddressInformation[]|null
     */
    public function getAddressInformation()
    {
        return $this->AddressInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressInformationForArrayConstraintsFromSetAddressInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerContactPersonAddressInformationItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerContactPersonAddressInformationItem instanceof \StructType\CustomerReponseCustomerContactPersonAddressInformation) {
                $invalidValues[] = is_object($customerReponseCustomerContactPersonAddressInformationItem) ? get_class($customerReponseCustomerContactPersonAddressInformationItem) : sprintf('%s(%s)', gettype($customerReponseCustomerContactPersonAddressInformationItem), var_export($customerReponseCustomerContactPersonAddressInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressInformation property can only contain items of type \StructType\CustomerReponseCustomerContactPersonAddressInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerContactPersonAddressInformation[] $addressInformation
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setAddressInformation(array $addressInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($addressInformationArrayErrorMessage = self::validateAddressInformationForArrayConstraintsFromSetAddressInformation($addressInformation))) {
            throw new \InvalidArgumentException($addressInformationArrayErrorMessage, __LINE__);
        }
        $this->AddressInformation = $addressInformation;
        return $this;
    }
    /**
     * Add item to AddressInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerContactPersonAddressInformation $item
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function addToAddressInformation(\StructType\CustomerReponseCustomerContactPersonAddressInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerContactPersonAddressInformation) {
            throw new \InvalidArgumentException(sprintf('The AddressInformation property can only contain items of type \StructType\CustomerReponseCustomerContactPersonAddressInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressInformation[] = $item;
        return $this;
    }
    /**
     * Get LifeCycleStatusCode value
     * @return string|null
     */
    public function getLifeCycleStatusCode()
    {
        return $this->LifeCycleStatusCode;
    }
    /**
     * Set LifeCycleStatusCode value
     * @uses \EnumType\PartyLifeCycleStatusCode::valueIsValid()
     * @uses \EnumType\PartyLifeCycleStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lifeCycleStatusCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setLifeCycleStatusCode($lifeCycleStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PartyLifeCycleStatusCode::valueIsValid($lifeCycleStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PartyLifeCycleStatusCode', is_array($lifeCycleStatusCode) ? implode(', ', $lifeCycleStatusCode) : var_export($lifeCycleStatusCode, true), implode(', ', \EnumType\PartyLifeCycleStatusCode::getValidValues())), __LINE__);
        }
        $this->LifeCycleStatusCode = $lifeCycleStatusCode;
        return $this;
    }
    /**
     * Get MaritalStatusCode value
     * @return \StructType\MaritalStatusCode|null
     */
    public function getMaritalStatusCode()
    {
        return $this->MaritalStatusCode;
    }
    /**
     * Set MaritalStatusCode value
     * @param \StructType\MaritalStatusCode $maritalStatusCode
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setMaritalStatusCode(\StructType\MaritalStatusCode $maritalStatusCode = null)
    {
        $this->MaritalStatusCode = $maritalStatusCode;
        return $this;
    }
    /**
     * Get ResponsibleEmployee value
     * @return \StructType\CustomerReponseContactPersonResponsibleEmployee[]|null
     */
    public function getResponsibleEmployee()
    {
        return $this->ResponsibleEmployee;
    }
    /**
     * This method is responsible for validating the values passed to the setResponsibleEmployee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResponsibleEmployee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResponsibleEmployeeForArrayConstraintsFromSetResponsibleEmployee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerContactPersonResponsibleEmployeeItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerContactPersonResponsibleEmployeeItem instanceof \StructType\CustomerReponseContactPersonResponsibleEmployee) {
                $invalidValues[] = is_object($customerReponseCustomerContactPersonResponsibleEmployeeItem) ? get_class($customerReponseCustomerContactPersonResponsibleEmployeeItem) : sprintf('%s(%s)', gettype($customerReponseCustomerContactPersonResponsibleEmployeeItem), var_export($customerReponseCustomerContactPersonResponsibleEmployeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ResponsibleEmployee property can only contain items of type \StructType\CustomerReponseContactPersonResponsibleEmployee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ResponsibleEmployee value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseContactPersonResponsibleEmployee[] $responsibleEmployee
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setResponsibleEmployee(array $responsibleEmployee = array())
    {
        // validation for constraint: array
        if ('' !== ($responsibleEmployeeArrayErrorMessage = self::validateResponsibleEmployeeForArrayConstraintsFromSetResponsibleEmployee($responsibleEmployee))) {
            throw new \InvalidArgumentException($responsibleEmployeeArrayErrorMessage, __LINE__);
        }
        $this->ResponsibleEmployee = $responsibleEmployee;
        return $this;
    }
    /**
     * Add item to ResponsibleEmployee value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseContactPersonResponsibleEmployee $item
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function addToResponsibleEmployee(\StructType\CustomerReponseContactPersonResponsibleEmployee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseContactPersonResponsibleEmployee) {
            throw new \InvalidArgumentException(sprintf('The ResponsibleEmployee property can only contain items of type \StructType\CustomerReponseContactPersonResponsibleEmployee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ResponsibleEmployee[] = $item;
        return $this;
    }
    /**
     * Get BusinessPurposeCompletedIndicator value
     * @return bool|null
     */
    public function getBusinessPurposeCompletedIndicator()
    {
        return $this->BusinessPurposeCompletedIndicator;
    }
    /**
     * Set BusinessPurposeCompletedIndicator value
     * @param bool $businessPurposeCompletedIndicator
     * @return \StructType\CustomerReponseCustomerContactPerson
     */
    public function setBusinessPurposeCompletedIndicator($businessPurposeCompletedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($businessPurposeCompletedIndicator) && !is_bool($businessPurposeCompletedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($businessPurposeCompletedIndicator, true), gettype($businessPurposeCompletedIndicator)), __LINE__);
        }
        $this->BusinessPurposeCompletedIndicator = $businessPurposeCompletedIndicator;
        return $this;
    }
}
