<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerAddressInformation StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerAddressInformation extends AbstractStructBase
{
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The CurrentAddressSnapshotUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $CurrentAddressSnapshotUUID;
    /**
     * The AddressUsage
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerAddressUsage[]
     */
    public $AddressUsage;
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerAddress
     */
    public $Address;
    /**
     * The AddressInformationValidityPeriod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CLOSED_DatePeriod
     */
    public $AddressInformationValidityPeriod;
    /**
     * Constructor method for CustomerReponseCustomerAddressInformation
     * @uses CustomerReponseCustomerAddressInformation::setUUID()
     * @uses CustomerReponseCustomerAddressInformation::setCurrentAddressSnapshotUUID()
     * @uses CustomerReponseCustomerAddressInformation::setAddressUsage()
     * @uses CustomerReponseCustomerAddressInformation::setAddress()
     * @uses CustomerReponseCustomerAddressInformation::setAddressInformationValidityPeriod()
     * @param \StructType\UUID $uUID
     * @param \StructType\UUID $currentAddressSnapshotUUID
     * @param \StructType\CustomerReponseCustomerAddressUsage[] $addressUsage
     * @param \StructType\CustomerReponseCustomerAddress $address
     * @param \StructType\CLOSED_DatePeriod $addressInformationValidityPeriod
     */
    public function __construct(\StructType\UUID $uUID = null, \StructType\UUID $currentAddressSnapshotUUID = null, array $addressUsage = array(), \StructType\CustomerReponseCustomerAddress $address = null, \StructType\CLOSED_DatePeriod $addressInformationValidityPeriod = null)
    {
        $this
            ->setUUID($uUID)
            ->setCurrentAddressSnapshotUUID($currentAddressSnapshotUUID)
            ->setAddressUsage($addressUsage)
            ->setAddress($address)
            ->setAddressInformationValidityPeriod($addressInformationValidityPeriod);
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\CustomerReponseCustomerAddressInformation
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get CurrentAddressSnapshotUUID value
     * @return \StructType\UUID|null
     */
    public function getCurrentAddressSnapshotUUID()
    {
        return $this->CurrentAddressSnapshotUUID;
    }
    /**
     * Set CurrentAddressSnapshotUUID value
     * @param \StructType\UUID $currentAddressSnapshotUUID
     * @return \StructType\CustomerReponseCustomerAddressInformation
     */
    public function setCurrentAddressSnapshotUUID(\StructType\UUID $currentAddressSnapshotUUID = null)
    {
        $this->CurrentAddressSnapshotUUID = $currentAddressSnapshotUUID;
        return $this;
    }
    /**
     * Get AddressUsage value
     * @return \StructType\CustomerReponseCustomerAddressUsage[]|null
     */
    public function getAddressUsage()
    {
        return $this->AddressUsage;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressUsage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressUsage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressUsageForArrayConstraintsFromSetAddressUsage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerAddressInformationAddressUsageItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerAddressInformationAddressUsageItem instanceof \StructType\CustomerReponseCustomerAddressUsage) {
                $invalidValues[] = is_object($customerReponseCustomerAddressInformationAddressUsageItem) ? get_class($customerReponseCustomerAddressInformationAddressUsageItem) : sprintf('%s(%s)', gettype($customerReponseCustomerAddressInformationAddressUsageItem), var_export($customerReponseCustomerAddressInformationAddressUsageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressUsage property can only contain items of type \StructType\CustomerReponseCustomerAddressUsage, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerAddressUsage[] $addressUsage
     * @return \StructType\CustomerReponseCustomerAddressInformation
     */
    public function setAddressUsage(array $addressUsage = array())
    {
        // validation for constraint: array
        if ('' !== ($addressUsageArrayErrorMessage = self::validateAddressUsageForArrayConstraintsFromSetAddressUsage($addressUsage))) {
            throw new \InvalidArgumentException($addressUsageArrayErrorMessage, __LINE__);
        }
        $this->AddressUsage = $addressUsage;
        return $this;
    }
    /**
     * Add item to AddressUsage value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerAddressUsage $item
     * @return \StructType\CustomerReponseCustomerAddressInformation
     */
    public function addToAddressUsage(\StructType\CustomerReponseCustomerAddressUsage $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerAddressUsage) {
            throw new \InvalidArgumentException(sprintf('The AddressUsage property can only contain items of type \StructType\CustomerReponseCustomerAddressUsage, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressUsage[] = $item;
        return $this;
    }
    /**
     * Get Address value
     * @return \StructType\CustomerReponseCustomerAddress|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \StructType\CustomerReponseCustomerAddress $address
     * @return \StructType\CustomerReponseCustomerAddressInformation
     */
    public function setAddress(\StructType\CustomerReponseCustomerAddress $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get AddressInformationValidityPeriod value
     * @return \StructType\CLOSED_DatePeriod|null
     */
    public function getAddressInformationValidityPeriod()
    {
        return $this->AddressInformationValidityPeriod;
    }
    /**
     * Set AddressInformationValidityPeriod value
     * @param \StructType\CLOSED_DatePeriod $addressInformationValidityPeriod
     * @return \StructType\CustomerReponseCustomerAddressInformation
     */
    public function setAddressInformationValidityPeriod(\StructType\CLOSED_DatePeriod $addressInformationValidityPeriod = null)
    {
        $this->AddressInformationValidityPeriod = $addressInformationValidityPeriod;
        return $this;
    }
}
