<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomerAddress StructType
 * @subpackage Structs
 */
class CustomerReponseCustomerAddress extends AbstractStructBase
{
    /**
     * The CorrespondenceLanguageCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:language
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $CorrespondenceLanguageCode;
    /**
     * The PreferredCommunicationMediumTypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CommunicationMediumTypeCode
     */
    public $PreferredCommunicationMediumTypeCode;
    /**
     * The EmailURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\EmailURI
     */
    public $EmailURI;
    /**
     * The FacsimileFormattedNumberDescription
     * Meta information extracted from the WSDL
     * - documentation: Description
     * - base: xsd:string
     * - maxLength: 40
     * - minOccurs: 0
     * @var string
     */
    public $FacsimileFormattedNumberDescription;
    /**
     * The PostalAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerAddressPostalAddress
     */
    public $PostalAddress;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerAddressTelephone[]
     */
    public $Telephone;
    /**
     * The WebURI
     * Meta information extracted from the WSDL
     * - documentation: URI
     * - base: xsd:anyURI
     * - minOccurs: 0
     * @var string
     */
    public $WebURI;
    /**
     * The FormattedAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerFormattedAddress
     */
    public $FormattedAddress;
    /**
     * Constructor method for CustomerReponseCustomerAddress
     * @uses CustomerReponseCustomerAddress::setCorrespondenceLanguageCode()
     * @uses CustomerReponseCustomerAddress::setPreferredCommunicationMediumTypeCode()
     * @uses CustomerReponseCustomerAddress::setEmailURI()
     * @uses CustomerReponseCustomerAddress::setFacsimileFormattedNumberDescription()
     * @uses CustomerReponseCustomerAddress::setPostalAddress()
     * @uses CustomerReponseCustomerAddress::setTelephone()
     * @uses CustomerReponseCustomerAddress::setWebURI()
     * @uses CustomerReponseCustomerAddress::setFormattedAddress()
     * @param string $correspondenceLanguageCode
     * @param \StructType\CommunicationMediumTypeCode $preferredCommunicationMediumTypeCode
     * @param \StructType\EmailURI $emailURI
     * @param string $facsimileFormattedNumberDescription
     * @param \StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress
     * @param \StructType\CustomerReponseCustomerAddressTelephone[] $telephone
     * @param string $webURI
     * @param \StructType\CustomerReponseCustomerFormattedAddress $formattedAddress
     */
    public function __construct($correspondenceLanguageCode = null, \StructType\CommunicationMediumTypeCode $preferredCommunicationMediumTypeCode = null, \StructType\EmailURI $emailURI = null, $facsimileFormattedNumberDescription = null, \StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress = null, array $telephone = array(), $webURI = null, \StructType\CustomerReponseCustomerFormattedAddress $formattedAddress = null)
    {
        $this
            ->setCorrespondenceLanguageCode($correspondenceLanguageCode)
            ->setPreferredCommunicationMediumTypeCode($preferredCommunicationMediumTypeCode)
            ->setEmailURI($emailURI)
            ->setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription)
            ->setPostalAddress($postalAddress)
            ->setTelephone($telephone)
            ->setWebURI($webURI)
            ->setFormattedAddress($formattedAddress);
    }
    /**
     * Get CorrespondenceLanguageCode value
     * @return string|null
     */
    public function getCorrespondenceLanguageCode()
    {
        return $this->CorrespondenceLanguageCode;
    }
    /**
     * Set CorrespondenceLanguageCode value
     * @param string $correspondenceLanguageCode
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setCorrespondenceLanguageCode($correspondenceLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($correspondenceLanguageCode) && !is_string($correspondenceLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($correspondenceLanguageCode, true), gettype($correspondenceLanguageCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($correspondenceLanguageCode) && mb_strlen($correspondenceLanguageCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($correspondenceLanguageCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($correspondenceLanguageCode) && mb_strlen($correspondenceLanguageCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($correspondenceLanguageCode)), __LINE__);
        }
        $this->CorrespondenceLanguageCode = $correspondenceLanguageCode;
        return $this;
    }
    /**
     * Get PreferredCommunicationMediumTypeCode value
     * @return \StructType\CommunicationMediumTypeCode|null
     */
    public function getPreferredCommunicationMediumTypeCode()
    {
        return $this->PreferredCommunicationMediumTypeCode;
    }
    /**
     * Set PreferredCommunicationMediumTypeCode value
     * @param \StructType\CommunicationMediumTypeCode $preferredCommunicationMediumTypeCode
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setPreferredCommunicationMediumTypeCode(\StructType\CommunicationMediumTypeCode $preferredCommunicationMediumTypeCode = null)
    {
        $this->PreferredCommunicationMediumTypeCode = $preferredCommunicationMediumTypeCode;
        return $this;
    }
    /**
     * Get EmailURI value
     * @return \StructType\EmailURI|null
     */
    public function getEmailURI()
    {
        return $this->EmailURI;
    }
    /**
     * Set EmailURI value
     * @param \StructType\EmailURI $emailURI
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setEmailURI(\StructType\EmailURI $emailURI = null)
    {
        $this->EmailURI = $emailURI;
        return $this;
    }
    /**
     * Get FacsimileFormattedNumberDescription value
     * @return string|null
     */
    public function getFacsimileFormattedNumberDescription()
    {
        return $this->FacsimileFormattedNumberDescription;
    }
    /**
     * Set FacsimileFormattedNumberDescription value
     * @param string $facsimileFormattedNumberDescription
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setFacsimileFormattedNumberDescription($facsimileFormattedNumberDescription = null)
    {
        // validation for constraint: string
        if (!is_null($facsimileFormattedNumberDescription) && !is_string($facsimileFormattedNumberDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($facsimileFormattedNumberDescription, true), gettype($facsimileFormattedNumberDescription)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($facsimileFormattedNumberDescription) && mb_strlen($facsimileFormattedNumberDescription) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($facsimileFormattedNumberDescription)), __LINE__);
        }
        $this->FacsimileFormattedNumberDescription = $facsimileFormattedNumberDescription;
        return $this;
    }
    /**
     * Get PostalAddress value
     * @return \StructType\CustomerReponseCustomerAddressPostalAddress|null
     */
    public function getPostalAddress()
    {
        return $this->PostalAddress;
    }
    /**
     * Set PostalAddress value
     * @param \StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setPostalAddress(\StructType\CustomerReponseCustomerAddressPostalAddress $postalAddress = null)
    {
        $this->PostalAddress = $postalAddress;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\CustomerReponseCustomerAddressTelephone[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephone method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephone method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneForArrayConstraintsFromSetTelephone(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerAddressTelephoneItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerAddressTelephoneItem instanceof \StructType\CustomerReponseCustomerAddressTelephone) {
                $invalidValues[] = is_object($customerReponseCustomerAddressTelephoneItem) ? get_class($customerReponseCustomerAddressTelephoneItem) : sprintf('%s(%s)', gettype($customerReponseCustomerAddressTelephoneItem), var_export($customerReponseCustomerAddressTelephoneItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Telephone property can only contain items of type \StructType\CustomerReponseCustomerAddressTelephone, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerAddressTelephone[] $telephone
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setTelephone(array $telephone = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneArrayErrorMessage = self::validateTelephoneForArrayConstraintsFromSetTelephone($telephone))) {
            throw new \InvalidArgumentException($telephoneArrayErrorMessage, __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerAddressTelephone $item
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function addToTelephone(\StructType\CustomerReponseCustomerAddressTelephone $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerAddressTelephone) {
            throw new \InvalidArgumentException(sprintf('The Telephone property can only contain items of type \StructType\CustomerReponseCustomerAddressTelephone, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get WebURI value
     * @return string|null
     */
    public function getWebURI()
    {
        return $this->WebURI;
    }
    /**
     * Set WebURI value
     * @param string $webURI
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setWebURI($webURI = null)
    {
        // validation for constraint: string
        if (!is_null($webURI) && !is_string($webURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webURI, true), gettype($webURI)), __LINE__);
        }
        $this->WebURI = $webURI;
        return $this;
    }
    /**
     * Get FormattedAddress value
     * @return \StructType\CustomerReponseCustomerFormattedAddress|null
     */
    public function getFormattedAddress()
    {
        return $this->FormattedAddress;
    }
    /**
     * Set FormattedAddress value
     * @param \StructType\CustomerReponseCustomerFormattedAddress $formattedAddress
     * @return \StructType\CustomerReponseCustomerAddress
     */
    public function setFormattedAddress(\StructType\CustomerReponseCustomerFormattedAddress $formattedAddress = null)
    {
        $this->FormattedAddress = $formattedAddress;
        return $this;
    }
}
