<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerReponseCustomer StructType
 * @subpackage Structs
 */
class CustomerReponseCustomer extends AbstractStructBase
{
    /**
     * The ChangeStateID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 40
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChangeStateID;
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The InternalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 10
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InternalID;
    /**
     * The SystemAdministrativeData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SystemAdministrativeData
     */
    public $SystemAdministrativeData;
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - length: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryCode;
    /**
     * The ProspectIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $ProspectIndicator;
    /**
     * The CustomerIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $CustomerIndicator;
    /**
     * The LifeCycleStatusCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LifeCycleStatusCode;
    /**
     * The Person
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerPerson
     */
    public $Person;
    /**
     * The Organisation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerOrganisation
     */
    public $Organisation;
    /**
     * The VerbalCommunicationLanguageCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:language
     * - maxLength: 2
     * - minLength: 2
     * - minOccurs: 0
     * @var string
     */
    public $VerbalCommunicationLanguageCode;
    /**
     * The ContactAllowedCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - length: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactAllowedCode;
    /**
     * The LegalCompetenceIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $LegalCompetenceIndicator;
    /**
     * The DunAndBradstreetNumberID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $DunAndBradstreetNumberID;
    /**
     * The GlobalLocationNumberID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $GlobalLocationNumberID;
    /**
     * The PeppolParticipantID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $PeppolParticipantID;
    /**
     * The NationalProviderID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $NationalProviderID;
    /**
     * The ABCClassificationCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustomerABCClassificationCode
     */
    public $ABCClassificationCode;
    /**
     * The NielsenRegionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NielsenRegionCode
     */
    public $NielsenRegionCode;
    /**
     * The IndustrialSectorCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\IndustrialSectorCode
     */
    public $IndustrialSectorCode;
    /**
     * The AddressInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerAddressInformation[]
     */
    public $AddressInformation;
    /**
     * The Relationship
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerRelationship[]
     */
    public $Relationship;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerContactPerson[]
     */
    public $ContactPerson;
    /**
     * The CommunicationArrangement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerCommunicationArrangement[]
     */
    public $CommunicationArrangement;
    /**
     * The CommunicationArrangementMultiChannel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel[]
     */
    public $CommunicationArrangementMultiChannel;
    /**
     * The DirectResponsibility
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerDirectResponsibility[]
     */
    public $DirectResponsibility;
    /**
     * The SalesArrangement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerSalesArrangement[]
     */
    public $SalesArrangement;
    /**
     * The InvoicingBlockingReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $InvoicingBlockingReasonCode;
    /**
     * The CustomerTransactionDocumentFulfilmentBlockingReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerTransactionDocumentFulfilmentBlockingReasonCode;
    /**
     * The CustomerBlockingReasonCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 2
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerBlockingReasonCode;
    /**
     * The BankDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerBankDetails[]
     */
    public $BankDetails;
    /**
     * The PaymentCardDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerPaymentCardDetails[]
     */
    public $PaymentCardDetails;
    /**
     * The PaymentData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerPaymentData[]
     */
    public $PaymentData;
    /**
     * The TaxNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerTaxNumber[]
     */
    public $TaxNumber;
    /**
     * The GeneralProductTaxExemption
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerGeneralProductTaxExemption[]
     */
    public $GeneralProductTaxExemption;
    /**
     * The TaxExemptionCertificate
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerResponseCustomerTaxExemptionCertificate[]
     */
    public $TaxExemptionCertificate;
    /**
     * The OperatingHoursInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerOperatingHoursInformation[]
     */
    public $OperatingHoursInformation;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CustomerReponseCustomerText[]
     */
    public $Text;
    /**
     * The AttachmentFolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccessAttachmentFolder
     */
    public $AttachmentFolder;
    /**
     * The EnterpriseIdentificationNumber
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 60
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $EnterpriseIdentificationNumber;
    /**
     * The TaxPayerCategoryCode
     * @var \StructType\TaxPayerCategoryCode
     */
    public $TaxPayerCategoryCode;
    /**
     * The EnterpriseIdentificationSupplementCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 1
     * @var string
     */
    public $EnterpriseIdentificationSupplementCode;
    /**
     * The InvoiceSummaryRoleCode
     * @var \StructType\JP_LogisticsInvoiceSummaryBusinessPartnerTypeCode
     */
    public $InvoiceSummaryRoleCode;
    /**
     * The ClosingDatePatternID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - form: qualified
     * - maxLength: 4
     * - minOccurs: 0
     * - type: xi25:ClosingDatePatternID
     * @var string
     */
    public $ClosingDatePatternID;
    /**
     * The MxUseCfdiCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * @var string
     */
    public $MxUseCfdiCode;
    /**
     * The CustomerTCSIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * @var bool
     */
    public $CustomerTCSIndicator;
    /**
     * Constructor method for CustomerReponseCustomer
     * @uses CustomerReponseCustomer::setChangeStateID()
     * @uses CustomerReponseCustomer::setUUID()
     * @uses CustomerReponseCustomer::setInternalID()
     * @uses CustomerReponseCustomer::setSystemAdministrativeData()
     * @uses CustomerReponseCustomer::setCategoryCode()
     * @uses CustomerReponseCustomer::setProspectIndicator()
     * @uses CustomerReponseCustomer::setCustomerIndicator()
     * @uses CustomerReponseCustomer::setLifeCycleStatusCode()
     * @uses CustomerReponseCustomer::setPerson()
     * @uses CustomerReponseCustomer::setOrganisation()
     * @uses CustomerReponseCustomer::setVerbalCommunicationLanguageCode()
     * @uses CustomerReponseCustomer::setContactAllowedCode()
     * @uses CustomerReponseCustomer::setLegalCompetenceIndicator()
     * @uses CustomerReponseCustomer::setDunAndBradstreetNumberID()
     * @uses CustomerReponseCustomer::setGlobalLocationNumberID()
     * @uses CustomerReponseCustomer::setPeppolParticipantID()
     * @uses CustomerReponseCustomer::setNationalProviderID()
     * @uses CustomerReponseCustomer::setABCClassificationCode()
     * @uses CustomerReponseCustomer::setNielsenRegionCode()
     * @uses CustomerReponseCustomer::setIndustrialSectorCode()
     * @uses CustomerReponseCustomer::setAddressInformation()
     * @uses CustomerReponseCustomer::setRelationship()
     * @uses CustomerReponseCustomer::setContactPerson()
     * @uses CustomerReponseCustomer::setCommunicationArrangement()
     * @uses CustomerReponseCustomer::setCommunicationArrangementMultiChannel()
     * @uses CustomerReponseCustomer::setDirectResponsibility()
     * @uses CustomerReponseCustomer::setSalesArrangement()
     * @uses CustomerReponseCustomer::setInvoicingBlockingReasonCode()
     * @uses CustomerReponseCustomer::setCustomerTransactionDocumentFulfilmentBlockingReasonCode()
     * @uses CustomerReponseCustomer::setCustomerBlockingReasonCode()
     * @uses CustomerReponseCustomer::setBankDetails()
     * @uses CustomerReponseCustomer::setPaymentCardDetails()
     * @uses CustomerReponseCustomer::setPaymentData()
     * @uses CustomerReponseCustomer::setTaxNumber()
     * @uses CustomerReponseCustomer::setGeneralProductTaxExemption()
     * @uses CustomerReponseCustomer::setTaxExemptionCertificate()
     * @uses CustomerReponseCustomer::setOperatingHoursInformation()
     * @uses CustomerReponseCustomer::setText()
     * @uses CustomerReponseCustomer::setAttachmentFolder()
     * @uses CustomerReponseCustomer::setEnterpriseIdentificationNumber()
     * @uses CustomerReponseCustomer::setTaxPayerCategoryCode()
     * @uses CustomerReponseCustomer::setEnterpriseIdentificationSupplementCode()
     * @uses CustomerReponseCustomer::setInvoiceSummaryRoleCode()
     * @uses CustomerReponseCustomer::setClosingDatePatternID()
     * @uses CustomerReponseCustomer::setMxUseCfdiCode()
     * @uses CustomerReponseCustomer::setCustomerTCSIndicator()
     * @param string $changeStateID
     * @param \StructType\UUID $uUID
     * @param string $internalID
     * @param \StructType\SystemAdministrativeData $systemAdministrativeData
     * @param string $categoryCode
     * @param bool $prospectIndicator
     * @param bool $customerIndicator
     * @param string $lifeCycleStatusCode
     * @param \StructType\CustomerReponseCustomerPerson $person
     * @param \StructType\CustomerReponseCustomerOrganisation $organisation
     * @param string $verbalCommunicationLanguageCode
     * @param string $contactAllowedCode
     * @param bool $legalCompetenceIndicator
     * @param string $dunAndBradstreetNumberID
     * @param string $globalLocationNumberID
     * @param string $peppolParticipantID
     * @param string $nationalProviderID
     * @param \StructType\CustomerABCClassificationCode $aBCClassificationCode
     * @param \StructType\NielsenRegionCode $nielsenRegionCode
     * @param \StructType\IndustrialSectorCode $industrialSectorCode
     * @param \StructType\CustomerReponseCustomerAddressInformation[] $addressInformation
     * @param \StructType\CustomerReponseCustomerRelationship[] $relationship
     * @param \StructType\CustomerReponseCustomerContactPerson[] $contactPerson
     * @param \StructType\CustomerReponseCustomerCommunicationArrangement[] $communicationArrangement
     * @param \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel[] $communicationArrangementMultiChannel
     * @param \StructType\CustomerReponseCustomerDirectResponsibility[] $directResponsibility
     * @param \StructType\CustomerReponseCustomerSalesArrangement[] $salesArrangement
     * @param string $invoicingBlockingReasonCode
     * @param string $customerTransactionDocumentFulfilmentBlockingReasonCode
     * @param string $customerBlockingReasonCode
     * @param \StructType\CustomerReponseCustomerBankDetails[] $bankDetails
     * @param \StructType\CustomerReponseCustomerPaymentCardDetails[] $paymentCardDetails
     * @param \StructType\CustomerReponseCustomerPaymentData[] $paymentData
     * @param \StructType\CustomerReponseCustomerTaxNumber[] $taxNumber
     * @param \StructType\CustomerReponseCustomerGeneralProductTaxExemption[] $generalProductTaxExemption
     * @param \StructType\CustomerResponseCustomerTaxExemptionCertificate[] $taxExemptionCertificate
     * @param \StructType\CustomerReponseCustomerOperatingHoursInformation[] $operatingHoursInformation
     * @param \StructType\CustomerReponseCustomerText[] $text
     * @param \StructType\AccessAttachmentFolder $attachmentFolder
     * @param string $enterpriseIdentificationNumber
     * @param \StructType\TaxPayerCategoryCode $taxPayerCategoryCode
     * @param string $enterpriseIdentificationSupplementCode
     * @param \StructType\JP_LogisticsInvoiceSummaryBusinessPartnerTypeCode $invoiceSummaryRoleCode
     * @param string $closingDatePatternID
     * @param string $mxUseCfdiCode
     * @param bool $customerTCSIndicator
     */
    public function __construct($changeStateID = null, \StructType\UUID $uUID = null, $internalID = null, \StructType\SystemAdministrativeData $systemAdministrativeData = null, $categoryCode = null, $prospectIndicator = null, $customerIndicator = null, $lifeCycleStatusCode = null, \StructType\CustomerReponseCustomerPerson $person = null, \StructType\CustomerReponseCustomerOrganisation $organisation = null, $verbalCommunicationLanguageCode = null, $contactAllowedCode = null, $legalCompetenceIndicator = null, $dunAndBradstreetNumberID = null, $globalLocationNumberID = null, $peppolParticipantID = null, $nationalProviderID = null, \StructType\CustomerABCClassificationCode $aBCClassificationCode = null, \StructType\NielsenRegionCode $nielsenRegionCode = null, \StructType\IndustrialSectorCode $industrialSectorCode = null, array $addressInformation = array(), array $relationship = array(), array $contactPerson = array(), array $communicationArrangement = array(), array $communicationArrangementMultiChannel = array(), array $directResponsibility = array(), array $salesArrangement = array(), $invoicingBlockingReasonCode = null, $customerTransactionDocumentFulfilmentBlockingReasonCode = null, $customerBlockingReasonCode = null, array $bankDetails = array(), array $paymentCardDetails = array(), array $paymentData = array(), array $taxNumber = array(), array $generalProductTaxExemption = array(), array $taxExemptionCertificate = array(), array $operatingHoursInformation = array(), array $text = array(), \StructType\AccessAttachmentFolder $attachmentFolder = null, $enterpriseIdentificationNumber = null, \StructType\TaxPayerCategoryCode $taxPayerCategoryCode = null, $enterpriseIdentificationSupplementCode = null, \StructType\JP_LogisticsInvoiceSummaryBusinessPartnerTypeCode $invoiceSummaryRoleCode = null, $closingDatePatternID = null, $mxUseCfdiCode = null, $customerTCSIndicator = null)
    {
        $this
            ->setChangeStateID($changeStateID)
            ->setUUID($uUID)
            ->setInternalID($internalID)
            ->setSystemAdministrativeData($systemAdministrativeData)
            ->setCategoryCode($categoryCode)
            ->setProspectIndicator($prospectIndicator)
            ->setCustomerIndicator($customerIndicator)
            ->setLifeCycleStatusCode($lifeCycleStatusCode)
            ->setPerson($person)
            ->setOrganisation($organisation)
            ->setVerbalCommunicationLanguageCode($verbalCommunicationLanguageCode)
            ->setContactAllowedCode($contactAllowedCode)
            ->setLegalCompetenceIndicator($legalCompetenceIndicator)
            ->setDunAndBradstreetNumberID($dunAndBradstreetNumberID)
            ->setGlobalLocationNumberID($globalLocationNumberID)
            ->setPeppolParticipantID($peppolParticipantID)
            ->setNationalProviderID($nationalProviderID)
            ->setABCClassificationCode($aBCClassificationCode)
            ->setNielsenRegionCode($nielsenRegionCode)
            ->setIndustrialSectorCode($industrialSectorCode)
            ->setAddressInformation($addressInformation)
            ->setRelationship($relationship)
            ->setContactPerson($contactPerson)
            ->setCommunicationArrangement($communicationArrangement)
            ->setCommunicationArrangementMultiChannel($communicationArrangementMultiChannel)
            ->setDirectResponsibility($directResponsibility)
            ->setSalesArrangement($salesArrangement)
            ->setInvoicingBlockingReasonCode($invoicingBlockingReasonCode)
            ->setCustomerTransactionDocumentFulfilmentBlockingReasonCode($customerTransactionDocumentFulfilmentBlockingReasonCode)
            ->setCustomerBlockingReasonCode($customerBlockingReasonCode)
            ->setBankDetails($bankDetails)
            ->setPaymentCardDetails($paymentCardDetails)
            ->setPaymentData($paymentData)
            ->setTaxNumber($taxNumber)
            ->setGeneralProductTaxExemption($generalProductTaxExemption)
            ->setTaxExemptionCertificate($taxExemptionCertificate)
            ->setOperatingHoursInformation($operatingHoursInformation)
            ->setText($text)
            ->setAttachmentFolder($attachmentFolder)
            ->setEnterpriseIdentificationNumber($enterpriseIdentificationNumber)
            ->setTaxPayerCategoryCode($taxPayerCategoryCode)
            ->setEnterpriseIdentificationSupplementCode($enterpriseIdentificationSupplementCode)
            ->setInvoiceSummaryRoleCode($invoiceSummaryRoleCode)
            ->setClosingDatePatternID($closingDatePatternID)
            ->setMxUseCfdiCode($mxUseCfdiCode)
            ->setCustomerTCSIndicator($customerTCSIndicator);
    }
    /**
     * Get ChangeStateID value
     * @return string|null
     */
    public function getChangeStateID()
    {
        return $this->ChangeStateID;
    }
    /**
     * Set ChangeStateID value
     * @param string $changeStateID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setChangeStateID($changeStateID = null)
    {
        // validation for constraint: string
        if (!is_null($changeStateID) && !is_string($changeStateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeStateID, true), gettype($changeStateID)), __LINE__);
        }
        // validation for constraint: maxLength(40)
        if (!is_null($changeStateID) && mb_strlen($changeStateID) > 40) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 40', mb_strlen($changeStateID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($changeStateID) && mb_strlen($changeStateID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($changeStateID)), __LINE__);
        }
        $this->ChangeStateID = $changeStateID;
        return $this;
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get InternalID value
     * @return string|null
     */
    public function getInternalID()
    {
        return $this->InternalID;
    }
    /**
     * Set InternalID value
     * @param string $internalID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setInternalID($internalID = null)
    {
        // validation for constraint: string
        if (!is_null($internalID) && !is_string($internalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($internalID, true), gettype($internalID)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($internalID) && mb_strlen($internalID) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($internalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($internalID) && mb_strlen($internalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($internalID)), __LINE__);
        }
        $this->InternalID = $internalID;
        return $this;
    }
    /**
     * Get SystemAdministrativeData value
     * @return \StructType\SystemAdministrativeData|null
     */
    public function getSystemAdministrativeData()
    {
        return $this->SystemAdministrativeData;
    }
    /**
     * Set SystemAdministrativeData value
     * @param \StructType\SystemAdministrativeData $systemAdministrativeData
     * @return \StructType\CustomerReponseCustomer
     */
    public function setSystemAdministrativeData(\StructType\SystemAdministrativeData $systemAdministrativeData = null)
    {
        $this->SystemAdministrativeData = $systemAdministrativeData;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($categoryCode) && mb_strlen($categoryCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get ProspectIndicator value
     * @return bool|null
     */
    public function getProspectIndicator()
    {
        return $this->ProspectIndicator;
    }
    /**
     * Set ProspectIndicator value
     * @param bool $prospectIndicator
     * @return \StructType\CustomerReponseCustomer
     */
    public function setProspectIndicator($prospectIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($prospectIndicator) && !is_bool($prospectIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($prospectIndicator, true), gettype($prospectIndicator)), __LINE__);
        }
        $this->ProspectIndicator = $prospectIndicator;
        return $this;
    }
    /**
     * Get CustomerIndicator value
     * @return bool|null
     */
    public function getCustomerIndicator()
    {
        return $this->CustomerIndicator;
    }
    /**
     * Set CustomerIndicator value
     * @param bool $customerIndicator
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCustomerIndicator($customerIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerIndicator) && !is_bool($customerIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerIndicator, true), gettype($customerIndicator)), __LINE__);
        }
        $this->CustomerIndicator = $customerIndicator;
        return $this;
    }
    /**
     * Get LifeCycleStatusCode value
     * @return string|null
     */
    public function getLifeCycleStatusCode()
    {
        return $this->LifeCycleStatusCode;
    }
    /**
     * Set LifeCycleStatusCode value
     * @uses \EnumType\PartyLifeCycleStatusCode::valueIsValid()
     * @uses \EnumType\PartyLifeCycleStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lifeCycleStatusCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setLifeCycleStatusCode($lifeCycleStatusCode = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PartyLifeCycleStatusCode::valueIsValid($lifeCycleStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PartyLifeCycleStatusCode', is_array($lifeCycleStatusCode) ? implode(', ', $lifeCycleStatusCode) : var_export($lifeCycleStatusCode, true), implode(', ', \EnumType\PartyLifeCycleStatusCode::getValidValues())), __LINE__);
        }
        $this->LifeCycleStatusCode = $lifeCycleStatusCode;
        return $this;
    }
    /**
     * Get Person value
     * @return \StructType\CustomerReponseCustomerPerson|null
     */
    public function getPerson()
    {
        return $this->Person;
    }
    /**
     * Set Person value
     * @param \StructType\CustomerReponseCustomerPerson $person
     * @return \StructType\CustomerReponseCustomer
     */
    public function setPerson(\StructType\CustomerReponseCustomerPerson $person = null)
    {
        $this->Person = $person;
        return $this;
    }
    /**
     * Get Organisation value
     * @return \StructType\CustomerReponseCustomerOrganisation|null
     */
    public function getOrganisation()
    {
        return $this->Organisation;
    }
    /**
     * Set Organisation value
     * @param \StructType\CustomerReponseCustomerOrganisation $organisation
     * @return \StructType\CustomerReponseCustomer
     */
    public function setOrganisation(\StructType\CustomerReponseCustomerOrganisation $organisation = null)
    {
        $this->Organisation = $organisation;
        return $this;
    }
    /**
     * Get VerbalCommunicationLanguageCode value
     * @return string|null
     */
    public function getVerbalCommunicationLanguageCode()
    {
        return $this->VerbalCommunicationLanguageCode;
    }
    /**
     * Set VerbalCommunicationLanguageCode value
     * @param string $verbalCommunicationLanguageCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setVerbalCommunicationLanguageCode($verbalCommunicationLanguageCode = null)
    {
        // validation for constraint: string
        if (!is_null($verbalCommunicationLanguageCode) && !is_string($verbalCommunicationLanguageCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verbalCommunicationLanguageCode, true), gettype($verbalCommunicationLanguageCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($verbalCommunicationLanguageCode) && mb_strlen($verbalCommunicationLanguageCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($verbalCommunicationLanguageCode)), __LINE__);
        }
        // validation for constraint: minLength(2)
        if (!is_null($verbalCommunicationLanguageCode) && mb_strlen($verbalCommunicationLanguageCode) < 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 2', mb_strlen($verbalCommunicationLanguageCode)), __LINE__);
        }
        $this->VerbalCommunicationLanguageCode = $verbalCommunicationLanguageCode;
        return $this;
    }
    /**
     * Get ContactAllowedCode value
     * @return string|null
     */
    public function getContactAllowedCode()
    {
        return $this->ContactAllowedCode;
    }
    /**
     * Set ContactAllowedCode value
     * @param string $contactAllowedCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setContactAllowedCode($contactAllowedCode = null)
    {
        // validation for constraint: string
        if (!is_null($contactAllowedCode) && !is_string($contactAllowedCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactAllowedCode, true), gettype($contactAllowedCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($contactAllowedCode) && mb_strlen($contactAllowedCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($contactAllowedCode)), __LINE__);
        }
        $this->ContactAllowedCode = $contactAllowedCode;
        return $this;
    }
    /**
     * Get LegalCompetenceIndicator value
     * @return bool|null
     */
    public function getLegalCompetenceIndicator()
    {
        return $this->LegalCompetenceIndicator;
    }
    /**
     * Set LegalCompetenceIndicator value
     * @param bool $legalCompetenceIndicator
     * @return \StructType\CustomerReponseCustomer
     */
    public function setLegalCompetenceIndicator($legalCompetenceIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($legalCompetenceIndicator) && !is_bool($legalCompetenceIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($legalCompetenceIndicator, true), gettype($legalCompetenceIndicator)), __LINE__);
        }
        $this->LegalCompetenceIndicator = $legalCompetenceIndicator;
        return $this;
    }
    /**
     * Get DunAndBradstreetNumberID value
     * @return string|null
     */
    public function getDunAndBradstreetNumberID()
    {
        return $this->DunAndBradstreetNumberID;
    }
    /**
     * Set DunAndBradstreetNumberID value
     * @param string $dunAndBradstreetNumberID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setDunAndBradstreetNumberID($dunAndBradstreetNumberID = null)
    {
        // validation for constraint: string
        if (!is_null($dunAndBradstreetNumberID) && !is_string($dunAndBradstreetNumberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dunAndBradstreetNumberID, true), gettype($dunAndBradstreetNumberID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($dunAndBradstreetNumberID) && mb_strlen($dunAndBradstreetNumberID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($dunAndBradstreetNumberID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($dunAndBradstreetNumberID) && mb_strlen($dunAndBradstreetNumberID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($dunAndBradstreetNumberID)), __LINE__);
        }
        $this->DunAndBradstreetNumberID = $dunAndBradstreetNumberID;
        return $this;
    }
    /**
     * Get GlobalLocationNumberID value
     * @return string|null
     */
    public function getGlobalLocationNumberID()
    {
        return $this->GlobalLocationNumberID;
    }
    /**
     * Set GlobalLocationNumberID value
     * @param string $globalLocationNumberID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setGlobalLocationNumberID($globalLocationNumberID = null)
    {
        // validation for constraint: string
        if (!is_null($globalLocationNumberID) && !is_string($globalLocationNumberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($globalLocationNumberID, true), gettype($globalLocationNumberID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($globalLocationNumberID) && mb_strlen($globalLocationNumberID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($globalLocationNumberID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($globalLocationNumberID) && mb_strlen($globalLocationNumberID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($globalLocationNumberID)), __LINE__);
        }
        $this->GlobalLocationNumberID = $globalLocationNumberID;
        return $this;
    }
    /**
     * Get PeppolParticipantID value
     * @return string|null
     */
    public function getPeppolParticipantID()
    {
        return $this->PeppolParticipantID;
    }
    /**
     * Set PeppolParticipantID value
     * @param string $peppolParticipantID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setPeppolParticipantID($peppolParticipantID = null)
    {
        // validation for constraint: string
        if (!is_null($peppolParticipantID) && !is_string($peppolParticipantID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($peppolParticipantID, true), gettype($peppolParticipantID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($peppolParticipantID) && mb_strlen($peppolParticipantID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($peppolParticipantID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($peppolParticipantID) && mb_strlen($peppolParticipantID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($peppolParticipantID)), __LINE__);
        }
        $this->PeppolParticipantID = $peppolParticipantID;
        return $this;
    }
    /**
     * Get NationalProviderID value
     * @return string|null
     */
    public function getNationalProviderID()
    {
        return $this->NationalProviderID;
    }
    /**
     * Set NationalProviderID value
     * @param string $nationalProviderID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setNationalProviderID($nationalProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($nationalProviderID) && !is_string($nationalProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalProviderID, true), gettype($nationalProviderID)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($nationalProviderID) && mb_strlen($nationalProviderID) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($nationalProviderID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nationalProviderID) && mb_strlen($nationalProviderID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nationalProviderID)), __LINE__);
        }
        $this->NationalProviderID = $nationalProviderID;
        return $this;
    }
    /**
     * Get ABCClassificationCode value
     * @return \StructType\CustomerABCClassificationCode|null
     */
    public function getABCClassificationCode()
    {
        return $this->ABCClassificationCode;
    }
    /**
     * Set ABCClassificationCode value
     * @param \StructType\CustomerABCClassificationCode $aBCClassificationCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setABCClassificationCode(\StructType\CustomerABCClassificationCode $aBCClassificationCode = null)
    {
        $this->ABCClassificationCode = $aBCClassificationCode;
        return $this;
    }
    /**
     * Get NielsenRegionCode value
     * @return \StructType\NielsenRegionCode|null
     */
    public function getNielsenRegionCode()
    {
        return $this->NielsenRegionCode;
    }
    /**
     * Set NielsenRegionCode value
     * @param \StructType\NielsenRegionCode $nielsenRegionCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setNielsenRegionCode(\StructType\NielsenRegionCode $nielsenRegionCode = null)
    {
        $this->NielsenRegionCode = $nielsenRegionCode;
        return $this;
    }
    /**
     * Get IndustrialSectorCode value
     * @return \StructType\IndustrialSectorCode|null
     */
    public function getIndustrialSectorCode()
    {
        return $this->IndustrialSectorCode;
    }
    /**
     * Set IndustrialSectorCode value
     * @param \StructType\IndustrialSectorCode $industrialSectorCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setIndustrialSectorCode(\StructType\IndustrialSectorCode $industrialSectorCode = null)
    {
        $this->IndustrialSectorCode = $industrialSectorCode;
        return $this;
    }
    /**
     * Get AddressInformation value
     * @return \StructType\CustomerReponseCustomerAddressInformation[]|null
     */
    public function getAddressInformation()
    {
        return $this->AddressInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressInformationForArrayConstraintsFromSetAddressInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerAddressInformationItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerAddressInformationItem instanceof \StructType\CustomerReponseCustomerAddressInformation) {
                $invalidValues[] = is_object($customerReponseCustomerAddressInformationItem) ? get_class($customerReponseCustomerAddressInformationItem) : sprintf('%s(%s)', gettype($customerReponseCustomerAddressInformationItem), var_export($customerReponseCustomerAddressInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressInformation property can only contain items of type \StructType\CustomerReponseCustomerAddressInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerAddressInformation[] $addressInformation
     * @return \StructType\CustomerReponseCustomer
     */
    public function setAddressInformation(array $addressInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($addressInformationArrayErrorMessage = self::validateAddressInformationForArrayConstraintsFromSetAddressInformation($addressInformation))) {
            throw new \InvalidArgumentException($addressInformationArrayErrorMessage, __LINE__);
        }
        $this->AddressInformation = $addressInformation;
        return $this;
    }
    /**
     * Add item to AddressInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerAddressInformation $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToAddressInformation(\StructType\CustomerReponseCustomerAddressInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerAddressInformation) {
            throw new \InvalidArgumentException(sprintf('The AddressInformation property can only contain items of type \StructType\CustomerReponseCustomerAddressInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressInformation[] = $item;
        return $this;
    }
    /**
     * Get Relationship value
     * @return \StructType\CustomerReponseCustomerRelationship[]|null
     */
    public function getRelationship()
    {
        return $this->Relationship;
    }
    /**
     * This method is responsible for validating the values passed to the setRelationship method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelationship method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelationshipForArrayConstraintsFromSetRelationship(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerRelationshipItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerRelationshipItem instanceof \StructType\CustomerReponseCustomerRelationship) {
                $invalidValues[] = is_object($customerReponseCustomerRelationshipItem) ? get_class($customerReponseCustomerRelationshipItem) : sprintf('%s(%s)', gettype($customerReponseCustomerRelationshipItem), var_export($customerReponseCustomerRelationshipItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Relationship property can only contain items of type \StructType\CustomerReponseCustomerRelationship, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Relationship value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerRelationship[] $relationship
     * @return \StructType\CustomerReponseCustomer
     */
    public function setRelationship(array $relationship = array())
    {
        // validation for constraint: array
        if ('' !== ($relationshipArrayErrorMessage = self::validateRelationshipForArrayConstraintsFromSetRelationship($relationship))) {
            throw new \InvalidArgumentException($relationshipArrayErrorMessage, __LINE__);
        }
        $this->Relationship = $relationship;
        return $this;
    }
    /**
     * Add item to Relationship value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerRelationship $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToRelationship(\StructType\CustomerReponseCustomerRelationship $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerRelationship) {
            throw new \InvalidArgumentException(sprintf('The Relationship property can only contain items of type \StructType\CustomerReponseCustomerRelationship, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Relationship[] = $item;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return \StructType\CustomerReponseCustomerContactPerson[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerContactPersonItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerContactPersonItem instanceof \StructType\CustomerReponseCustomerContactPerson) {
                $invalidValues[] = is_object($customerReponseCustomerContactPersonItem) ? get_class($customerReponseCustomerContactPersonItem) : sprintf('%s(%s)', gettype($customerReponseCustomerContactPersonItem), var_export($customerReponseCustomerContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type \StructType\CustomerReponseCustomerContactPerson, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerContactPerson[] $contactPerson
     * @return \StructType\CustomerReponseCustomer
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerContactPerson $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToContactPerson(\StructType\CustomerReponseCustomerContactPerson $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerContactPerson) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type \StructType\CustomerReponseCustomerContactPerson, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get CommunicationArrangement value
     * @return \StructType\CustomerReponseCustomerCommunicationArrangement[]|null
     */
    public function getCommunicationArrangement()
    {
        return $this->CommunicationArrangement;
    }
    /**
     * This method is responsible for validating the values passed to the setCommunicationArrangement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunicationArrangement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommunicationArrangementForArrayConstraintsFromSetCommunicationArrangement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerCommunicationArrangementItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerCommunicationArrangementItem instanceof \StructType\CustomerReponseCustomerCommunicationArrangement) {
                $invalidValues[] = is_object($customerReponseCustomerCommunicationArrangementItem) ? get_class($customerReponseCustomerCommunicationArrangementItem) : sprintf('%s(%s)', gettype($customerReponseCustomerCommunicationArrangementItem), var_export($customerReponseCustomerCommunicationArrangementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommunicationArrangement property can only contain items of type \StructType\CustomerReponseCustomerCommunicationArrangement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommunicationArrangement value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerCommunicationArrangement[] $communicationArrangement
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCommunicationArrangement(array $communicationArrangement = array())
    {
        // validation for constraint: array
        if ('' !== ($communicationArrangementArrayErrorMessage = self::validateCommunicationArrangementForArrayConstraintsFromSetCommunicationArrangement($communicationArrangement))) {
            throw new \InvalidArgumentException($communicationArrangementArrayErrorMessage, __LINE__);
        }
        $this->CommunicationArrangement = $communicationArrangement;
        return $this;
    }
    /**
     * Add item to CommunicationArrangement value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerCommunicationArrangement $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToCommunicationArrangement(\StructType\CustomerReponseCustomerCommunicationArrangement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerCommunicationArrangement) {
            throw new \InvalidArgumentException(sprintf('The CommunicationArrangement property can only contain items of type \StructType\CustomerReponseCustomerCommunicationArrangement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommunicationArrangement[] = $item;
        return $this;
    }
    /**
     * Get CommunicationArrangementMultiChannel value
     * @return \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel[]|null
     */
    public function getCommunicationArrangementMultiChannel()
    {
        return $this->CommunicationArrangementMultiChannel;
    }
    /**
     * This method is responsible for validating the values passed to the setCommunicationArrangementMultiChannel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunicationArrangementMultiChannel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommunicationArrangementMultiChannelForArrayConstraintsFromSetCommunicationArrangementMultiChannel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerCommunicationArrangementMultiChannelItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerCommunicationArrangementMultiChannelItem instanceof \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel) {
                $invalidValues[] = is_object($customerReponseCustomerCommunicationArrangementMultiChannelItem) ? get_class($customerReponseCustomerCommunicationArrangementMultiChannelItem) : sprintf('%s(%s)', gettype($customerReponseCustomerCommunicationArrangementMultiChannelItem), var_export($customerReponseCustomerCommunicationArrangementMultiChannelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommunicationArrangementMultiChannel property can only contain items of type \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommunicationArrangementMultiChannel value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel[] $communicationArrangementMultiChannel
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCommunicationArrangementMultiChannel(array $communicationArrangementMultiChannel = array())
    {
        // validation for constraint: array
        if ('' !== ($communicationArrangementMultiChannelArrayErrorMessage = self::validateCommunicationArrangementMultiChannelForArrayConstraintsFromSetCommunicationArrangementMultiChannel($communicationArrangementMultiChannel))) {
            throw new \InvalidArgumentException($communicationArrangementMultiChannelArrayErrorMessage, __LINE__);
        }
        $this->CommunicationArrangementMultiChannel = $communicationArrangementMultiChannel;
        return $this;
    }
    /**
     * Add item to CommunicationArrangementMultiChannel value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToCommunicationArrangementMultiChannel(\StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel) {
            throw new \InvalidArgumentException(sprintf('The CommunicationArrangementMultiChannel property can only contain items of type \StructType\CustomerReponseCustomerCommunicationArrangementMultiChannel, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommunicationArrangementMultiChannel[] = $item;
        return $this;
    }
    /**
     * Get DirectResponsibility value
     * @return \StructType\CustomerReponseCustomerDirectResponsibility[]|null
     */
    public function getDirectResponsibility()
    {
        return $this->DirectResponsibility;
    }
    /**
     * This method is responsible for validating the values passed to the setDirectResponsibility method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDirectResponsibility method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDirectResponsibilityForArrayConstraintsFromSetDirectResponsibility(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerDirectResponsibilityItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerDirectResponsibilityItem instanceof \StructType\CustomerReponseCustomerDirectResponsibility) {
                $invalidValues[] = is_object($customerReponseCustomerDirectResponsibilityItem) ? get_class($customerReponseCustomerDirectResponsibilityItem) : sprintf('%s(%s)', gettype($customerReponseCustomerDirectResponsibilityItem), var_export($customerReponseCustomerDirectResponsibilityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DirectResponsibility property can only contain items of type \StructType\CustomerReponseCustomerDirectResponsibility, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DirectResponsibility value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerDirectResponsibility[] $directResponsibility
     * @return \StructType\CustomerReponseCustomer
     */
    public function setDirectResponsibility(array $directResponsibility = array())
    {
        // validation for constraint: array
        if ('' !== ($directResponsibilityArrayErrorMessage = self::validateDirectResponsibilityForArrayConstraintsFromSetDirectResponsibility($directResponsibility))) {
            throw new \InvalidArgumentException($directResponsibilityArrayErrorMessage, __LINE__);
        }
        $this->DirectResponsibility = $directResponsibility;
        return $this;
    }
    /**
     * Add item to DirectResponsibility value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerDirectResponsibility $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToDirectResponsibility(\StructType\CustomerReponseCustomerDirectResponsibility $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerDirectResponsibility) {
            throw new \InvalidArgumentException(sprintf('The DirectResponsibility property can only contain items of type \StructType\CustomerReponseCustomerDirectResponsibility, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DirectResponsibility[] = $item;
        return $this;
    }
    /**
     * Get SalesArrangement value
     * @return \StructType\CustomerReponseCustomerSalesArrangement[]|null
     */
    public function getSalesArrangement()
    {
        return $this->SalesArrangement;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesArrangement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesArrangement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesArrangementForArrayConstraintsFromSetSalesArrangement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerSalesArrangementItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerSalesArrangementItem instanceof \StructType\CustomerReponseCustomerSalesArrangement) {
                $invalidValues[] = is_object($customerReponseCustomerSalesArrangementItem) ? get_class($customerReponseCustomerSalesArrangementItem) : sprintf('%s(%s)', gettype($customerReponseCustomerSalesArrangementItem), var_export($customerReponseCustomerSalesArrangementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesArrangement property can only contain items of type \StructType\CustomerReponseCustomerSalesArrangement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesArrangement value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerSalesArrangement[] $salesArrangement
     * @return \StructType\CustomerReponseCustomer
     */
    public function setSalesArrangement(array $salesArrangement = array())
    {
        // validation for constraint: array
        if ('' !== ($salesArrangementArrayErrorMessage = self::validateSalesArrangementForArrayConstraintsFromSetSalesArrangement($salesArrangement))) {
            throw new \InvalidArgumentException($salesArrangementArrayErrorMessage, __LINE__);
        }
        $this->SalesArrangement = $salesArrangement;
        return $this;
    }
    /**
     * Add item to SalesArrangement value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerSalesArrangement $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToSalesArrangement(\StructType\CustomerReponseCustomerSalesArrangement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerSalesArrangement) {
            throw new \InvalidArgumentException(sprintf('The SalesArrangement property can only contain items of type \StructType\CustomerReponseCustomerSalesArrangement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesArrangement[] = $item;
        return $this;
    }
    /**
     * Get InvoicingBlockingReasonCode value
     * @return string|null
     */
    public function getInvoicingBlockingReasonCode()
    {
        return $this->InvoicingBlockingReasonCode;
    }
    /**
     * Set InvoicingBlockingReasonCode value
     * @param string $invoicingBlockingReasonCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setInvoicingBlockingReasonCode($invoicingBlockingReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoicingBlockingReasonCode) && !is_string($invoicingBlockingReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicingBlockingReasonCode, true), gettype($invoicingBlockingReasonCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($invoicingBlockingReasonCode) && mb_strlen($invoicingBlockingReasonCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($invoicingBlockingReasonCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($invoicingBlockingReasonCode) && mb_strlen($invoicingBlockingReasonCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($invoicingBlockingReasonCode)), __LINE__);
        }
        $this->InvoicingBlockingReasonCode = $invoicingBlockingReasonCode;
        return $this;
    }
    /**
     * Get CustomerTransactionDocumentFulfilmentBlockingReasonCode value
     * @return string|null
     */
    public function getCustomerTransactionDocumentFulfilmentBlockingReasonCode()
    {
        return $this->CustomerTransactionDocumentFulfilmentBlockingReasonCode;
    }
    /**
     * Set CustomerTransactionDocumentFulfilmentBlockingReasonCode value
     * @param string $customerTransactionDocumentFulfilmentBlockingReasonCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCustomerTransactionDocumentFulfilmentBlockingReasonCode($customerTransactionDocumentFulfilmentBlockingReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerTransactionDocumentFulfilmentBlockingReasonCode) && !is_string($customerTransactionDocumentFulfilmentBlockingReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerTransactionDocumentFulfilmentBlockingReasonCode, true), gettype($customerTransactionDocumentFulfilmentBlockingReasonCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($customerTransactionDocumentFulfilmentBlockingReasonCode) && mb_strlen($customerTransactionDocumentFulfilmentBlockingReasonCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($customerTransactionDocumentFulfilmentBlockingReasonCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerTransactionDocumentFulfilmentBlockingReasonCode) && mb_strlen($customerTransactionDocumentFulfilmentBlockingReasonCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerTransactionDocumentFulfilmentBlockingReasonCode)), __LINE__);
        }
        $this->CustomerTransactionDocumentFulfilmentBlockingReasonCode = $customerTransactionDocumentFulfilmentBlockingReasonCode;
        return $this;
    }
    /**
     * Get CustomerBlockingReasonCode value
     * @return string|null
     */
    public function getCustomerBlockingReasonCode()
    {
        return $this->CustomerBlockingReasonCode;
    }
    /**
     * Set CustomerBlockingReasonCode value
     * @param string $customerBlockingReasonCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCustomerBlockingReasonCode($customerBlockingReasonCode = null)
    {
        // validation for constraint: string
        if (!is_null($customerBlockingReasonCode) && !is_string($customerBlockingReasonCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerBlockingReasonCode, true), gettype($customerBlockingReasonCode)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($customerBlockingReasonCode) && mb_strlen($customerBlockingReasonCode) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($customerBlockingReasonCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($customerBlockingReasonCode) && mb_strlen($customerBlockingReasonCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($customerBlockingReasonCode)), __LINE__);
        }
        $this->CustomerBlockingReasonCode = $customerBlockingReasonCode;
        return $this;
    }
    /**
     * Get BankDetails value
     * @return \StructType\CustomerReponseCustomerBankDetails[]|null
     */
    public function getBankDetails()
    {
        return $this->BankDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setBankDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBankDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBankDetailsForArrayConstraintsFromSetBankDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerBankDetailsItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerBankDetailsItem instanceof \StructType\CustomerReponseCustomerBankDetails) {
                $invalidValues[] = is_object($customerReponseCustomerBankDetailsItem) ? get_class($customerReponseCustomerBankDetailsItem) : sprintf('%s(%s)', gettype($customerReponseCustomerBankDetailsItem), var_export($customerReponseCustomerBankDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BankDetails property can only contain items of type \StructType\CustomerReponseCustomerBankDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BankDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerBankDetails[] $bankDetails
     * @return \StructType\CustomerReponseCustomer
     */
    public function setBankDetails(array $bankDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($bankDetailsArrayErrorMessage = self::validateBankDetailsForArrayConstraintsFromSetBankDetails($bankDetails))) {
            throw new \InvalidArgumentException($bankDetailsArrayErrorMessage, __LINE__);
        }
        $this->BankDetails = $bankDetails;
        return $this;
    }
    /**
     * Add item to BankDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerBankDetails $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToBankDetails(\StructType\CustomerReponseCustomerBankDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerBankDetails) {
            throw new \InvalidArgumentException(sprintf('The BankDetails property can only contain items of type \StructType\CustomerReponseCustomerBankDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BankDetails[] = $item;
        return $this;
    }
    /**
     * Get PaymentCardDetails value
     * @return \StructType\CustomerReponseCustomerPaymentCardDetails[]|null
     */
    public function getPaymentCardDetails()
    {
        return $this->PaymentCardDetails;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCardDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCardDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCardDetailsForArrayConstraintsFromSetPaymentCardDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerPaymentCardDetailsItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerPaymentCardDetailsItem instanceof \StructType\CustomerReponseCustomerPaymentCardDetails) {
                $invalidValues[] = is_object($customerReponseCustomerPaymentCardDetailsItem) ? get_class($customerReponseCustomerPaymentCardDetailsItem) : sprintf('%s(%s)', gettype($customerReponseCustomerPaymentCardDetailsItem), var_export($customerReponseCustomerPaymentCardDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentCardDetails property can only contain items of type \StructType\CustomerReponseCustomerPaymentCardDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCardDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerPaymentCardDetails[] $paymentCardDetails
     * @return \StructType\CustomerReponseCustomer
     */
    public function setPaymentCardDetails(array $paymentCardDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentCardDetailsArrayErrorMessage = self::validatePaymentCardDetailsForArrayConstraintsFromSetPaymentCardDetails($paymentCardDetails))) {
            throw new \InvalidArgumentException($paymentCardDetailsArrayErrorMessage, __LINE__);
        }
        $this->PaymentCardDetails = $paymentCardDetails;
        return $this;
    }
    /**
     * Add item to PaymentCardDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerPaymentCardDetails $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToPaymentCardDetails(\StructType\CustomerReponseCustomerPaymentCardDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerPaymentCardDetails) {
            throw new \InvalidArgumentException(sprintf('The PaymentCardDetails property can only contain items of type \StructType\CustomerReponseCustomerPaymentCardDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentCardDetails[] = $item;
        return $this;
    }
    /**
     * Get PaymentData value
     * @return \StructType\CustomerReponseCustomerPaymentData[]|null
     */
    public function getPaymentData()
    {
        return $this->PaymentData;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentDataForArrayConstraintsFromSetPaymentData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerPaymentDataItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerPaymentDataItem instanceof \StructType\CustomerReponseCustomerPaymentData) {
                $invalidValues[] = is_object($customerReponseCustomerPaymentDataItem) ? get_class($customerReponseCustomerPaymentDataItem) : sprintf('%s(%s)', gettype($customerReponseCustomerPaymentDataItem), var_export($customerReponseCustomerPaymentDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentData property can only contain items of type \StructType\CustomerReponseCustomerPaymentData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentData value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerPaymentData[] $paymentData
     * @return \StructType\CustomerReponseCustomer
     */
    public function setPaymentData(array $paymentData = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentDataArrayErrorMessage = self::validatePaymentDataForArrayConstraintsFromSetPaymentData($paymentData))) {
            throw new \InvalidArgumentException($paymentDataArrayErrorMessage, __LINE__);
        }
        $this->PaymentData = $paymentData;
        return $this;
    }
    /**
     * Add item to PaymentData value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerPaymentData $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToPaymentData(\StructType\CustomerReponseCustomerPaymentData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerPaymentData) {
            throw new \InvalidArgumentException(sprintf('The PaymentData property can only contain items of type \StructType\CustomerReponseCustomerPaymentData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentData[] = $item;
        return $this;
    }
    /**
     * Get TaxNumber value
     * @return \StructType\CustomerReponseCustomerTaxNumber[]|null
     */
    public function getTaxNumber()
    {
        return $this->TaxNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxNumberForArrayConstraintsFromSetTaxNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerTaxNumberItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerTaxNumberItem instanceof \StructType\CustomerReponseCustomerTaxNumber) {
                $invalidValues[] = is_object($customerReponseCustomerTaxNumberItem) ? get_class($customerReponseCustomerTaxNumberItem) : sprintf('%s(%s)', gettype($customerReponseCustomerTaxNumberItem), var_export($customerReponseCustomerTaxNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxNumber property can only contain items of type \StructType\CustomerReponseCustomerTaxNumber, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerTaxNumber[] $taxNumber
     * @return \StructType\CustomerReponseCustomer
     */
    public function setTaxNumber(array $taxNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($taxNumberArrayErrorMessage = self::validateTaxNumberForArrayConstraintsFromSetTaxNumber($taxNumber))) {
            throw new \InvalidArgumentException($taxNumberArrayErrorMessage, __LINE__);
        }
        $this->TaxNumber = $taxNumber;
        return $this;
    }
    /**
     * Add item to TaxNumber value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerTaxNumber $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToTaxNumber(\StructType\CustomerReponseCustomerTaxNumber $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerTaxNumber) {
            throw new \InvalidArgumentException(sprintf('The TaxNumber property can only contain items of type \StructType\CustomerReponseCustomerTaxNumber, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxNumber[] = $item;
        return $this;
    }
    /**
     * Get GeneralProductTaxExemption value
     * @return \StructType\CustomerReponseCustomerGeneralProductTaxExemption[]|null
     */
    public function getGeneralProductTaxExemption()
    {
        return $this->GeneralProductTaxExemption;
    }
    /**
     * This method is responsible for validating the values passed to the setGeneralProductTaxExemption method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGeneralProductTaxExemption method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGeneralProductTaxExemptionForArrayConstraintsFromSetGeneralProductTaxExemption(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerGeneralProductTaxExemptionItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerGeneralProductTaxExemptionItem instanceof \StructType\CustomerReponseCustomerGeneralProductTaxExemption) {
                $invalidValues[] = is_object($customerReponseCustomerGeneralProductTaxExemptionItem) ? get_class($customerReponseCustomerGeneralProductTaxExemptionItem) : sprintf('%s(%s)', gettype($customerReponseCustomerGeneralProductTaxExemptionItem), var_export($customerReponseCustomerGeneralProductTaxExemptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GeneralProductTaxExemption property can only contain items of type \StructType\CustomerReponseCustomerGeneralProductTaxExemption, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GeneralProductTaxExemption value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerGeneralProductTaxExemption[] $generalProductTaxExemption
     * @return \StructType\CustomerReponseCustomer
     */
    public function setGeneralProductTaxExemption(array $generalProductTaxExemption = array())
    {
        // validation for constraint: array
        if ('' !== ($generalProductTaxExemptionArrayErrorMessage = self::validateGeneralProductTaxExemptionForArrayConstraintsFromSetGeneralProductTaxExemption($generalProductTaxExemption))) {
            throw new \InvalidArgumentException($generalProductTaxExemptionArrayErrorMessage, __LINE__);
        }
        $this->GeneralProductTaxExemption = $generalProductTaxExemption;
        return $this;
    }
    /**
     * Add item to GeneralProductTaxExemption value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerGeneralProductTaxExemption $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToGeneralProductTaxExemption(\StructType\CustomerReponseCustomerGeneralProductTaxExemption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerGeneralProductTaxExemption) {
            throw new \InvalidArgumentException(sprintf('The GeneralProductTaxExemption property can only contain items of type \StructType\CustomerReponseCustomerGeneralProductTaxExemption, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GeneralProductTaxExemption[] = $item;
        return $this;
    }
    /**
     * Get TaxExemptionCertificate value
     * @return \StructType\CustomerResponseCustomerTaxExemptionCertificate[]|null
     */
    public function getTaxExemptionCertificate()
    {
        return $this->TaxExemptionCertificate;
    }
    /**
     * This method is responsible for validating the values passed to the setTaxExemptionCertificate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTaxExemptionCertificate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTaxExemptionCertificateForArrayConstraintsFromSetTaxExemptionCertificate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerTaxExemptionCertificateItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerTaxExemptionCertificateItem instanceof \StructType\CustomerResponseCustomerTaxExemptionCertificate) {
                $invalidValues[] = is_object($customerReponseCustomerTaxExemptionCertificateItem) ? get_class($customerReponseCustomerTaxExemptionCertificateItem) : sprintf('%s(%s)', gettype($customerReponseCustomerTaxExemptionCertificateItem), var_export($customerReponseCustomerTaxExemptionCertificateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TaxExemptionCertificate property can only contain items of type \StructType\CustomerResponseCustomerTaxExemptionCertificate, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TaxExemptionCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerResponseCustomerTaxExemptionCertificate[] $taxExemptionCertificate
     * @return \StructType\CustomerReponseCustomer
     */
    public function setTaxExemptionCertificate(array $taxExemptionCertificate = array())
    {
        // validation for constraint: array
        if ('' !== ($taxExemptionCertificateArrayErrorMessage = self::validateTaxExemptionCertificateForArrayConstraintsFromSetTaxExemptionCertificate($taxExemptionCertificate))) {
            throw new \InvalidArgumentException($taxExemptionCertificateArrayErrorMessage, __LINE__);
        }
        $this->TaxExemptionCertificate = $taxExemptionCertificate;
        return $this;
    }
    /**
     * Add item to TaxExemptionCertificate value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerResponseCustomerTaxExemptionCertificate $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToTaxExemptionCertificate(\StructType\CustomerResponseCustomerTaxExemptionCertificate $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerResponseCustomerTaxExemptionCertificate) {
            throw new \InvalidArgumentException(sprintf('The TaxExemptionCertificate property can only contain items of type \StructType\CustomerResponseCustomerTaxExemptionCertificate, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TaxExemptionCertificate[] = $item;
        return $this;
    }
    /**
     * Get OperatingHoursInformation value
     * @return \StructType\CustomerReponseCustomerOperatingHoursInformation[]|null
     */
    public function getOperatingHoursInformation()
    {
        return $this->OperatingHoursInformation;
    }
    /**
     * This method is responsible for validating the values passed to the setOperatingHoursInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperatingHoursInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperatingHoursInformationForArrayConstraintsFromSetOperatingHoursInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerOperatingHoursInformationItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerOperatingHoursInformationItem instanceof \StructType\CustomerReponseCustomerOperatingHoursInformation) {
                $invalidValues[] = is_object($customerReponseCustomerOperatingHoursInformationItem) ? get_class($customerReponseCustomerOperatingHoursInformationItem) : sprintf('%s(%s)', gettype($customerReponseCustomerOperatingHoursInformationItem), var_export($customerReponseCustomerOperatingHoursInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperatingHoursInformation property can only contain items of type \StructType\CustomerReponseCustomerOperatingHoursInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperatingHoursInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerOperatingHoursInformation[] $operatingHoursInformation
     * @return \StructType\CustomerReponseCustomer
     */
    public function setOperatingHoursInformation(array $operatingHoursInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($operatingHoursInformationArrayErrorMessage = self::validateOperatingHoursInformationForArrayConstraintsFromSetOperatingHoursInformation($operatingHoursInformation))) {
            throw new \InvalidArgumentException($operatingHoursInformationArrayErrorMessage, __LINE__);
        }
        $this->OperatingHoursInformation = $operatingHoursInformation;
        return $this;
    }
    /**
     * Add item to OperatingHoursInformation value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerOperatingHoursInformation $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToOperatingHoursInformation(\StructType\CustomerReponseCustomerOperatingHoursInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerOperatingHoursInformation) {
            throw new \InvalidArgumentException(sprintf('The OperatingHoursInformation property can only contain items of type \StructType\CustomerReponseCustomerOperatingHoursInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OperatingHoursInformation[] = $item;
        return $this;
    }
    /**
     * Get Text value
     * @return \StructType\CustomerReponseCustomerText[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * This method is responsible for validating the values passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForArrayConstraintsFromSetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $customerReponseCustomerTextItem) {
            // validation for constraint: itemType
            if (!$customerReponseCustomerTextItem instanceof \StructType\CustomerReponseCustomerText) {
                $invalidValues[] = is_object($customerReponseCustomerTextItem) ? get_class($customerReponseCustomerTextItem) : sprintf('%s(%s)', gettype($customerReponseCustomerTextItem), var_export($customerReponseCustomerTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Text property can only contain items of type \StructType\CustomerReponseCustomerText, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerText[] $text
     * @return \StructType\CustomerReponseCustomer
     */
    public function setText(array $text = array())
    {
        // validation for constraint: array
        if ('' !== ($textArrayErrorMessage = self::validateTextForArrayConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textArrayErrorMessage, __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param \StructType\CustomerReponseCustomerText $item
     * @return \StructType\CustomerReponseCustomer
     */
    public function addToText(\StructType\CustomerReponseCustomerText $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CustomerReponseCustomerText) {
            throw new \InvalidArgumentException(sprintf('The Text property can only contain items of type \StructType\CustomerReponseCustomerText, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get AttachmentFolder value
     * @return \StructType\AccessAttachmentFolder|null
     */
    public function getAttachmentFolder()
    {
        return $this->AttachmentFolder;
    }
    /**
     * Set AttachmentFolder value
     * @param \StructType\AccessAttachmentFolder $attachmentFolder
     * @return \StructType\CustomerReponseCustomer
     */
    public function setAttachmentFolder(\StructType\AccessAttachmentFolder $attachmentFolder = null)
    {
        $this->AttachmentFolder = $attachmentFolder;
        return $this;
    }
    /**
     * Get EnterpriseIdentificationNumber value
     * @return string|null
     */
    public function getEnterpriseIdentificationNumber()
    {
        return $this->EnterpriseIdentificationNumber;
    }
    /**
     * Set EnterpriseIdentificationNumber value
     * @param string $enterpriseIdentificationNumber
     * @return \StructType\CustomerReponseCustomer
     */
    public function setEnterpriseIdentificationNumber($enterpriseIdentificationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($enterpriseIdentificationNumber) && !is_string($enterpriseIdentificationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enterpriseIdentificationNumber, true), gettype($enterpriseIdentificationNumber)), __LINE__);
        }
        // validation for constraint: maxLength(60)
        if (!is_null($enterpriseIdentificationNumber) && mb_strlen($enterpriseIdentificationNumber) > 60) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 60', mb_strlen($enterpriseIdentificationNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($enterpriseIdentificationNumber) && mb_strlen($enterpriseIdentificationNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($enterpriseIdentificationNumber)), __LINE__);
        }
        $this->EnterpriseIdentificationNumber = $enterpriseIdentificationNumber;
        return $this;
    }
    /**
     * Get TaxPayerCategoryCode value
     * @return \StructType\TaxPayerCategoryCode|null
     */
    public function getTaxPayerCategoryCode()
    {
        return $this->TaxPayerCategoryCode;
    }
    /**
     * Set TaxPayerCategoryCode value
     * @param \StructType\TaxPayerCategoryCode $taxPayerCategoryCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setTaxPayerCategoryCode(\StructType\TaxPayerCategoryCode $taxPayerCategoryCode = null)
    {
        $this->TaxPayerCategoryCode = $taxPayerCategoryCode;
        return $this;
    }
    /**
     * Get EnterpriseIdentificationSupplementCode value
     * @return string|null
     */
    public function getEnterpriseIdentificationSupplementCode()
    {
        return $this->EnterpriseIdentificationSupplementCode;
    }
    /**
     * Set EnterpriseIdentificationSupplementCode value
     * @param string $enterpriseIdentificationSupplementCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setEnterpriseIdentificationSupplementCode($enterpriseIdentificationSupplementCode = null)
    {
        // validation for constraint: string
        if (!is_null($enterpriseIdentificationSupplementCode) && !is_string($enterpriseIdentificationSupplementCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enterpriseIdentificationSupplementCode, true), gettype($enterpriseIdentificationSupplementCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($enterpriseIdentificationSupplementCode) && mb_strlen($enterpriseIdentificationSupplementCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($enterpriseIdentificationSupplementCode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($enterpriseIdentificationSupplementCode) && mb_strlen($enterpriseIdentificationSupplementCode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($enterpriseIdentificationSupplementCode)), __LINE__);
        }
        $this->EnterpriseIdentificationSupplementCode = $enterpriseIdentificationSupplementCode;
        return $this;
    }
    /**
     * Get InvoiceSummaryRoleCode value
     * @return \StructType\JP_LogisticsInvoiceSummaryBusinessPartnerTypeCode|null
     */
    public function getInvoiceSummaryRoleCode()
    {
        return $this->InvoiceSummaryRoleCode;
    }
    /**
     * Set InvoiceSummaryRoleCode value
     * @param \StructType\JP_LogisticsInvoiceSummaryBusinessPartnerTypeCode $invoiceSummaryRoleCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setInvoiceSummaryRoleCode(\StructType\JP_LogisticsInvoiceSummaryBusinessPartnerTypeCode $invoiceSummaryRoleCode = null)
    {
        $this->InvoiceSummaryRoleCode = $invoiceSummaryRoleCode;
        return $this;
    }
    /**
     * Get ClosingDatePatternID value
     * @return string|null
     */
    public function getClosingDatePatternID()
    {
        return $this->ClosingDatePatternID;
    }
    /**
     * Set ClosingDatePatternID value
     * @param string $closingDatePatternID
     * @return \StructType\CustomerReponseCustomer
     */
    public function setClosingDatePatternID($closingDatePatternID = null)
    {
        // validation for constraint: string
        if (!is_null($closingDatePatternID) && !is_string($closingDatePatternID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($closingDatePatternID, true), gettype($closingDatePatternID)), __LINE__);
        }
        // validation for constraint: maxLength(4)
        if (!is_null($closingDatePatternID) && mb_strlen($closingDatePatternID) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 4', mb_strlen($closingDatePatternID)), __LINE__);
        }
        $this->ClosingDatePatternID = $closingDatePatternID;
        return $this;
    }
    /**
     * Get MxUseCfdiCode value
     * @return string|null
     */
    public function getMxUseCfdiCode()
    {
        return $this->MxUseCfdiCode;
    }
    /**
     * Set MxUseCfdiCode value
     * @param string $mxUseCfdiCode
     * @return \StructType\CustomerReponseCustomer
     */
    public function setMxUseCfdiCode($mxUseCfdiCode = null)
    {
        // validation for constraint: string
        if (!is_null($mxUseCfdiCode) && !is_string($mxUseCfdiCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mxUseCfdiCode, true), gettype($mxUseCfdiCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($mxUseCfdiCode) && mb_strlen($mxUseCfdiCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($mxUseCfdiCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($mxUseCfdiCode) && mb_strlen($mxUseCfdiCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($mxUseCfdiCode)), __LINE__);
        }
        $this->MxUseCfdiCode = $mxUseCfdiCode;
        return $this;
    }
    /**
     * Get CustomerTCSIndicator value
     * @return bool|null
     */
    public function getCustomerTCSIndicator()
    {
        return $this->CustomerTCSIndicator;
    }
    /**
     * Set CustomerTCSIndicator value
     * @param bool $customerTCSIndicator
     * @return \StructType\CustomerReponseCustomer
     */
    public function setCustomerTCSIndicator($customerTCSIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($customerTCSIndicator) && !is_bool($customerTCSIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customerTCSIndicator, true), gettype($customerTCSIndicator)), __LINE__);
        }
        $this->CustomerTCSIndicator = $customerTCSIndicator;
        return $this;
    }
}
