<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amount StructType
 * Meta information extracted from the WSDL
 * - documentation: Amount
 * - base: xsd:decimal
 * - fractionDigits: 6
 * - maxInclusive: 9999999999999999999999.999999
 * - minInclusive: -9999999999999999999999.999999
 * - totalDigits: 28
 * @subpackage Structs
 */
class Amount extends AbstractStructBase
{
    /**
     * The currencyCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 3
     * - minLength: 3
     * - use: required
     * @var string
     */
    public $currencyCode;
    /**
     * The _
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 6
     * - maxInclusive: 9999999999999999999999.999999
     * - minInclusive: -9999999999999999999999.999999
     * - totalDigits: 28
     * @var float
     */
    public $_;
    /**
     * Constructor method for Amount
     * @uses Amount::setCurrencyCode()
     * @uses Amount::set_()
     * @param string $currencyCode
     * @param float $_
     */
    public function __construct($currencyCode = null, $_ = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->set_($_);
    }
    /**
     * Get currencyCode value
     * @return string
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \StructType\Amount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        // validation for constraint: maxLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        // validation for constraint: minLength(3)
        if (!is_null($currencyCode) && mb_strlen($currencyCode) < 3) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 3', mb_strlen($currencyCode)), __LINE__);
        }
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get _ value
     * @return float|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param float $_
     * @return \StructType\Amount
     */
    public function set_($_ = null)
    {
        // validation for constraint: float
        if (!is_null($_) && !(is_float($_) || is_numeric($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: fractionDigits(6)
        if (!is_null($_) && mb_strlen(mb_substr($_, false !== mb_strpos($_, '.') ? mb_strpos($_, '.') + 1 : mb_strlen($_))) > 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 6 fraction digits, %d given', var_export($_, true), mb_strlen(mb_substr($_, mb_strpos($_, '.') + 1))), __LINE__);
        }
        // validation for constraint: maxInclusive(9999999999999999999999.999999)
        if (!is_null($_) && $_ > 9999999999999999999999.999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999999999999999999999.999999', var_export($_, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-9999999999999999999999.999999)
        if (!is_null($_) && $_ < -9999999999999999999999.999999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to -9999999999999999999999.999999', var_export($_, true)), __LINE__);
        }
        // validation for constraint: totalDigits(28)
        if (!is_null($_) && mb_strlen(preg_replace('/(\D)/', '', $_)) > 28) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 28 digits, "%d" given', var_export($_, true), mb_strlen(preg_replace('/(\D)/', '', $_))), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
}
