<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessAttachmentFolderDocumentPropertyPropertyValue
 * StructType
 * @subpackage Structs
 */
class AccessAttachmentFolderDocumentPropertyPropertyValue extends AbstractStructBase
{
    /**
     * The TechnicalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 70
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TechnicalID;
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Text
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Indicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $Indicator;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - documentation: DateTime
     * - base: xsd:dateTime
     * - minOccurs: 0
     * - pattern: [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z
     * @var string
     */
    public $DateTime;
    /**
     * The IntegerValue
     * Meta information extracted from the WSDL
     * - documentation: Value
     * - base: xsd:int
     * - minOccurs: 0
     * @var int
     */
    public $IntegerValue;
    /**
     * Constructor method for AccessAttachmentFolderDocumentPropertyPropertyValue
     * @uses AccessAttachmentFolderDocumentPropertyPropertyValue::setTechnicalID()
     * @uses AccessAttachmentFolderDocumentPropertyPropertyValue::setText()
     * @uses AccessAttachmentFolderDocumentPropertyPropertyValue::setIndicator()
     * @uses AccessAttachmentFolderDocumentPropertyPropertyValue::setDateTime()
     * @uses AccessAttachmentFolderDocumentPropertyPropertyValue::setIntegerValue()
     * @param string $technicalID
     * @param string $text
     * @param bool $indicator
     * @param string $dateTime
     * @param int $integerValue
     */
    public function __construct($technicalID = null, $text = null, $indicator = null, $dateTime = null, $integerValue = null)
    {
        $this
            ->setTechnicalID($technicalID)
            ->setText($text)
            ->setIndicator($indicator)
            ->setDateTime($dateTime)
            ->setIntegerValue($integerValue);
    }
    /**
     * Get TechnicalID value
     * @return string|null
     */
    public function getTechnicalID()
    {
        return $this->TechnicalID;
    }
    /**
     * Set TechnicalID value
     * @param string $technicalID
     * @return \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue
     */
    public function setTechnicalID($technicalID = null)
    {
        // validation for constraint: string
        if (!is_null($technicalID) && !is_string($technicalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($technicalID, true), gettype($technicalID)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($technicalID) && mb_strlen($technicalID) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($technicalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($technicalID) && mb_strlen($technicalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($technicalID)), __LINE__);
        }
        $this->TechnicalID = $technicalID;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Indicator value
     * @return bool|null
     */
    public function getIndicator()
    {
        return $this->Indicator;
    }
    /**
     * Set Indicator value
     * @param bool $indicator
     * @return \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue
     */
    public function setIndicator($indicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($indicator) && !is_bool($indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($indicator, true), gettype($indicator)), __LINE__);
        }
        $this->Indicator = $indicator;
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z)
        if (!is_null($dateTime) && !preg_match('/[0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z/', $dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}(.[0-9]{1,7})?Z', var_export($dateTime, true)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get IntegerValue value
     * @return int|null
     */
    public function getIntegerValue()
    {
        return $this->IntegerValue;
    }
    /**
     * Set IntegerValue value
     * @param int $integerValue
     * @return \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue
     */
    public function setIntegerValue($integerValue = null)
    {
        // validation for constraint: int
        if (!is_null($integerValue) && !(is_int($integerValue) || ctype_digit($integerValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integerValue, true), gettype($integerValue)), __LINE__);
        }
        $this->IntegerValue = $integerValue;
        return $this;
    }
}
