<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessAttachmentFolderDocumentProperty StructType
 * @subpackage Structs
 */
class AccessAttachmentFolderDocumentProperty extends AbstractStructBase
{
    /**
     * The TechnicalID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 70
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TechnicalID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The DataTypeFormatCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - maxLength: 10
     * - minOccurs: 0
     * @var string
     */
    public $DataTypeFormatCode;
    /**
     * The DataTypeFormatName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $DataTypeFormatName;
    /**
     * The VisibleIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $VisibleIndicator;
    /**
     * The ChangeAllowedIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $ChangeAllowedIndicator;
    /**
     * The MultipleValueIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $MultipleValueIndicator;
    /**
     * The NamespaceURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NamespaceURI
     */
    public $NamespaceURI;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The PropertyValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue[]
     */
    public $PropertyValue;
    /**
     * Constructor method for AccessAttachmentFolderDocumentProperty
     * @uses AccessAttachmentFolderDocumentProperty::setTechnicalID()
     * @uses AccessAttachmentFolderDocumentProperty::setName()
     * @uses AccessAttachmentFolderDocumentProperty::setDataTypeFormatCode()
     * @uses AccessAttachmentFolderDocumentProperty::setDataTypeFormatName()
     * @uses AccessAttachmentFolderDocumentProperty::setVisibleIndicator()
     * @uses AccessAttachmentFolderDocumentProperty::setChangeAllowedIndicator()
     * @uses AccessAttachmentFolderDocumentProperty::setMultipleValueIndicator()
     * @uses AccessAttachmentFolderDocumentProperty::setNamespaceURI()
     * @uses AccessAttachmentFolderDocumentProperty::setDescription()
     * @uses AccessAttachmentFolderDocumentProperty::setPropertyValue()
     * @param string $technicalID
     * @param string $name
     * @param string $dataTypeFormatCode
     * @param string $dataTypeFormatName
     * @param bool $visibleIndicator
     * @param bool $changeAllowedIndicator
     * @param bool $multipleValueIndicator
     * @param \StructType\NamespaceURI $namespaceURI
     * @param \StructType\Description $description
     * @param \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue[] $propertyValue
     */
    public function __construct($technicalID = null, $name = null, $dataTypeFormatCode = null, $dataTypeFormatName = null, $visibleIndicator = null, $changeAllowedIndicator = null, $multipleValueIndicator = null, \StructType\NamespaceURI $namespaceURI = null, \StructType\Description $description = null, array $propertyValue = array())
    {
        $this
            ->setTechnicalID($technicalID)
            ->setName($name)
            ->setDataTypeFormatCode($dataTypeFormatCode)
            ->setDataTypeFormatName($dataTypeFormatName)
            ->setVisibleIndicator($visibleIndicator)
            ->setChangeAllowedIndicator($changeAllowedIndicator)
            ->setMultipleValueIndicator($multipleValueIndicator)
            ->setNamespaceURI($namespaceURI)
            ->setDescription($description)
            ->setPropertyValue($propertyValue);
    }
    /**
     * Get TechnicalID value
     * @return string|null
     */
    public function getTechnicalID()
    {
        return $this->TechnicalID;
    }
    /**
     * Set TechnicalID value
     * @param string $technicalID
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setTechnicalID($technicalID = null)
    {
        // validation for constraint: string
        if (!is_null($technicalID) && !is_string($technicalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($technicalID, true), gettype($technicalID)), __LINE__);
        }
        // validation for constraint: maxLength(70)
        if (!is_null($technicalID) && mb_strlen($technicalID) > 70) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 70', mb_strlen($technicalID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($technicalID) && mb_strlen($technicalID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($technicalID)), __LINE__);
        }
        $this->TechnicalID = $technicalID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DataTypeFormatCode value
     * @return string|null
     */
    public function getDataTypeFormatCode()
    {
        return $this->DataTypeFormatCode;
    }
    /**
     * Set DataTypeFormatCode value
     * @param string $dataTypeFormatCode
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setDataTypeFormatCode($dataTypeFormatCode = null)
    {
        // validation for constraint: string
        if (!is_null($dataTypeFormatCode) && !is_string($dataTypeFormatCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTypeFormatCode, true), gettype($dataTypeFormatCode)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($dataTypeFormatCode) && mb_strlen($dataTypeFormatCode) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($dataTypeFormatCode)), __LINE__);
        }
        $this->DataTypeFormatCode = $dataTypeFormatCode;
        return $this;
    }
    /**
     * Get DataTypeFormatName value
     * @return string|null
     */
    public function getDataTypeFormatName()
    {
        return $this->DataTypeFormatName;
    }
    /**
     * Set DataTypeFormatName value
     * @param string $dataTypeFormatName
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setDataTypeFormatName($dataTypeFormatName = null)
    {
        // validation for constraint: string
        if (!is_null($dataTypeFormatName) && !is_string($dataTypeFormatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTypeFormatName, true), gettype($dataTypeFormatName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($dataTypeFormatName) && mb_strlen($dataTypeFormatName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($dataTypeFormatName)), __LINE__);
        }
        $this->DataTypeFormatName = $dataTypeFormatName;
        return $this;
    }
    /**
     * Get VisibleIndicator value
     * @return bool|null
     */
    public function getVisibleIndicator()
    {
        return $this->VisibleIndicator;
    }
    /**
     * Set VisibleIndicator value
     * @param bool $visibleIndicator
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setVisibleIndicator($visibleIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleIndicator) && !is_bool($visibleIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleIndicator, true), gettype($visibleIndicator)), __LINE__);
        }
        $this->VisibleIndicator = $visibleIndicator;
        return $this;
    }
    /**
     * Get ChangeAllowedIndicator value
     * @return bool|null
     */
    public function getChangeAllowedIndicator()
    {
        return $this->ChangeAllowedIndicator;
    }
    /**
     * Set ChangeAllowedIndicator value
     * @param bool $changeAllowedIndicator
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setChangeAllowedIndicator($changeAllowedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($changeAllowedIndicator) && !is_bool($changeAllowedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($changeAllowedIndicator, true), gettype($changeAllowedIndicator)), __LINE__);
        }
        $this->ChangeAllowedIndicator = $changeAllowedIndicator;
        return $this;
    }
    /**
     * Get MultipleValueIndicator value
     * @return bool|null
     */
    public function getMultipleValueIndicator()
    {
        return $this->MultipleValueIndicator;
    }
    /**
     * Set MultipleValueIndicator value
     * @param bool $multipleValueIndicator
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setMultipleValueIndicator($multipleValueIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($multipleValueIndicator) && !is_bool($multipleValueIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multipleValueIndicator, true), gettype($multipleValueIndicator)), __LINE__);
        }
        $this->MultipleValueIndicator = $multipleValueIndicator;
        return $this;
    }
    /**
     * Get NamespaceURI value
     * @return \StructType\NamespaceURI|null
     */
    public function getNamespaceURI()
    {
        return $this->NamespaceURI;
    }
    /**
     * Set NamespaceURI value
     * @param \StructType\NamespaceURI $namespaceURI
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setNamespaceURI(\StructType\NamespaceURI $namespaceURI = null)
    {
        $this->NamespaceURI = $namespaceURI;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PropertyValue value
     * @return \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue[]|null
     */
    public function getPropertyValue()
    {
        return $this->PropertyValue;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyValueForArrayConstraintsFromSetPropertyValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accessAttachmentFolderDocumentPropertyPropertyValueItem) {
            // validation for constraint: itemType
            if (!$accessAttachmentFolderDocumentPropertyPropertyValueItem instanceof \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue) {
                $invalidValues[] = is_object($accessAttachmentFolderDocumentPropertyPropertyValueItem) ? get_class($accessAttachmentFolderDocumentPropertyPropertyValueItem) : sprintf('%s(%s)', gettype($accessAttachmentFolderDocumentPropertyPropertyValueItem), var_export($accessAttachmentFolderDocumentPropertyPropertyValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyValue property can only contain items of type \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyValue value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue[] $propertyValue
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function setPropertyValue(array $propertyValue = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyValueArrayErrorMessage = self::validatePropertyValueForArrayConstraintsFromSetPropertyValue($propertyValue))) {
            throw new \InvalidArgumentException($propertyValueArrayErrorMessage, __LINE__);
        }
        $this->PropertyValue = $propertyValue;
        return $this;
    }
    /**
     * Add item to PropertyValue value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue $item
     * @return \StructType\AccessAttachmentFolderDocumentProperty
     */
    public function addToPropertyValue(\StructType\AccessAttachmentFolderDocumentPropertyPropertyValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue) {
            throw new \InvalidArgumentException(sprintf('The PropertyValue property can only contain items of type \StructType\AccessAttachmentFolderDocumentPropertyPropertyValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyValue[] = $item;
        return $this;
    }
}
