<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessAttachmentFolderDocument StructType
 * @subpackage Structs
 */
class AccessAttachmentFolderDocument extends AbstractStructBase
{
    /**
     * The UUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $UUID;
    /**
     * The VersionID
     * Meta information extracted from the WSDL
     * - documentation: Identifier
     * - base: xsd:token
     * - maxLength: 32
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $VersionID;
    /**
     * The SystemAdministrativeData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SystemAdministrativeData
     */
    public $SystemAdministrativeData;
    /**
     * The LinkInternalIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $LinkInternalIndicator;
    /**
     * The CheckedOutIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $CheckedOutIndicator;
    /**
     * The VisibleIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $VisibleIndicator;
    /**
     * The VersioningEnabledIndicator
     * Meta information extracted from the WSDL
     * - documentation: Indicator
     * - base: xsd:boolean
     * - minOccurs: 0
     * @var bool
     */
    public $VersioningEnabledIndicator;
    /**
     * The CategoryCode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - length: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoryCode;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $CategoryName;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DocumentTypeCode
     */
    public $TypeCode;
    /**
     * The TypeName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $TypeName;
    /**
     * The MIMECode
     * Meta information extracted from the WSDL
     * - documentation: Code
     * - base: xsd:token
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $MIMECode;
    /**
     * The MIMEName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - maxLength: 80
     * - minOccurs: 0
     * @var string
     */
    public $MIMEName;
    /**
     * The PathName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $PathName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The AlternativeName
     * Meta information extracted from the WSDL
     * - documentation: Name
     * - base: xsd:string
     * - minOccurs: 0
     * @var string
     */
    public $AlternativeName;
    /**
     * The InternalLinkUUID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\UUID
     */
    public $InternalLinkUUID;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Description
     */
    public $Description;
    /**
     * The ExternalLinkWebURI
     * Meta information extracted from the WSDL
     * - documentation: URI
     * - base: xsd:anyURI
     * - minOccurs: 0
     * @var string
     */
    public $ExternalLinkWebURI;
    /**
     * The FileContentURI
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\URI
     */
    public $FileContentURI;
    /**
     * The FilesizeMeasure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Measure
     */
    public $FilesizeMeasure;
    /**
     * The Property
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AccessAttachmentFolderDocumentProperty[]
     */
    public $Property;
    /**
     * Constructor method for AccessAttachmentFolderDocument
     * @uses AccessAttachmentFolderDocument::setUUID()
     * @uses AccessAttachmentFolderDocument::setVersionID()
     * @uses AccessAttachmentFolderDocument::setSystemAdministrativeData()
     * @uses AccessAttachmentFolderDocument::setLinkInternalIndicator()
     * @uses AccessAttachmentFolderDocument::setCheckedOutIndicator()
     * @uses AccessAttachmentFolderDocument::setVisibleIndicator()
     * @uses AccessAttachmentFolderDocument::setVersioningEnabledIndicator()
     * @uses AccessAttachmentFolderDocument::setCategoryCode()
     * @uses AccessAttachmentFolderDocument::setCategoryName()
     * @uses AccessAttachmentFolderDocument::setTypeCode()
     * @uses AccessAttachmentFolderDocument::setTypeName()
     * @uses AccessAttachmentFolderDocument::setMIMECode()
     * @uses AccessAttachmentFolderDocument::setMIMEName()
     * @uses AccessAttachmentFolderDocument::setPathName()
     * @uses AccessAttachmentFolderDocument::setName()
     * @uses AccessAttachmentFolderDocument::setAlternativeName()
     * @uses AccessAttachmentFolderDocument::setInternalLinkUUID()
     * @uses AccessAttachmentFolderDocument::setDescription()
     * @uses AccessAttachmentFolderDocument::setExternalLinkWebURI()
     * @uses AccessAttachmentFolderDocument::setFileContentURI()
     * @uses AccessAttachmentFolderDocument::setFilesizeMeasure()
     * @uses AccessAttachmentFolderDocument::setProperty()
     * @param \StructType\UUID $uUID
     * @param string $versionID
     * @param \StructType\SystemAdministrativeData $systemAdministrativeData
     * @param bool $linkInternalIndicator
     * @param bool $checkedOutIndicator
     * @param bool $visibleIndicator
     * @param bool $versioningEnabledIndicator
     * @param string $categoryCode
     * @param string $categoryName
     * @param \StructType\DocumentTypeCode $typeCode
     * @param string $typeName
     * @param string $mIMECode
     * @param string $mIMEName
     * @param string $pathName
     * @param string $name
     * @param string $alternativeName
     * @param \StructType\UUID $internalLinkUUID
     * @param \StructType\Description $description
     * @param string $externalLinkWebURI
     * @param \StructType\URI $fileContentURI
     * @param \StructType\Measure $filesizeMeasure
     * @param \StructType\AccessAttachmentFolderDocumentProperty[] $property
     */
    public function __construct(\StructType\UUID $uUID = null, $versionID = null, \StructType\SystemAdministrativeData $systemAdministrativeData = null, $linkInternalIndicator = null, $checkedOutIndicator = null, $visibleIndicator = null, $versioningEnabledIndicator = null, $categoryCode = null, $categoryName = null, \StructType\DocumentTypeCode $typeCode = null, $typeName = null, $mIMECode = null, $mIMEName = null, $pathName = null, $name = null, $alternativeName = null, \StructType\UUID $internalLinkUUID = null, \StructType\Description $description = null, $externalLinkWebURI = null, \StructType\URI $fileContentURI = null, \StructType\Measure $filesizeMeasure = null, array $property = array())
    {
        $this
            ->setUUID($uUID)
            ->setVersionID($versionID)
            ->setSystemAdministrativeData($systemAdministrativeData)
            ->setLinkInternalIndicator($linkInternalIndicator)
            ->setCheckedOutIndicator($checkedOutIndicator)
            ->setVisibleIndicator($visibleIndicator)
            ->setVersioningEnabledIndicator($versioningEnabledIndicator)
            ->setCategoryCode($categoryCode)
            ->setCategoryName($categoryName)
            ->setTypeCode($typeCode)
            ->setTypeName($typeName)
            ->setMIMECode($mIMECode)
            ->setMIMEName($mIMEName)
            ->setPathName($pathName)
            ->setName($name)
            ->setAlternativeName($alternativeName)
            ->setInternalLinkUUID($internalLinkUUID)
            ->setDescription($description)
            ->setExternalLinkWebURI($externalLinkWebURI)
            ->setFileContentURI($fileContentURI)
            ->setFilesizeMeasure($filesizeMeasure)
            ->setProperty($property);
    }
    /**
     * Get UUID value
     * @return \StructType\UUID|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param \StructType\UUID $uUID
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setUUID(\StructType\UUID $uUID = null)
    {
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get VersionID value
     * @return string|null
     */
    public function getVersionID()
    {
        return $this->VersionID;
    }
    /**
     * Set VersionID value
     * @param string $versionID
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setVersionID($versionID = null)
    {
        // validation for constraint: string
        if (!is_null($versionID) && !is_string($versionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($versionID, true), gettype($versionID)), __LINE__);
        }
        // validation for constraint: maxLength(32)
        if (!is_null($versionID) && mb_strlen($versionID) > 32) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 32', mb_strlen($versionID)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($versionID) && mb_strlen($versionID) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($versionID)), __LINE__);
        }
        $this->VersionID = $versionID;
        return $this;
    }
    /**
     * Get SystemAdministrativeData value
     * @return \StructType\SystemAdministrativeData|null
     */
    public function getSystemAdministrativeData()
    {
        return $this->SystemAdministrativeData;
    }
    /**
     * Set SystemAdministrativeData value
     * @param \StructType\SystemAdministrativeData $systemAdministrativeData
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setSystemAdministrativeData(\StructType\SystemAdministrativeData $systemAdministrativeData = null)
    {
        $this->SystemAdministrativeData = $systemAdministrativeData;
        return $this;
    }
    /**
     * Get LinkInternalIndicator value
     * @return bool|null
     */
    public function getLinkInternalIndicator()
    {
        return $this->LinkInternalIndicator;
    }
    /**
     * Set LinkInternalIndicator value
     * @param bool $linkInternalIndicator
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setLinkInternalIndicator($linkInternalIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($linkInternalIndicator) && !is_bool($linkInternalIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($linkInternalIndicator, true), gettype($linkInternalIndicator)), __LINE__);
        }
        $this->LinkInternalIndicator = $linkInternalIndicator;
        return $this;
    }
    /**
     * Get CheckedOutIndicator value
     * @return bool|null
     */
    public function getCheckedOutIndicator()
    {
        return $this->CheckedOutIndicator;
    }
    /**
     * Set CheckedOutIndicator value
     * @param bool $checkedOutIndicator
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setCheckedOutIndicator($checkedOutIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkedOutIndicator) && !is_bool($checkedOutIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkedOutIndicator, true), gettype($checkedOutIndicator)), __LINE__);
        }
        $this->CheckedOutIndicator = $checkedOutIndicator;
        return $this;
    }
    /**
     * Get VisibleIndicator value
     * @return bool|null
     */
    public function getVisibleIndicator()
    {
        return $this->VisibleIndicator;
    }
    /**
     * Set VisibleIndicator value
     * @param bool $visibleIndicator
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setVisibleIndicator($visibleIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleIndicator) && !is_bool($visibleIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleIndicator, true), gettype($visibleIndicator)), __LINE__);
        }
        $this->VisibleIndicator = $visibleIndicator;
        return $this;
    }
    /**
     * Get VersioningEnabledIndicator value
     * @return bool|null
     */
    public function getVersioningEnabledIndicator()
    {
        return $this->VersioningEnabledIndicator;
    }
    /**
     * Set VersioningEnabledIndicator value
     * @param bool $versioningEnabledIndicator
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setVersioningEnabledIndicator($versioningEnabledIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($versioningEnabledIndicator) && !is_bool($versioningEnabledIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($versioningEnabledIndicator, true), gettype($versioningEnabledIndicator)), __LINE__);
        }
        $this->VersioningEnabledIndicator = $versioningEnabledIndicator;
        return $this;
    }
    /**
     * Get CategoryCode value
     * @return string|null
     */
    public function getCategoryCode()
    {
        return $this->CategoryCode;
    }
    /**
     * Set CategoryCode value
     * @param string $categoryCode
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setCategoryCode($categoryCode = null)
    {
        // validation for constraint: string
        if (!is_null($categoryCode) && !is_string($categoryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryCode, true), gettype($categoryCode)), __LINE__);
        }
        // validation for constraint: length(1)
        if (!is_null($categoryCode) && mb_strlen($categoryCode) !== 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be equal to 1', mb_strlen($categoryCode)), __LINE__);
        }
        $this->CategoryCode = $categoryCode;
        return $this;
    }
    /**
     * Get CategoryName value
     * @return string|null
     */
    public function getCategoryName()
    {
        return $this->CategoryName;
    }
    /**
     * Set CategoryName value
     * @param string $categoryName
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setCategoryName($categoryName = null)
    {
        // validation for constraint: string
        if (!is_null($categoryName) && !is_string($categoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryName, true), gettype($categoryName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($categoryName) && mb_strlen($categoryName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($categoryName)), __LINE__);
        }
        $this->CategoryName = $categoryName;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return \StructType\DocumentTypeCode|null
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param \StructType\DocumentTypeCode $typeCode
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setTypeCode(\StructType\DocumentTypeCode $typeCode = null)
    {
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get TypeName value
     * @return string|null
     */
    public function getTypeName()
    {
        return $this->TypeName;
    }
    /**
     * Set TypeName value
     * @param string $typeName
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setTypeName($typeName = null)
    {
        // validation for constraint: string
        if (!is_null($typeName) && !is_string($typeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeName, true), gettype($typeName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($typeName) && mb_strlen($typeName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($typeName)), __LINE__);
        }
        $this->TypeName = $typeName;
        return $this;
    }
    /**
     * Get MIMECode value
     * @return string|null
     */
    public function getMIMECode()
    {
        return $this->MIMECode;
    }
    /**
     * Set MIMECode value
     * @param string $mIMECode
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setMIMECode($mIMECode = null)
    {
        // validation for constraint: string
        if (!is_null($mIMECode) && !is_string($mIMECode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIMECode, true), gettype($mIMECode)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($mIMECode) && mb_strlen($mIMECode) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($mIMECode)), __LINE__);
        }
        $this->MIMECode = $mIMECode;
        return $this;
    }
    /**
     * Get MIMEName value
     * @return string|null
     */
    public function getMIMEName()
    {
        return $this->MIMEName;
    }
    /**
     * Set MIMEName value
     * @param string $mIMEName
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setMIMEName($mIMEName = null)
    {
        // validation for constraint: string
        if (!is_null($mIMEName) && !is_string($mIMEName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mIMEName, true), gettype($mIMEName)), __LINE__);
        }
        // validation for constraint: maxLength(80)
        if (!is_null($mIMEName) && mb_strlen($mIMEName) > 80) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 80', mb_strlen($mIMEName)), __LINE__);
        }
        $this->MIMEName = $mIMEName;
        return $this;
    }
    /**
     * Get PathName value
     * @return string|null
     */
    public function getPathName()
    {
        return $this->PathName;
    }
    /**
     * Set PathName value
     * @param string $pathName
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setPathName($pathName = null)
    {
        // validation for constraint: string
        if (!is_null($pathName) && !is_string($pathName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathName, true), gettype($pathName)), __LINE__);
        }
        $this->PathName = $pathName;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get AlternativeName value
     * @return string|null
     */
    public function getAlternativeName()
    {
        return $this->AlternativeName;
    }
    /**
     * Set AlternativeName value
     * @param string $alternativeName
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setAlternativeName($alternativeName = null)
    {
        // validation for constraint: string
        if (!is_null($alternativeName) && !is_string($alternativeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alternativeName, true), gettype($alternativeName)), __LINE__);
        }
        $this->AlternativeName = $alternativeName;
        return $this;
    }
    /**
     * Get InternalLinkUUID value
     * @return \StructType\UUID|null
     */
    public function getInternalLinkUUID()
    {
        return $this->InternalLinkUUID;
    }
    /**
     * Set InternalLinkUUID value
     * @param \StructType\UUID $internalLinkUUID
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setInternalLinkUUID(\StructType\UUID $internalLinkUUID = null)
    {
        $this->InternalLinkUUID = $internalLinkUUID;
        return $this;
    }
    /**
     * Get Description value
     * @return \StructType\Description|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param \StructType\Description $description
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setDescription(\StructType\Description $description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ExternalLinkWebURI value
     * @return string|null
     */
    public function getExternalLinkWebURI()
    {
        return $this->ExternalLinkWebURI;
    }
    /**
     * Set ExternalLinkWebURI value
     * @param string $externalLinkWebURI
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setExternalLinkWebURI($externalLinkWebURI = null)
    {
        // validation for constraint: string
        if (!is_null($externalLinkWebURI) && !is_string($externalLinkWebURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalLinkWebURI, true), gettype($externalLinkWebURI)), __LINE__);
        }
        $this->ExternalLinkWebURI = $externalLinkWebURI;
        return $this;
    }
    /**
     * Get FileContentURI value
     * @return \StructType\URI|null
     */
    public function getFileContentURI()
    {
        return $this->FileContentURI;
    }
    /**
     * Set FileContentURI value
     * @param \StructType\URI $fileContentURI
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setFileContentURI(\StructType\URI $fileContentURI = null)
    {
        $this->FileContentURI = $fileContentURI;
        return $this;
    }
    /**
     * Get FilesizeMeasure value
     * @return \StructType\Measure|null
     */
    public function getFilesizeMeasure()
    {
        return $this->FilesizeMeasure;
    }
    /**
     * Set FilesizeMeasure value
     * @param \StructType\Measure $filesizeMeasure
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setFilesizeMeasure(\StructType\Measure $filesizeMeasure = null)
    {
        $this->FilesizeMeasure = $filesizeMeasure;
        return $this;
    }
    /**
     * Get Property value
     * @return \StructType\AccessAttachmentFolderDocumentProperty[]|null
     */
    public function getProperty()
    {
        return $this->Property;
    }
    /**
     * This method is responsible for validating the values passed to the setProperty method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProperty method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyForArrayConstraintsFromSetProperty(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $accessAttachmentFolderDocumentPropertyItem) {
            // validation for constraint: itemType
            if (!$accessAttachmentFolderDocumentPropertyItem instanceof \StructType\AccessAttachmentFolderDocumentProperty) {
                $invalidValues[] = is_object($accessAttachmentFolderDocumentPropertyItem) ? get_class($accessAttachmentFolderDocumentPropertyItem) : sprintf('%s(%s)', gettype($accessAttachmentFolderDocumentPropertyItem), var_export($accessAttachmentFolderDocumentPropertyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Property property can only contain items of type \StructType\AccessAttachmentFolderDocumentProperty, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Property value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessAttachmentFolderDocumentProperty[] $property
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function setProperty(array $property = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyArrayErrorMessage = self::validatePropertyForArrayConstraintsFromSetProperty($property))) {
            throw new \InvalidArgumentException($propertyArrayErrorMessage, __LINE__);
        }
        $this->Property = $property;
        return $this;
    }
    /**
     * Add item to Property value
     * @throws \InvalidArgumentException
     * @param \StructType\AccessAttachmentFolderDocumentProperty $item
     * @return \StructType\AccessAttachmentFolderDocument
     */
    public function addToProperty(\StructType\AccessAttachmentFolderDocumentProperty $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccessAttachmentFolderDocumentProperty) {
            throw new \InvalidArgumentException(sprintf('The Property property can only contain items of type \StructType\AccessAttachmentFolderDocumentProperty, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Property[] = $item;
        return $this;
    }
}
