<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Upload ServiceType
 * @subpackage Services
 */
class Upload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UploadXMLFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadXMLInput $parameters
     * @return \StructType\UploadXMLResponse|bool
     */
    public function UploadXMLFile(\StructType\UploadXMLInput $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadXMLFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UploadXMLGetResult
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UploadXMLInputReference $parameters
     * @return \StructType\UploadXMLResponse|bool
     */
    public function UploadXMLGetResult(\StructType\UploadXMLInputReference $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UploadXMLGetResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UploadXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
