<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UploadXMLResponse StructType
 * @subpackage Structs
 */
class UploadXMLResponse extends AbstractStructBase
{
    /**
     * The resultValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $resultValue;
    /**
     * The resultMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resultMessage;
    /**
     * The resultReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resultReference;
    /**
     * The resultFile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $resultFile;
    /**
     * Constructor method for UploadXMLResponse
     * @uses UploadXMLResponse::setResultValue()
     * @uses UploadXMLResponse::setResultMessage()
     * @uses UploadXMLResponse::setResultReference()
     * @uses UploadXMLResponse::setResultFile()
     * @param int $resultValue
     * @param string $resultMessage
     * @param string $resultReference
     * @param string $resultFile
     */
    public function __construct($resultValue = null, $resultMessage = null, $resultReference = null, $resultFile = null)
    {
        $this
            ->setResultValue($resultValue)
            ->setResultMessage($resultMessage)
            ->setResultReference($resultReference)
            ->setResultFile($resultFile);
    }
    /**
     * Get resultValue value
     * @return int|null
     */
    public function getResultValue()
    {
        return $this->resultValue;
    }
    /**
     * Set resultValue value
     * @param int $resultValue
     * @return \StructType\UploadXMLResponse
     */
    public function setResultValue($resultValue = null)
    {
        // validation for constraint: int
        if (!is_null($resultValue) && !(is_int($resultValue) || ctype_digit($resultValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resultValue, true), gettype($resultValue)), __LINE__);
        }
        $this->resultValue = $resultValue;
        return $this;
    }
    /**
     * Get resultMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultMessage()
    {
        return isset($this->resultMessage) ? $this->resultMessage : null;
    }
    /**
     * Set resultMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultMessage
     * @return \StructType\UploadXMLResponse
     */
    public function setResultMessage($resultMessage = null)
    {
        // validation for constraint: string
        if (!is_null($resultMessage) && !is_string($resultMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultMessage, true), gettype($resultMessage)), __LINE__);
        }
        if (is_null($resultMessage) || (is_array($resultMessage) && empty($resultMessage))) {
            unset($this->resultMessage);
        } else {
            $this->resultMessage = $resultMessage;
        }
        return $this;
    }
    /**
     * Get resultReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultReference()
    {
        return isset($this->resultReference) ? $this->resultReference : null;
    }
    /**
     * Set resultReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultReference
     * @return \StructType\UploadXMLResponse
     */
    public function setResultReference($resultReference = null)
    {
        // validation for constraint: string
        if (!is_null($resultReference) && !is_string($resultReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultReference, true), gettype($resultReference)), __LINE__);
        }
        if (is_null($resultReference) || (is_array($resultReference) && empty($resultReference))) {
            unset($this->resultReference);
        } else {
            $this->resultReference = $resultReference;
        }
        return $this;
    }
    /**
     * Get resultFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultFile()
    {
        return isset($this->resultFile) ? $this->resultFile : null;
    }
    /**
     * Set resultFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultFile
     * @return \StructType\UploadXMLResponse
     */
    public function setResultFile($resultFile = null)
    {
        // validation for constraint: string
        if (!is_null($resultFile) && !is_string($resultFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultFile, true), gettype($resultFile)), __LINE__);
        }
        if (is_null($resultFile) || (is_array($resultFile) && empty($resultFile))) {
            unset($this->resultFile);
        } else {
            $this->resultFile = $resultFile;
        }
        return $this;
    }
}
