<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ddOutType StructType
 * @subpackage Structs
 */
class DdOutType extends AbstractStructBase
{
    /**
     * The meldungsId
     * @var int
     */
    public $meldungsId;
    /**
     * The meldezeitpunkt
     * @var string
     */
    public $meldezeitpunkt;
    /**
     * The kundenreferenz
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: [A-Za-z0-9_/\-\+\(\)\.,]{1,20}
     * @var string
     */
    public $kundenreferenz;
    /**
     * Constructor method for ddOutType
     * @uses DdOutType::setMeldungsId()
     * @uses DdOutType::setMeldezeitpunkt()
     * @uses DdOutType::setKundenreferenz()
     * @param int $meldungsId
     * @param string $meldezeitpunkt
     * @param string $kundenreferenz
     */
    public function __construct($meldungsId = null, $meldezeitpunkt = null, $kundenreferenz = null)
    {
        $this
            ->setMeldungsId($meldungsId)
            ->setMeldezeitpunkt($meldezeitpunkt)
            ->setKundenreferenz($kundenreferenz);
    }
    /**
     * Get meldungsId value
     * @return int|null
     */
    public function getMeldungsId()
    {
        return $this->meldungsId;
    }
    /**
     * Set meldungsId value
     * @param int $meldungsId
     * @return \StructType\DdOutType
     */
    public function setMeldungsId($meldungsId = null)
    {
        // validation for constraint: int
        if (!is_null($meldungsId) && !(is_int($meldungsId) || ctype_digit($meldungsId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($meldungsId, true), gettype($meldungsId)), __LINE__);
        }
        $this->meldungsId = $meldungsId;
        return $this;
    }
    /**
     * Get meldezeitpunkt value
     * @return string|null
     */
    public function getMeldezeitpunkt()
    {
        return $this->meldezeitpunkt;
    }
    /**
     * Set meldezeitpunkt value
     * @param string $meldezeitpunkt
     * @return \StructType\DdOutType
     */
    public function setMeldezeitpunkt($meldezeitpunkt = null)
    {
        // validation for constraint: string
        if (!is_null($meldezeitpunkt) && !is_string($meldezeitpunkt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($meldezeitpunkt, true), gettype($meldezeitpunkt)), __LINE__);
        }
        $this->meldezeitpunkt = $meldezeitpunkt;
        return $this;
    }
    /**
     * Get kundenreferenz value
     * @return string|null
     */
    public function getKundenreferenz()
    {
        return $this->kundenreferenz;
    }
    /**
     * Set kundenreferenz value
     * @param string $kundenreferenz
     * @return \StructType\DdOutType
     */
    public function setKundenreferenz($kundenreferenz = null)
    {
        // validation for constraint: string
        if (!is_null($kundenreferenz) && !is_string($kundenreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kundenreferenz, true), gettype($kundenreferenz)), __LINE__);
        }
        // validation for constraint: pattern([A-Za-z0-9_/\-\+\(\)\.,]{1,20})
        if (!is_null($kundenreferenz) && !preg_match('/[A-Za-z0-9_\/\\-\\+\\(\\)\\.,]{1,20}/', $kundenreferenz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Za-z0-9_/\-\+\(\)\.,]{1,20}', var_export($kundenreferenz, true)), __LINE__);
        }
        $this->kundenreferenz = $kundenreferenz;
        return $this;
    }
}
