<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for berichtigungType StructType
 * @subpackage Structs
 */
class BerichtigungType extends AbstractStructBase
{
    /**
     * The erlaeuterung
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 200
     * - minLength: 1
     * @var string
     */
    public $erlaeuterung;
    /**
     * Constructor method for berichtigungType
     * @uses BerichtigungType::setErlaeuterung()
     * @param string $erlaeuterung
     */
    public function __construct($erlaeuterung = null)
    {
        $this
            ->setErlaeuterung($erlaeuterung);
    }
    /**
     * Get erlaeuterung value
     * @return string|null
     */
    public function getErlaeuterung()
    {
        return $this->erlaeuterung;
    }
    /**
     * Set erlaeuterung value
     * @param string $erlaeuterung
     * @return \StructType\BerichtigungType
     */
    public function setErlaeuterung($erlaeuterung = null)
    {
        // validation for constraint: string
        if (!is_null($erlaeuterung) && !is_string($erlaeuterung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erlaeuterung, true), gettype($erlaeuterung)), __LINE__);
        }
        // validation for constraint: maxLength(200)
        if (!is_null($erlaeuterung) && mb_strlen($erlaeuterung) > 200) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 200', mb_strlen($erlaeuterung)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($erlaeuterung) && mb_strlen($erlaeuterung) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($erlaeuterung)), __LINE__);
        }
        $this->erlaeuterung = $erlaeuterung;
        return $this;
    }
}
