<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for artDesGeschaeftsType StructType
 * @subpackage Structs
 */
class ArtDesGeschaeftsType extends AbstractStructBase
{
    /**
     * The verkauf
     * Meta information extracted from the WSDL
     * - choice: verkauf | kauf | sonstiges
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmptyElementType
     */
    public $verkauf;
    /**
     * The kauf
     * Meta information extracted from the WSDL
     * - choice: verkauf | kauf | sonstiges
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmptyElementType
     */
    public $kauf;
    /**
     * The sonstiges
     * Meta information extracted from the WSDL
     * - choice: verkauf | kauf | sonstiges
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\GaSonstigesType
     */
    public $sonstiges;
    /**
     * The kennzeichnung
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kennzeichnung;
    /**
     * Constructor method for artDesGeschaeftsType
     * @uses ArtDesGeschaeftsType::setVerkauf()
     * @uses ArtDesGeschaeftsType::setKauf()
     * @uses ArtDesGeschaeftsType::setSonstiges()
     * @uses ArtDesGeschaeftsType::setKennzeichnung()
     * @param \StructType\EmptyElementType $verkauf
     * @param \StructType\EmptyElementType $kauf
     * @param \StructType\GaSonstigesType $sonstiges
     * @param string $kennzeichnung
     */
    public function __construct(\StructType\EmptyElementType $verkauf = null, \StructType\EmptyElementType $kauf = null, \StructType\GaSonstigesType $sonstiges = null, $kennzeichnung = null)
    {
        $this
            ->setVerkauf($verkauf)
            ->setKauf($kauf)
            ->setSonstiges($sonstiges)
            ->setKennzeichnung($kennzeichnung);
    }
    /**
     * Get verkauf value
     * @return \StructType\EmptyElementType|null
     */
    public function getVerkauf()
    {
        return isset($this->verkauf) ? $this->verkauf : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVerkauf method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVerkauf method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVerkaufForChoiceConstraintsFromSetVerkauf($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'kauf',
            'sonstiges',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property verkauf can\'t be set as the property %s is already set. Only one property must be set among these properties: verkauf, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set verkauf value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmptyElementType $verkauf
     * @return \StructType\ArtDesGeschaeftsType
     */
    public function setVerkauf(\StructType\EmptyElementType $verkauf = null)
    {
        // validation for constraint: choice(verkauf, kauf, sonstiges)
        if ('' !== ($verkaufChoiceErrorMessage = self::validateVerkaufForChoiceConstraintsFromSetVerkauf($verkauf))) {
            throw new \InvalidArgumentException($verkaufChoiceErrorMessage, __LINE__);
        }
        if (is_null($verkauf) || (is_array($verkauf) && empty($verkauf))) {
            unset($this->verkauf);
        } else {
            $this->verkauf = $verkauf;
        }
        return $this;
    }
    /**
     * Get kauf value
     * @return \StructType\EmptyElementType|null
     */
    public function getKauf()
    {
        return isset($this->kauf) ? $this->kauf : null;
    }
    /**
     * This method is responsible for validating the value passed to the setKauf method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKauf method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateKaufForChoiceConstraintsFromSetKauf($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'verkauf',
            'sonstiges',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property kauf can\'t be set as the property %s is already set. Only one property must be set among these properties: kauf, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set kauf value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmptyElementType $kauf
     * @return \StructType\ArtDesGeschaeftsType
     */
    public function setKauf(\StructType\EmptyElementType $kauf = null)
    {
        // validation for constraint: choice(verkauf, kauf, sonstiges)
        if ('' !== ($kaufChoiceErrorMessage = self::validateKaufForChoiceConstraintsFromSetKauf($kauf))) {
            throw new \InvalidArgumentException($kaufChoiceErrorMessage, __LINE__);
        }
        if (is_null($kauf) || (is_array($kauf) && empty($kauf))) {
            unset($this->kauf);
        } else {
            $this->kauf = $kauf;
        }
        return $this;
    }
    /**
     * Get sonstiges value
     * @return \StructType\GaSonstigesType|null
     */
    public function getSonstiges()
    {
        return isset($this->sonstiges) ? $this->sonstiges : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSonstiges method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSonstiges method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSonstigesForChoiceConstraintsFromSetSonstiges($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'verkauf',
            'kauf',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property sonstiges can\'t be set as the property %s is already set. Only one property must be set among these properties: sonstiges, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set sonstiges value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GaSonstigesType $sonstiges
     * @return \StructType\ArtDesGeschaeftsType
     */
    public function setSonstiges(\StructType\GaSonstigesType $sonstiges = null)
    {
        // validation for constraint: choice(verkauf, kauf, sonstiges)
        if ('' !== ($sonstigesChoiceErrorMessage = self::validateSonstigesForChoiceConstraintsFromSetSonstiges($sonstiges))) {
            throw new \InvalidArgumentException($sonstigesChoiceErrorMessage, __LINE__);
        }
        if (is_null($sonstiges) || (is_array($sonstiges) && empty($sonstiges))) {
            unset($this->sonstiges);
        } else {
            $this->sonstiges = $sonstiges;
        }
        return $this;
    }
    /**
     * Get kennzeichnung value
     * @return string|null
     */
    public function getKennzeichnung()
    {
        return $this->kennzeichnung;
    }
    /**
     * Set kennzeichnung value
     * @uses \EnumType\GaKennzeichnungType::valueIsValid()
     * @uses \EnumType\GaKennzeichnungType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kennzeichnung
     * @return \StructType\ArtDesGeschaeftsType
     */
    public function setKennzeichnung($kennzeichnung = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GaKennzeichnungType::valueIsValid($kennzeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GaKennzeichnungType', is_array($kennzeichnung) ? implode(', ', $kennzeichnung) : var_export($kennzeichnung, true), implode(', ', \EnumType\GaKennzeichnungType::getValidValues())), __LINE__);
        }
        $this->kennzeichnung = $kennzeichnung;
        return $this;
    }
}
