<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for personNameType StructType
 * @subpackage Structs
 */
class PersonNameType extends AbstractStructBase
{
    /**
     * The titel
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - choice: titel | vorname | nachname | firma
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 20
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $titel;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - choice: titel | vorname | nachname | firma
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $vorname;
    /**
     * The nachname
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - choice: titel | vorname | nachname | firma
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $nachname;
    /**
     * The firma
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - choice: titel | vorname | nachname | firma
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $firma;
    /**
     * Constructor method for personNameType
     * @uses PersonNameType::setTitel()
     * @uses PersonNameType::setVorname()
     * @uses PersonNameType::setNachname()
     * @uses PersonNameType::setFirma()
     * @param string $titel
     * @param string $vorname
     * @param string $nachname
     * @param string $firma
     */
    public function __construct($titel = null, $vorname = null, $nachname = null, $firma = null)
    {
        $this
            ->setTitel($titel)
            ->setVorname($vorname)
            ->setNachname($nachname)
            ->setFirma($firma);
    }
    /**
     * Get titel value
     * @return string|null
     */
    public function getTitel()
    {
        return isset($this->titel) ? $this->titel : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTitel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTitel method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTitelForChoiceConstraintsFromSetTitel($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'vorname',
            'nachname',
            'firma',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property titel can\'t be set as the property %s is already set. Only one property must be set among these properties: titel, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set titel value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $titel
     * @return \StructType\PersonNameType
     */
    public function setTitel($titel = null)
    {
        // validation for constraint: string
        if (!is_null($titel) && !is_string($titel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titel, true), gettype($titel)), __LINE__);
        }
        // validation for constraint: choice(titel, vorname, nachname, firma)
        if ('' !== ($titelChoiceErrorMessage = self::validateTitelForChoiceConstraintsFromSetTitel($titel))) {
            throw new \InvalidArgumentException($titelChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(20)
        if (!is_null($titel) && mb_strlen($titel) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 20', mb_strlen($titel)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titel) && mb_strlen($titel) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titel)), __LINE__);
        }
        if (is_null($titel) || (is_array($titel) && empty($titel))) {
            unset($this->titel);
        } else {
            $this->titel = $titel;
        }
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return isset($this->vorname) ? $this->vorname : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVorname method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVorname method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVornameForChoiceConstraintsFromSetVorname($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'titel',
            'nachname',
            'firma',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property vorname can\'t be set as the property %s is already set. Only one property must be set among these properties: vorname, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set vorname value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $vorname
     * @return \StructType\PersonNameType
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        // validation for constraint: choice(titel, vorname, nachname, firma)
        if ('' !== ($vornameChoiceErrorMessage = self::validateVornameForChoiceConstraintsFromSetVorname($vorname))) {
            throw new \InvalidArgumentException($vornameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($vorname) && mb_strlen($vorname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($vorname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($vorname) && mb_strlen($vorname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($vorname)), __LINE__);
        }
        if (is_null($vorname) || (is_array($vorname) && empty($vorname))) {
            unset($this->vorname);
        } else {
            $this->vorname = $vorname;
        }
        return $this;
    }
    /**
     * Get nachname value
     * @return string|null
     */
    public function getNachname()
    {
        return isset($this->nachname) ? $this->nachname : null;
    }
    /**
     * This method is responsible for validating the value passed to the setNachname method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNachname method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateNachnameForChoiceConstraintsFromSetNachname($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'titel',
            'vorname',
            'firma',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property nachname can\'t be set as the property %s is already set. Only one property must be set among these properties: nachname, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set nachname value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $nachname
     * @return \StructType\PersonNameType
     */
    public function setNachname($nachname = null)
    {
        // validation for constraint: string
        if (!is_null($nachname) && !is_string($nachname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nachname, true), gettype($nachname)), __LINE__);
        }
        // validation for constraint: choice(titel, vorname, nachname, firma)
        if ('' !== ($nachnameChoiceErrorMessage = self::validateNachnameForChoiceConstraintsFromSetNachname($nachname))) {
            throw new \InvalidArgumentException($nachnameChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($nachname) && mb_strlen($nachname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($nachname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($nachname) && mb_strlen($nachname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($nachname)), __LINE__);
        }
        if (is_null($nachname) || (is_array($nachname) && empty($nachname))) {
            unset($this->nachname);
        } else {
            $this->nachname = $nachname;
        }
        return $this;
    }
    /**
     * Get firma value
     * @return string|null
     */
    public function getFirma()
    {
        return isset($this->firma) ? $this->firma : null;
    }
    /**
     * This method is responsible for validating the value passed to the setFirma method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFirma method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateFirmaForChoiceConstraintsFromSetFirma($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'titel',
            'vorname',
            'nachname',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property firma can\'t be set as the property %s is already set. Only one property must be set among these properties: firma, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set firma value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $firma
     * @return \StructType\PersonNameType
     */
    public function setFirma($firma = null)
    {
        // validation for constraint: string
        if (!is_null($firma) && !is_string($firma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firma, true), gettype($firma)), __LINE__);
        }
        // validation for constraint: choice(titel, vorname, nachname, firma)
        if ('' !== ($firmaChoiceErrorMessage = self::validateFirmaForChoiceConstraintsFromSetFirma($firma))) {
            throw new \InvalidArgumentException($firmaChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($firma) && mb_strlen($firma) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($firma)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($firma) && mb_strlen($firma) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($firma)), __LINE__);
        }
        if (is_null($firma) || (is_array($firma) && empty($firma))) {
            unset($this->firma);
        } else {
            $this->firma = $firma;
        }
        return $this;
    }
}
