<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for handelsplatzType StructType
 * @subpackage Structs
 */
class HandelsplatzType extends AbstractStructBase
{
    /**
     * The handelsplatzname
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 50
     * - minLength: 1
     * @var string
     */
    public $handelsplatzname;
    /**
     * The handelsplatzcode
     * Meta information extracted from the WSDL
     * - documentation: Element im Format eines MIC-Codes nach ISO 10383 (Kombination aus 4 Grossbuchstaben oder Ziffern)
     * - base: xsd:string
     * - pattern: [A-Z0-9]{4,4}
     * @var string
     */
    public $handelsplatzcode;
    /**
     * Constructor method for handelsplatzType
     * @uses HandelsplatzType::setHandelsplatzname()
     * @uses HandelsplatzType::setHandelsplatzcode()
     * @param string $handelsplatzname
     * @param string $handelsplatzcode
     */
    public function __construct($handelsplatzname = null, $handelsplatzcode = null)
    {
        $this
            ->setHandelsplatzname($handelsplatzname)
            ->setHandelsplatzcode($handelsplatzcode);
    }
    /**
     * Get handelsplatzname value
     * @return string|null
     */
    public function getHandelsplatzname()
    {
        return $this->handelsplatzname;
    }
    /**
     * Set handelsplatzname value
     * @param string $handelsplatzname
     * @return \StructType\HandelsplatzType
     */
    public function setHandelsplatzname($handelsplatzname = null)
    {
        // validation for constraint: string
        if (!is_null($handelsplatzname) && !is_string($handelsplatzname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handelsplatzname, true), gettype($handelsplatzname)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($handelsplatzname) && mb_strlen($handelsplatzname) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($handelsplatzname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($handelsplatzname) && mb_strlen($handelsplatzname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($handelsplatzname)), __LINE__);
        }
        $this->handelsplatzname = $handelsplatzname;
        return $this;
    }
    /**
     * Get handelsplatzcode value
     * @return string|null
     */
    public function getHandelsplatzcode()
    {
        return $this->handelsplatzcode;
    }
    /**
     * Set handelsplatzcode value
     * @param string $handelsplatzcode
     * @return \StructType\HandelsplatzType
     */
    public function setHandelsplatzcode($handelsplatzcode = null)
    {
        // validation for constraint: string
        if (!is_null($handelsplatzcode) && !is_string($handelsplatzcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handelsplatzcode, true), gettype($handelsplatzcode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9]{4,4})
        if (!is_null($handelsplatzcode) && !preg_match('/[A-Z0-9]{4,4}/', $handelsplatzcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9]{4,4}', var_export($handelsplatzcode, true)), __LINE__);
        }
        $this->handelsplatzcode = $handelsplatzcode;
        return $this;
    }
}
