<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for emittentType StructType
 * @subpackage Structs
 */
class EmittentType extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - base: xsd:token
     * - maxLength: 100
     * - minLength: 1
     * @var string
     */
    public $name;
    /**
     * The lei
     * Meta information extracted from the WSDL
     * - documentation: Element im Format eines LEI-Codes nach ISO 17442 (Kombination aus 18 Grossbuchstaben oder Ziffern gefogt von 2 Ziffern)
     * - base: xsd:string
     * - minOccurs: 0
     * - pattern: [A-Z0-9]{18,18}[0-9]{2,2}
     * @var string
     */
    public $lei;
    /**
     * Constructor method for emittentType
     * @uses EmittentType::setName()
     * @uses EmittentType::setLei()
     * @param string $name
     * @param string $lei
     */
    public function __construct($name = null, $lei = null)
    {
        $this
            ->setName($name)
            ->setLei($lei);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\EmittentType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        // validation for constraint: maxLength(100)
        if (!is_null($name) && mb_strlen($name) > 100) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 100', mb_strlen($name)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($name) && mb_strlen($name) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get lei value
     * @return string|null
     */
    public function getLei()
    {
        return $this->lei;
    }
    /**
     * Set lei value
     * @param string $lei
     * @return \StructType\EmittentType
     */
    public function setLei($lei = null)
    {
        // validation for constraint: string
        if (!is_null($lei) && !is_string($lei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lei, true), gettype($lei)), __LINE__);
        }
        // validation for constraint: pattern([A-Z0-9]{18,18}[0-9]{2,2})
        if (!is_null($lei) && !preg_match('/[A-Z0-9]{18,18}[0-9]{2,2}/', $lei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z0-9]{18,18}[0-9]{2,2}', var_export($lei, true)), __LINE__);
        }
        $this->lei = $lei;
        return $this;
    }
}
