<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for aggregierteInformationenType StructType
 * @subpackage Structs
 */
class AggregierteInformationenType extends AbstractStructBase
{
    /**
     * The durchschnittspreis
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - choice: durchschnittspreis | durchschnittspreisWaehrung | durchschnittspreisNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 7
     * - minInclusive: 0
     * - totalDigits: 15
     * @var float
     */
    public $durchschnittspreis;
    /**
     * The durchschnittspreisWaehrung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: durchschnittspreis | durchschnittspreisWaehrung | durchschnittspreisNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [A-Z]{2,2}[A-Za-z]{1,1}
     * @var string
     */
    public $durchschnittspreisWaehrung;
    /**
     * The durchschnittspreisNichtBezifferbar
     * Meta information extracted from the WSDL
     * - choice: durchschnittspreis | durchschnittspreisWaehrung | durchschnittspreisNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmptyElementType
     */
    public $durchschnittspreisNichtBezifferbar;
    /**
     * The aggregiertesVolumen
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - choice: aggregiertesVolumen | aggregiertesVolumenWaehrung | aggregiertesVolumenNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - fractionDigits: 4
     * - minInclusive: 0
     * - totalDigits: 19
     * @var float
     */
    public $aggregiertesVolumen;
    /**
     * The aggregiertesVolumenWaehrung
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - choice: aggregiertesVolumen | aggregiertesVolumenWaehrung | aggregiertesVolumenNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - pattern: [A-Z]{2,2}[A-Za-z]{1,1}
     * @var string
     */
    public $aggregiertesVolumenWaehrung;
    /**
     * The aggregiertesVolumenNichtBezifferbar
     * Meta information extracted from the WSDL
     * - choice: aggregiertesVolumen | aggregiertesVolumenWaehrung | aggregiertesVolumenNichtBezifferbar
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * @var \StructType\EmptyElementType
     */
    public $aggregiertesVolumenNichtBezifferbar;
    /**
     * Constructor method for aggregierteInformationenType
     * @uses AggregierteInformationenType::setDurchschnittspreis()
     * @uses AggregierteInformationenType::setDurchschnittspreisWaehrung()
     * @uses AggregierteInformationenType::setDurchschnittspreisNichtBezifferbar()
     * @uses AggregierteInformationenType::setAggregiertesVolumen()
     * @uses AggregierteInformationenType::setAggregiertesVolumenWaehrung()
     * @uses AggregierteInformationenType::setAggregiertesVolumenNichtBezifferbar()
     * @param float $durchschnittspreis
     * @param string $durchschnittspreisWaehrung
     * @param \StructType\EmptyElementType $durchschnittspreisNichtBezifferbar
     * @param float $aggregiertesVolumen
     * @param string $aggregiertesVolumenWaehrung
     * @param \StructType\EmptyElementType $aggregiertesVolumenNichtBezifferbar
     */
    public function __construct($durchschnittspreis = null, $durchschnittspreisWaehrung = null, \StructType\EmptyElementType $durchschnittspreisNichtBezifferbar = null, $aggregiertesVolumen = null, $aggregiertesVolumenWaehrung = null, \StructType\EmptyElementType $aggregiertesVolumenNichtBezifferbar = null)
    {
        $this
            ->setDurchschnittspreis($durchschnittspreis)
            ->setDurchschnittspreisWaehrung($durchschnittspreisWaehrung)
            ->setDurchschnittspreisNichtBezifferbar($durchschnittspreisNichtBezifferbar)
            ->setAggregiertesVolumen($aggregiertesVolumen)
            ->setAggregiertesVolumenWaehrung($aggregiertesVolumenWaehrung)
            ->setAggregiertesVolumenNichtBezifferbar($aggregiertesVolumenNichtBezifferbar);
    }
    /**
     * Get durchschnittspreis value
     * @return float|null
     */
    public function getDurchschnittspreis()
    {
        return isset($this->durchschnittspreis) ? $this->durchschnittspreis : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDurchschnittspreis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDurchschnittspreis method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDurchschnittspreisForChoiceConstraintsFromSetDurchschnittspreis($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'durchschnittspreisWaehrung',
            'durchschnittspreisNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property durchschnittspreis can\'t be set as the property %s is already set. Only one property must be set among these properties: durchschnittspreis, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set durchschnittspreis value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $durchschnittspreis
     * @return \StructType\AggregierteInformationenType
     */
    public function setDurchschnittspreis($durchschnittspreis = null)
    {
        // validation for constraint: float
        if (!is_null($durchschnittspreis) && !(is_float($durchschnittspreis) || is_numeric($durchschnittspreis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($durchschnittspreis, true), gettype($durchschnittspreis)), __LINE__);
        }
        // validation for constraint: choice(durchschnittspreis, durchschnittspreisWaehrung, durchschnittspreisNichtBezifferbar)
        if ('' !== ($durchschnittspreisChoiceErrorMessage = self::validateDurchschnittspreisForChoiceConstraintsFromSetDurchschnittspreis($durchschnittspreis))) {
            throw new \InvalidArgumentException($durchschnittspreisChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(7)
        if (!is_null($durchschnittspreis) && mb_strlen(mb_substr($durchschnittspreis, false !== mb_strpos($durchschnittspreis, '.') ? mb_strpos($durchschnittspreis, '.') + 1 : mb_strlen($durchschnittspreis))) > 7) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 7 fraction digits, %d given', var_export($durchschnittspreis, true), mb_strlen(mb_substr($durchschnittspreis, mb_strpos($durchschnittspreis, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($durchschnittspreis) && $durchschnittspreis < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($durchschnittspreis, true)), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($durchschnittspreis) && mb_strlen(preg_replace('/(\D)/', '', $durchschnittspreis)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($durchschnittspreis, true), mb_strlen(preg_replace('/(\D)/', '', $durchschnittspreis))), __LINE__);
        }
        if (is_null($durchschnittspreis) || (is_array($durchschnittspreis) && empty($durchschnittspreis))) {
            unset($this->durchschnittspreis);
        } else {
            $this->durchschnittspreis = $durchschnittspreis;
        }
        return $this;
    }
    /**
     * Get durchschnittspreisWaehrung value
     * @return string|null
     */
    public function getDurchschnittspreisWaehrung()
    {
        return isset($this->durchschnittspreisWaehrung) ? $this->durchschnittspreisWaehrung : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDurchschnittspreisWaehrung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDurchschnittspreisWaehrung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDurchschnittspreisWaehrungForChoiceConstraintsFromSetDurchschnittspreisWaehrung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'durchschnittspreis',
            'durchschnittspreisNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property durchschnittspreisWaehrung can\'t be set as the property %s is already set. Only one property must be set among these properties: durchschnittspreisWaehrung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set durchschnittspreisWaehrung value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $durchschnittspreisWaehrung
     * @return \StructType\AggregierteInformationenType
     */
    public function setDurchschnittspreisWaehrung($durchschnittspreisWaehrung = null)
    {
        // validation for constraint: string
        if (!is_null($durchschnittspreisWaehrung) && !is_string($durchschnittspreisWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($durchschnittspreisWaehrung, true), gettype($durchschnittspreisWaehrung)), __LINE__);
        }
        // validation for constraint: choice(durchschnittspreis, durchschnittspreisWaehrung, durchschnittspreisNichtBezifferbar)
        if ('' !== ($durchschnittspreisWaehrungChoiceErrorMessage = self::validateDurchschnittspreisWaehrungForChoiceConstraintsFromSetDurchschnittspreisWaehrung($durchschnittspreisWaehrung))) {
            throw new \InvalidArgumentException($durchschnittspreisWaehrungChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,2}[A-Za-z]{1,1})
        if (!is_null($durchschnittspreisWaehrung) && !preg_match('/[A-Z]{2,2}[A-Za-z]{1,1}/', $durchschnittspreisWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,2}[A-Za-z]{1,1}', var_export($durchschnittspreisWaehrung, true)), __LINE__);
        }
        if (is_null($durchschnittspreisWaehrung) || (is_array($durchschnittspreisWaehrung) && empty($durchschnittspreisWaehrung))) {
            unset($this->durchschnittspreisWaehrung);
        } else {
            $this->durchschnittspreisWaehrung = $durchschnittspreisWaehrung;
        }
        return $this;
    }
    /**
     * Get durchschnittspreisNichtBezifferbar value
     * @return \StructType\EmptyElementType|null
     */
    public function getDurchschnittspreisNichtBezifferbar()
    {
        return isset($this->durchschnittspreisNichtBezifferbar) ? $this->durchschnittspreisNichtBezifferbar : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDurchschnittspreisNichtBezifferbar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDurchschnittspreisNichtBezifferbar method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDurchschnittspreisNichtBezifferbarForChoiceConstraintsFromSetDurchschnittspreisNichtBezifferbar($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'durchschnittspreis',
            'durchschnittspreisWaehrung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property durchschnittspreisNichtBezifferbar can\'t be set as the property %s is already set. Only one property must be set among these properties: durchschnittspreisNichtBezifferbar, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set durchschnittspreisNichtBezifferbar value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmptyElementType $durchschnittspreisNichtBezifferbar
     * @return \StructType\AggregierteInformationenType
     */
    public function setDurchschnittspreisNichtBezifferbar(\StructType\EmptyElementType $durchschnittspreisNichtBezifferbar = null)
    {
        // validation for constraint: choice(durchschnittspreis, durchschnittspreisWaehrung, durchschnittspreisNichtBezifferbar)
        if ('' !== ($durchschnittspreisNichtBezifferbarChoiceErrorMessage = self::validateDurchschnittspreisNichtBezifferbarForChoiceConstraintsFromSetDurchschnittspreisNichtBezifferbar($durchschnittspreisNichtBezifferbar))) {
            throw new \InvalidArgumentException($durchschnittspreisNichtBezifferbarChoiceErrorMessage, __LINE__);
        }
        if (is_null($durchschnittspreisNichtBezifferbar) || (is_array($durchschnittspreisNichtBezifferbar) && empty($durchschnittspreisNichtBezifferbar))) {
            unset($this->durchschnittspreisNichtBezifferbar);
        } else {
            $this->durchschnittspreisNichtBezifferbar = $durchschnittspreisNichtBezifferbar;
        }
        return $this;
    }
    /**
     * Get aggregiertesVolumen value
     * @return float|null
     */
    public function getAggregiertesVolumen()
    {
        return isset($this->aggregiertesVolumen) ? $this->aggregiertesVolumen : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAggregiertesVolumen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAggregiertesVolumen method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAggregiertesVolumenForChoiceConstraintsFromSetAggregiertesVolumen($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'aggregiertesVolumenWaehrung',
            'aggregiertesVolumenNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property aggregiertesVolumen can\'t be set as the property %s is already set. Only one property must be set among these properties: aggregiertesVolumen, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set aggregiertesVolumen value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param float $aggregiertesVolumen
     * @return \StructType\AggregierteInformationenType
     */
    public function setAggregiertesVolumen($aggregiertesVolumen = null)
    {
        // validation for constraint: float
        if (!is_null($aggregiertesVolumen) && !(is_float($aggregiertesVolumen) || is_numeric($aggregiertesVolumen))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aggregiertesVolumen, true), gettype($aggregiertesVolumen)), __LINE__);
        }
        // validation for constraint: choice(aggregiertesVolumen, aggregiertesVolumenWaehrung, aggregiertesVolumenNichtBezifferbar)
        if ('' !== ($aggregiertesVolumenChoiceErrorMessage = self::validateAggregiertesVolumenForChoiceConstraintsFromSetAggregiertesVolumen($aggregiertesVolumen))) {
            throw new \InvalidArgumentException($aggregiertesVolumenChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: fractionDigits(4)
        if (!is_null($aggregiertesVolumen) && mb_strlen(mb_substr($aggregiertesVolumen, false !== mb_strpos($aggregiertesVolumen, '.') ? mb_strpos($aggregiertesVolumen, '.') + 1 : mb_strlen($aggregiertesVolumen))) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 4 fraction digits, %d given', var_export($aggregiertesVolumen, true), mb_strlen(mb_substr($aggregiertesVolumen, mb_strpos($aggregiertesVolumen, '.') + 1))), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($aggregiertesVolumen) && $aggregiertesVolumen < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($aggregiertesVolumen, true)), __LINE__);
        }
        // validation for constraint: totalDigits(19)
        if (!is_null($aggregiertesVolumen) && mb_strlen(preg_replace('/(\D)/', '', $aggregiertesVolumen)) > 19) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 19 digits, "%d" given', var_export($aggregiertesVolumen, true), mb_strlen(preg_replace('/(\D)/', '', $aggregiertesVolumen))), __LINE__);
        }
        if (is_null($aggregiertesVolumen) || (is_array($aggregiertesVolumen) && empty($aggregiertesVolumen))) {
            unset($this->aggregiertesVolumen);
        } else {
            $this->aggregiertesVolumen = $aggregiertesVolumen;
        }
        return $this;
    }
    /**
     * Get aggregiertesVolumenWaehrung value
     * @return string|null
     */
    public function getAggregiertesVolumenWaehrung()
    {
        return isset($this->aggregiertesVolumenWaehrung) ? $this->aggregiertesVolumenWaehrung : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAggregiertesVolumenWaehrung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAggregiertesVolumenWaehrung method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAggregiertesVolumenWaehrungForChoiceConstraintsFromSetAggregiertesVolumenWaehrung($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'aggregiertesVolumen',
            'aggregiertesVolumenNichtBezifferbar',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property aggregiertesVolumenWaehrung can\'t be set as the property %s is already set. Only one property must be set among these properties: aggregiertesVolumenWaehrung, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set aggregiertesVolumenWaehrung value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param string $aggregiertesVolumenWaehrung
     * @return \StructType\AggregierteInformationenType
     */
    public function setAggregiertesVolumenWaehrung($aggregiertesVolumenWaehrung = null)
    {
        // validation for constraint: string
        if (!is_null($aggregiertesVolumenWaehrung) && !is_string($aggregiertesVolumenWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aggregiertesVolumenWaehrung, true), gettype($aggregiertesVolumenWaehrung)), __LINE__);
        }
        // validation for constraint: choice(aggregiertesVolumen, aggregiertesVolumenWaehrung, aggregiertesVolumenNichtBezifferbar)
        if ('' !== ($aggregiertesVolumenWaehrungChoiceErrorMessage = self::validateAggregiertesVolumenWaehrungForChoiceConstraintsFromSetAggregiertesVolumenWaehrung($aggregiertesVolumenWaehrung))) {
            throw new \InvalidArgumentException($aggregiertesVolumenWaehrungChoiceErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2,2}[A-Za-z]{1,1})
        if (!is_null($aggregiertesVolumenWaehrung) && !preg_match('/[A-Z]{2,2}[A-Za-z]{1,1}/', $aggregiertesVolumenWaehrung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2,2}[A-Za-z]{1,1}', var_export($aggregiertesVolumenWaehrung, true)), __LINE__);
        }
        if (is_null($aggregiertesVolumenWaehrung) || (is_array($aggregiertesVolumenWaehrung) && empty($aggregiertesVolumenWaehrung))) {
            unset($this->aggregiertesVolumenWaehrung);
        } else {
            $this->aggregiertesVolumenWaehrung = $aggregiertesVolumenWaehrung;
        }
        return $this;
    }
    /**
     * Get aggregiertesVolumenNichtBezifferbar value
     * @return \StructType\EmptyElementType|null
     */
    public function getAggregiertesVolumenNichtBezifferbar()
    {
        return isset($this->aggregiertesVolumenNichtBezifferbar) ? $this->aggregiertesVolumenNichtBezifferbar : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAggregiertesVolumenNichtBezifferbar method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAggregiertesVolumenNichtBezifferbar method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAggregiertesVolumenNichtBezifferbarForChoiceConstraintsFromSetAggregiertesVolumenNichtBezifferbar($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'aggregiertesVolumen',
            'aggregiertesVolumenWaehrung',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property aggregiertesVolumenNichtBezifferbar can\'t be set as the property %s is already set. Only one property must be set among these properties: aggregiertesVolumenNichtBezifferbar, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set aggregiertesVolumenNichtBezifferbar value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmptyElementType $aggregiertesVolumenNichtBezifferbar
     * @return \StructType\AggregierteInformationenType
     */
    public function setAggregiertesVolumenNichtBezifferbar(\StructType\EmptyElementType $aggregiertesVolumenNichtBezifferbar = null)
    {
        // validation for constraint: choice(aggregiertesVolumen, aggregiertesVolumenWaehrung, aggregiertesVolumenNichtBezifferbar)
        if ('' !== ($aggregiertesVolumenNichtBezifferbarChoiceErrorMessage = self::validateAggregiertesVolumenNichtBezifferbarForChoiceConstraintsFromSetAggregiertesVolumenNichtBezifferbar($aggregiertesVolumenNichtBezifferbar))) {
            throw new \InvalidArgumentException($aggregiertesVolumenNichtBezifferbarChoiceErrorMessage, __LINE__);
        }
        if (is_null($aggregiertesVolumenNichtBezifferbar) || (is_array($aggregiertesVolumenNichtBezifferbar) && empty($aggregiertesVolumenNichtBezifferbar))) {
            unset($this->aggregiertesVolumenNichtBezifferbar);
        } else {
            $this->aggregiertesVolumenNichtBezifferbar = $aggregiertesVolumenNichtBezifferbar;
        }
        return $this;
    }
}
